﻿<%@ Page Title="在线留言管理" Language="C#" MasterPageFile="~/Others/AdminMasterPage.Master" AutoEventWireup="true" CodeBehind="LeaveMessageManage.aspx.cs" Inherits="Web.Admin.Contents.LeaveMessageManage" %>

 <%@ Register Assembly="BX.Common" Namespace="Common" TagPrefix="cc1" %>
<asp:Content ID="Content1" ContentPlaceHolderID="AdminContentHead" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="AdminContentCenter" runat="server">
    <form id="form1" runat="server">
        <asp:ObjectDataSource ID="ObjectDataSource1" runat="server" EnablePaging="True"
            SelectMethod="List" TypeName="Logic.LeaveMessage" SelectCountMethod="Count" DeleteMethod="Delete">
            <DeleteParameters>
                <asp:Parameter DbType="Int32" Name="messageId" />
            </DeleteParameters>
            <SelectParameters>
                <asp:QueryStringParameter DefaultValue="0" Name="userId"
                    Type="Int32" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <div class="DivRightCenter">
            <div class="listdiv">
                <div class="grid-title">
                    <div class="grid-title-text">
                        <h4>
                            <span>在线留言管理</span>
                        </h4>
                    </div>
                </div>
                <div class="grid-list">
                    <cc1:ExtendedGridView ID="ExtendedGridView1" runat="server" AllowPaging="True" AutoGenerateColumns="False"
                        CssClass="grid" PageSize="20" DataSourceID="ObjectDataSource1" EnableTheming="False" ItemName="在线留言管理" CheckBox="False" CheckBoxDataIndex="0" DisableShortcuts="False" DataKeyNames="MessageID">
                        <AlternatingRowStyle CssClass="tr2"></AlternatingRowStyle>
                        <Columns>
                            <asp:BoundField DataField="MessageID" HeaderText="ID" />
                            <asp:BoundField DataField="Title" HeaderText="标题" />
                            <asp:TemplateField HeaderText="状态">
                                <ItemTemplate>
                                    <%# Eval("Status")==DBNull.Value || Eval("Status")==null || Eval("Status").Equals(1)?"":"隐藏"%>
                                </ItemTemplate>
                                <ItemStyle Width="50px" Wrap="False" />
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="查看">
                                <ItemTemplate>
                                    <%# Eval("ViewStatus")==DBNull.Value || Eval("ViewStatus")==null || DataBinder.Eval(Container.DataItem, "ViewStatus").Equals(1)?"未读":"已读"%>
                                </ItemTemplate>
                                <ItemStyle Width="50px" Wrap="False" />
                            </asp:TemplateField>
                            <asp:BoundField DataField="Contact" HeaderText="联系人">
                                <ItemStyle Width="50px" Wrap="False" />
                            </asp:BoundField>
                            <asp:BoundField DataField="CreateDate" HeaderText="留言时间">
                                <ItemStyle Width="100px" Wrap="False" />
                            </asp:BoundField>
                           <asp:TemplateField HeaderText="回复">
                                <ItemTemplate>
                                    <%# DataBinder.Eval(Container.DataItem, "ReplyContent")!=null && DataBinder.Eval(Container.DataItem, "ReplyContent")!=""?"已回复":""%>
                                </ItemTemplate>
                                <ItemStyle Width="50px" Wrap="False" />
                            </asp:TemplateField>

                            <asp:TemplateField HeaderText="操作">
                                <ItemTemplate>
                                    <asp:LinkButton ID="LinkButton2" runat="server" CommandName="Delete" OnClientClick='javascript:return confirm("确定删除？")' Text="删除" CausesValidation="false"></asp:LinkButton>
                                    &nbsp;<a href='<%#"LeaveMessageEdit.aspx?messageid="+DataBinder.Eval(Container.DataItem,"MessageID") %>'>查看</a>
                                </ItemTemplate>
                                <ItemStyle Width="100px" Wrap="False" />
                            </asp:TemplateField>
                        </Columns>

                        <HeaderStyle HorizontalAlign="Center" Wrap="False" CssClass="gridhead"></HeaderStyle>

                        <RowStyle HorizontalAlign="Center" CssClass="tr1"></RowStyle>
                    </cc1:ExtendedGridView>
                </div>
            </div>
            <br />
        </div>
        <br />
        <br />
    </form>
</asp:Content>
