﻿<%@ Page Title="接收消息管理" Language="C#" MasterPageFile="~/Others/AdminMasterPage.Master" AutoEventWireup="true" CodeBehind="MessageInboxManage.aspx.cs" Inherits="Web.Admin.Contents.Message.MessageInboxManage" %>

<%@ Register Assembly="BX.Common" Namespace="Common" TagPrefix="cc1" %>
<asp:Content ID="Content1" ContentPlaceHolderID="AdminContentHead" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="AdminContentCenter" runat="server">
    <form id="form1" runat="server">
        <asp:ObjectDataSource ID="ObjectDataSource1" runat="server" EnablePaging="True"
            SelectMethod="InboxList" TypeName="Logic.Message" SelectCountMethod="InboxCount" DeleteMethod="InboxUpdate" UpdateMethod="InboxInsert">
            <UpdateParameters>
                <asp:Parameter DbType="Int32" Name="receiveID" DefaultValue="0" />
                <asp:Parameter DbType="Int32" Name="messageId" />  
            </UpdateParameters>
            <DeleteParameters>
                <asp:Parameter DbType="Int32" Name="receiveID" DefaultValue="0" />
                <asp:Parameter DbType="Int32" Name="messageId" /> 
                <asp:Parameter DbType="Int32" Name="status" DefaultValue="-1" /> 
            </DeleteParameters>
            <SelectParameters>
                <asp:QueryStringParameter DefaultValue="0" Name="startType"
                    Type="Int32" />
                <asp:QueryStringParameter DefaultValue="30" Name="endType"
                    Type="Int32" />
                <asp:QueryStringParameter DefaultValue="0" Name="receiveID"
                    Type="Int32" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <div class="DivRightCenter">
            <div class="listdiv">
                <div class="grid-title">
                    <div class="grid-title-text">
                        <h4>
                            <span>短消息收件箱</span>
                        </h4>
                    </div>
                </div>
                <div class="grid-list">
                    <cc1:ExtendedGridView ID="ExtendedGridView1" runat="server" AllowPaging="True" AutoGenerateColumns="False"
                        CssClass="grid" PageSize="20" DataSourceID="ObjectDataSource1" EnableTheming="False" ItemName="在线留言管理" CheckBox="False" CheckBoxDataIndex="0" DisableShortcuts="False" DataKeyNames="MessageID">
                        <AlternatingRowStyle CssClass="tr2"></AlternatingRowStyle>
                        <Columns>  
                            <asp:BoundField DataField="MessageContent" HeaderText="消息内容" />
                            <asp:TemplateField HeaderText="消息类型">
                                <ItemTemplate>
                                    <%# DataBinder.Eval(Container.DataItem, "Type")%>
                                </ItemTemplate>
                                <ItemStyle Width="50px" Wrap="False" />
                            </asp:TemplateField>
                            <asp:BoundField DataField="CreateTime" HeaderText="发送时间">
                                <ItemStyle Width="100px" Wrap="False" />
                            </asp:BoundField>
                           <asp:TemplateField HeaderText="状态">
                                <ItemTemplate>
                                    <%# DataBinder.Eval(Container.DataItem, "ReceiveStatus")==null?"未读":"已读"%>
                                </ItemTemplate>
                                <ItemStyle Width="50px" Wrap="False" />
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="操作">
                                <ItemTemplate>
                                    <asp:LinkButton ID="btnDelete" runat="server" CommandName="Delete" OnClientClick='javascript:return confirm("确定删除？")' Text="删除" CausesValidation="false"></asp:LinkButton>
                                    &nbsp;  <asp:LinkButton ID="btnReadStatus" runat="server" CommandName="Update" Text="标记为已读" CausesValidation="false"></asp:LinkButton>
                                </ItemTemplate>
                                <ItemStyle Width="100px" Wrap="False" />
                            </asp:TemplateField>
                        </Columns> 

                        <HeaderStyle HorizontalAlign="Center" Wrap="False" CssClass="gridhead"></HeaderStyle>

                        <RowStyle HorizontalAlign="Center" CssClass="tr1"></RowStyle>
                    </cc1:ExtendedGridView>
                    
                </div>
            </div>
            <br />
        </div>
        <br />
        <br />
    </form>
</asp:Content>
