﻿<%@ Page Title="单页文章管理" StylesheetTheme="AdminSkin" Language="C#" MasterPageFile="~/Others/AdminMasterPage.Master" AutoEventWireup="true" CodeBehind="SingleArticleManage.aspx.cs" Inherits="Solution.Admin.Contents.SingleArticleManage" %>

<%@ Register Assembly="BX.Common" Namespace="Common" TagPrefix="cc1" %>
<asp:Content ID="Content1" ContentPlaceHolderID="AdminContentHead" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="AdminContentCenter" runat="server">
    <form id="form1" runat="server">
        <asp:ObjectDataSource ID="ObjectDataSourceArticle" runat="server" EnablePaging="True"
            SelectMethod="SingleArticleList" DeleteMethod="DeleteSingleArticle" TypeName="Logic.Article" SelectCountMethod="CountSingleArticle">
            <DeleteParameters>
                <asp:Parameter Name="id" Type="Int32" />
            </DeleteParameters>
            <SelectParameters>
                <asp:QueryStringParameter DefaultValue="0" Name="category" QueryStringField="category"
                    Type="String" />
                <asp:QueryStringParameter DefaultValue="0" Name="keywords" QueryStringField="keywords"
                    Type="String" />
                <asp:QueryStringParameter DefaultValue="0" Name="conditional" QueryStringField="conditional"
                    Type="string" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <div class="DivRightCenter">
            <div class="listdiv">
                <div class="grid-title">
                    <div class="grid-title-text">
                        <h4>
                            <span>单页文章管理</span>
                        </h4>
                    </div>
                    <div class="grid-title-menu">
                        <ul>
                            <li><a href="SingleArticleManage.aspx"><span>所有链接</span></a></li>
                            <li><a href="SingleArticleManage.aspx?conditional=equare&category=Status&keywords=1"><span>显示状态</span></a></li>
                            <li><a href="SingleArticleManage.aspx?conditional=equare&category=Status&keywords=0"><span>隐藏状态</span></a></li>
                        </ul>
                    </div>
                </div>
                <div class="grid-search">
                    Search:
                       <div class="grid-searchcontent">
                           <div class="userddl">
                               <ul>
                                   <li class="userddl-li">
                                       <input style="width: 40px;" class="ddltext" value="" id="ddlSearchOption" type="text" /><a href="javascript:" class="ddlarrow"></a></li>
                               </ul>
                           </div>
                           <input class="searchtext" id="txtKeywords" onkeypress="if(event.keyCode==13){ListSearch();}" type="text" /><input class="searchbutton" id="Button6" type="button" value="" onclick="ListSearch();" />
                       </div>
                </div>
                <div class="grid-list">
                    <cc1:ExtendedGridView ID="ExtendedGridView1" runat="server" AllowPaging="True" AutoGenerateColumns="False"
                        CssClass="grid" DataSourceID="ObjectDataSourceArticle" EnableTheming="False" PageSize="20" DataKeyNames="ID" ItemName="单页文章管理列表" CheckBox="False" CheckBoxDataIndex="0">
                        <Columns>
                            <asp:BoundField DataField="ID" HeaderText="ID" />
                            <asp:BoundField DataField="Title" HeaderText="标题" />
                            <asp:BoundField DataField="Alias" HeaderText="别称" />
                            <asp:BoundField DataField="UpdateDate" HeaderText="更新时间">
                                <ItemStyle Width="100px" Wrap="False" />
                            </asp:BoundField>

                            <asp:TemplateField HeaderText="状态">
                                <ItemTemplate>
                                    <%#DataBinder.Eval(Container.DataItem, "Status").Equals(1)?"显示":"隐藏"%>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:BoundField DataField="Editor" HeaderText="编辑人">
                                <ItemStyle Width="50px" Wrap="False" />
                            </asp:BoundField>
                            <asp:TemplateField HeaderText="操作">
                                <ItemTemplate>
                                    <asp:LinkButton ID="LinkButton2" runat="server" CommandName="Delete" OnClientClick='javascript:return confirm("确定删除？")' Text="删除" CausesValidation="false"></asp:LinkButton>
                                    <a href='<%#"SingleArticleEdit.aspx?articleid="+DataBinder.Eval(Container.DataItem,"ID") %>'>修改</a>
                                </ItemTemplate>
                            </asp:TemplateField>
                        </Columns>
                    </cc1:ExtendedGridView>
                </div>
            </div>
            <div class="FormButtonArea">
                <asp:Button ID="Button1" runat="server" UseSubmitBehavior="false" OnClientClick="document.location.href='SingleArticleEdit.aspx';return false;"
                    Text="添加新文章" />&nbsp;&nbsp;
            &nbsp;&nbsp;
            </div>
            <script type="text/javascript">
                var searchOption = new DropDownList("ddlSearchOption");
                searchOption.initial({ "标题": "Title" }, { "extend": true });
                function ListSearch() {
                    var keywords = document.getElementById("txtKeywords").value;
                    if (keywords != "") {
                        window.location.href = "SingleArticleManage.aspx?category=" + searchOption.get() + "&keywords=" + encodeURI(keywords);
                    } else {
                        window.location.href = "SingleArticleManage.aspx";
                    }
                }
            </script>
        </div>
    </form>
</asp:Content>
