﻿<%@ Page Title="网站基本配置编辑" StylesheetTheme="AdminSkin" ValidateRequest="false" Language="C#" MasterPageFile="~/Others/AdminMasterPage.Master" AutoEventWireup="true" CodeBehind="SiteConfigEdit.aspx.cs" Inherits="Solution.Admin.Contents.SiteConfigEdit" %>

<asp:Content ID="Content1" ContentPlaceHolderID="AdminContentHead" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="AdminContentCenter" runat="server">
    <form id="form1" runat="server">
        <div class="DivRightCenter">
            <div class="formtextfield">
                <div class="title">
                    <h4><span>网站基本配置编辑</span></h4>
                </div>
                <div class="content">
                    <table width="100%" border="0" cellpadding="0" cellspacing="0">
                        <tr>
                            <td class="fieldname">网站名称:
                            </td>
                            <td class="fieldvalue">
                                <asp:TextBox ID="SiteName" runat="server" Width="260" CssClass="text form-validate"></asp:TextBox>
                                <asp:CustomValidator ControlToValidate="SiteName" ClientValidationFunction="Validator.NonEmpty" ErrorMessage="不能为空" ValidateEmptyText="true" CssClass="fielderror" runat="server"></asp:CustomValidator>
                            </td>
                            <td class="fielddescription"></td>
                        </tr>
                        <tr>
                            <td class="fieldname">站点域名:
                            </td>
                            <td class="fieldvalue">
                                <asp:TextBox ID="DomainName" runat="server" Width="260" CssClass="text form-validate" placeholder="http://"></asp:TextBox>
                                <asp:CustomValidator ControlToValidate="DomainName" ClientValidationFunction="Validator.NonEmpty" ErrorMessage="不能为空" ValidateEmptyText="true" CssClass="fielderror" runat="server"></asp:CustomValidator>
                            </td>
                            <td class="fielddescription"></td>
                        </tr>
                        <tr>
                            <td class="fieldname">移动端域名:
                            </td>
                            <td class="fieldvalue">
                                <asp:TextBox ID="MobileDomainName" runat="server" Width="260" Text="" placeholder="http://"></asp:TextBox>
                            </td>
                            <td class="fielddescription">如果为空，则表示不支持</td>
                        </tr>
                        <tr style="display: none;">
                            <td class="fieldname">Logo:
                            </td>
                            <td class="fieldvalue">
                                <asp:TextBox ID="txtLogo" runat="server" Width="260" TextMode="SingleLine"></asp:TextBox>
                            </td>
                            <td class="fielddescription"></td>
                        </tr>
                        <tr>
                            <td class="fieldname">网站标题:
                            </td>
                            <td class="fieldvalue">
                                <asp:TextBox ID="SiteTitle" runat="server" Width="260"></asp:TextBox>
                            </td>
                            <td class="fielddescription"></td>
                        </tr>
                        <tr>
                            <td class="fieldname">SEO关键词:
                            </td>
                            <td class="fieldvalue">
                                <asp:TextBox ID="Keywords" runat="server" Width="428" Height="40" TextMode="MultiLine"></asp:TextBox>
                            </td>
                            <td class="fielddescription"></td>
                        </tr>
                        <tr>
                            <td class="fieldname">SEO描述:
                            </td>
                            <td class="fieldvalue">
                                <asp:TextBox ID="Description" runat="server" Width="428" Height="40" TextMode="MultiLine"></asp:TextBox>
                            </td>
                            <td class="fielddescription"></td>
                        </tr>
                        <tr>
                            <td class="fieldname">版权信息:
                            </td>
                            <td class="fieldvalue">
                                <asp:TextBox ID="Copyright" runat="server" Width="428" Height="40" TextMode="MultiLine"></asp:TextBox>
                            </td>
                            <td class="fielddescription"></td>
                        </tr>
                        <tr>
                            <td class="fieldname">备案号:
                            </td>
                            <td class="fieldvalue">
                                <asp:TextBox ID="RecordNo" runat="server" Width="428"></asp:TextBox>
                            </td>
                            <td class="fielddescription"></td>
                        </tr>
                        <tr>
                            <td class="fieldname">统计代码:
                            </td>
                            <td class="fieldvalue">
                                <asp:TextBox ID="StatisticalCode" runat="server" Width="428" Height="40" TextMode="MultiLine"></asp:TextBox>
                            </td>
                            <td class="fielddescription"></td>
                        </tr>
                        <tr>
                            <td class="fieldname">单点登录:
                            </td>
                            <td class="fieldvalue">
                                <asp:DropDownList ID="SingleSignOn" runat="server">
                                    <asp:ListItem Value="local" Selected="True">本地</asp:ListItem>
                                    <asp:ListItem Value="ucenter">Discuz</asp:ListItem>
                                </asp:DropDownList>
                            </td>
                        </tr>
                        <tr>
                            <td class="fieldname">验证码样式:
                            </td>
                            <td class="fieldvalue">
                                <asp:DropDownList ID="VerificationCodeStyle" runat="server">
                                    <asp:ListItem Value="digit" Selected="True">数字</asp:ListItem>
                                    <asp:ListItem Value="digitchar">数字和字母</asp:ListItem>
                                    <asp:ListItem Value="calculation">计算题</asp:ListItem>
                                    <asp:ListItem Value="chinese">汉字</asp:ListItem>
                                </asp:DropDownList>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
            <div class="formtextfield">
                <div class="title">
                    <h4><span>个性化配置</span></h4>
                </div>
                <div class="content">
                    <table width="100%" border="0" cellpadding="0" cellspacing="0">
                        <tr>
                            <td class="fieldname">允许访问网站:
                            </td>
                            <td class="fieldvalue">
                                <asp:RadioButtonList ID="AllowVisit" runat="server" RepeatDirection="Horizontal">
                                    <asp:ListItem Value="1" Selected="True">允许</asp:ListItem>
                                    <asp:ListItem Value="0">关闭</asp:ListItem>
                                </asp:RadioButtonList>
                            </td>
                            <td class="fielddescription"></td>
                        </tr>
                        <tr>
                            <td class="fieldname">登录发布信息:
                            </td>
                            <td class="fieldvalue">
                                <asp:RadioButtonList ID="LoginRelease" runat="server" RepeatDirection="Horizontal">
                                    <asp:ListItem Value="1" Selected="True">是</asp:ListItem>
                                    <asp:ListItem Value="0">否</asp:ListItem>
                                </asp:RadioButtonList>
                            </td>
                            <td class="fielddescription"></td>
                        </tr>
                        <tr>
                            <td class="fieldname">自动审核发布的信息:
                            </td>
                            <td class="fieldvalue">
                                <asp:RadioButtonList ID="AutomaticAuditInformation" runat="server" RepeatDirection="Horizontal">
                                    <asp:ListItem Value="1">自动</asp:ListItem>
                                    <asp:ListItem Value="0" Selected="True">手动</asp:ListItem>
                                </asp:RadioButtonList>
                            </td>
                            <td class="fielddescription"></td>
                        </tr>
                        <tr>
                            <td class="fieldname">自动审核用户注册信息:
                            </td>
                            <td class="fieldvalue">
                                <asp:RadioButtonList ID="AutomaticAuditUser" runat="server" RepeatDirection="Horizontal">
                                    <asp:ListItem Value="1" Selected="True">自动</asp:ListItem>
                                    <asp:ListItem Value="0">手动</asp:ListItem>
                                </asp:RadioButtonList>
                            </td>
                            <td class="fielddescription"></td>
                        </tr>
                        <tr>
                            <td class="fieldname">开启邮件服务:
                            </td>
                            <td class="fieldvalue">
                                <asp:RadioButtonList Enabled="false" ID="EmailService" runat="server" RepeatDirection="Horizontal">
                                    <asp:ListItem Value="1" Selected="True">开启</asp:ListItem>
                                    <asp:ListItem Value="0">关闭</asp:ListItem>
                                </asp:RadioButtonList>
                            </td>
                            <td class="fielddescription"></td>
                        </tr>
                        <tr>
                            <td class="fieldname">IP源:
                            </td>
                            <td class="fieldvalue">
                                <asp:DropDownList ID="IPSource" runat="server">
                                    <asp:ListItem Value="0" Selected="True">纯真数据库</asp:ListItem>
                                    <asp:ListItem Value="1">淘宝Api</asp:ListItem>
                                </asp:DropDownList>
                            </td>
                            <td class="fielddescription"></td>
                        </tr>
                        <tr>
                            <td class="fieldname">允许访问的城市名:
                            </td>
                            <td class="fieldvalue">
                                <asp:TextBox ID="AllowVisitArea" runat="server" Width="260" MaxLength="49" Text=""></asp:TextBox>
                            </td>
                            <td class="fielddescription">允许访问的城市,仅限发布信息等交互功能(如:北京市,多个城市用逗号分隔),为空表示不限制</td>
                        </tr>
                    </table>
                    <asp:HiddenField ID="ConfigID" runat="server" Value="0" />
                </div>
            </div>
            <br />
            <table width="100%" border="0" cellpadding="2" cellspacing="1">
                <tr>
                    <td colspan="2" align="center">
                        <asp:Button ID="btnSave" SkinID="ButtonSave" runat="server" Text="保存" OnClick="btnSave_Click" />
                        &nbsp;
                    </td>
                </tr>
            </table>
            <br />
        </div>
    </form>
</asp:Content>
