﻿<%@ Page Title="上传配置编辑" Theme="AdminSkin" Language="C#" MasterPageFile="~/Others/AdminMasterPage.Master" AutoEventWireup="true" CodeBehind="UploadConfigEdit.aspx.cs" Inherits="Admin.Contents.UploadConfigEdit" %>

<asp:Content ID="Content1" ContentPlaceHolderID="AdminContentHead" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="AdminContentCenter" runat="server">
    <form id="form1" runat="server">
        <div class="formtextfield">
            <div class="title">
                <h4><span>上传配置</span></h4>
            </div>
            <div class="content">
                <table width="100%" border="0" cellpadding="0" cellspacing="0">
                    <tr>
                        <td class="fieldname">保存路径(相对):
                        </td>
                        <td class="fieldvalue">
                            <asp:TextBox ID="SavePath" runat="server" Width="260" MaxLength="100" CssClass="text form-validate"></asp:TextBox>
                            <asp:CustomValidator ControlToValidate="SavePath" ClientValidationFunction="Validator.NonEmpty" ErrorMessage="不能为空" ValidateEmptyText="true" CssClass="fielderror" runat="server"></asp:CustomValidator>
                        </td>
                        <td class="fielddescription">从根目开始的相对路径(前面不加/,结尾加/)</td>
                    </tr>
                    <tr style="display:none;">
                        <td class="fieldname">访问路径:
                        </td>
                        <td class="fieldvalue">
                            <asp:TextBox ID="VisitPath" runat="server" Width="260" MaxLength="100"></asp:TextBox>
                        </td>
                        <td class="fielddescription"></td>
                    </tr>
                    <tr>
                        <td class="fieldname">允许上传类型:
                        </td>
                        <td class="fieldvalue">
                            <asp:TextBox ID="UploadType" runat="server" Width="260" Text=".jpeg|.jpg|.gif|.png"></asp:TextBox>
                        </td>
                        <td class="fielddescription">多个类型使用|符号分隔</td>
                    </tr>
                    <tr>
                        <td class="fieldname">允许上传大小:
                        </td>
                        <td class="fieldvalue">
                            <asp:TextBox ID="MaximumSize" runat="server" Width="260" Text="1024"></asp:TextBox>
                            <asp:CustomValidator ControlToValidate="MaximumSize" ClientValidationFunction="Validator.Digit" ErrorMessage="请填写数字" ValidateEmptyText="true" CssClass="fielderror" runat="server"></asp:CustomValidator>
                        </td>
                        <td class="fielddescription">单位为KB</td>
                    </tr>
                    <tr>
                        <td class="fieldname">水印类型:
                        </td>
                        <td class="fieldvalue">
                            <asp:DropDownList ID="MarkType" runat="server">
                                <asp:ListItem Value="1" Selected="True">文本</asp:ListItem>
                                <asp:ListItem Value="2">图片</asp:ListItem>
                            </asp:DropDownList>
                        </td>
                        <td class="fielddescription"></td>
                    </tr>
                    <tr>
                        <td class="fieldname">水印位置:
                        </td>
                        <td class="fieldvalue">
                            <asp:DropDownList ID="MarkPosition" runat="server">
                                <asp:ListItem Selected="True" Value="0">无水印</asp:ListItem>
                                <asp:ListItem Value="1">左上</asp:ListItem>
                                <asp:ListItem Value="2">中上</asp:ListItem>
                                <asp:ListItem Value="3">右上</asp:ListItem>
                                <asp:ListItem Value="4">中左</asp:ListItem>
                                <asp:ListItem Value="5">中部</asp:ListItem>
                                <asp:ListItem Value="6">中右</asp:ListItem>
                                <asp:ListItem Value="7">左下</asp:ListItem>
                                <asp:ListItem Value="8">中下</asp:ListItem>
                                <asp:ListItem Value="9">右下</asp:ListItem>
                            </asp:DropDownList>
                        </td>
                        <td class="fielddescription"></td>
                    </tr>
                    <tr>
                        <td class="fieldname">水印图片路径:
                        </td>
                        <td class="fieldvalue">
                            <asp:TextBox ID="ImageMarkPath" runat="server" Width="260" MaxLength="100" placeholder="如images/watemark.png"></asp:TextBox>
                        </td>
                        <td class="fielddescription">填写相对路径</td>
                    </tr>
                    <tr>
                        <td class="fieldname">文本内容:
                        </td>
                        <td class="fieldvalue">
                            <asp:TextBox ID="TextMark" runat="server" Width="260" MaxLength="25"></asp:TextBox>
                        </td>
                        <td class="fielddescription"></td>
                    </tr>
                </table>
            </div>
            <table width="100%" border="0" cellpadding="2" cellspacing="1">
                <tr>
                    <td colspan="2" align="center">
                        <asp:Button ID="btnSave" runat="server" Text="保存" SkinID="ButtonSave" OnClick="btnSave_Click" />
                        &nbsp;&nbsp;&nbsp;&nbsp;
                    </td>
                </tr>
            </table>
        </div>
        <asp:HiddenField ID="UploadConfigID" runat="server" Value="0" />
    </form>
</asp:Content>
