﻿<%@ Page Title="注册用户管理" Language="C#" StylesheetTheme="AdminSkin" MasterPageFile="~/Others/AdminMasterPage.Master" AutoEventWireup="true" CodeBehind="UserManage.aspx.cs" Inherits="Solution.Admin.Contents.UserManage" %>

<%@ Register Assembly="BX.Common" Namespace="Common" TagPrefix="cc1" %>
<asp:Content ID="Content1" ContentPlaceHolderID="AdminContentHead" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="AdminContentCenter" runat="server">
    <form id="form1" runat="server">
        <asp:ObjectDataSource ID="ObjectDataSource" runat="server" EnablePaging="True"
            SelectCountMethod="UserCount" SelectMethod="UserList" DeleteMethod="DeleteUser" TypeName="Logic.Users">
            <DeleteParameters>
                <asp:Parameter Name="userId" Type="Int32" />
            </DeleteParameters>
            <SelectParameters>
                <asp:QueryStringParameter DefaultValue="0" Name="conditional" QueryStringField="conditional"
                    Type="string" />
                <asp:QueryStringParameter DefaultValue="0" Name="categroy" QueryStringField="category"
                    Type="String" />
                <asp:QueryStringParameter DefaultValue="0" Name="keywords" QueryStringField="keywords"
                    Type="String" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <div class="listdiv">
            <div class="grid-title">
                <div class="grid-title-text">
                    <h4>
                        <span>注册用户管理</span>
                    </h4>
                </div>
                <div class="grid-title-menu"></div>
            </div>
            <div class="grid-list">
                <cc1:ExtendedGridView ID="ExtendedGridView1" runat="server" AllowPaging="True" AutoGenerateColumns="False"
                    CssClass="grid" DataKeyNames="UserID" DataSourceID="ObjectDataSource" CheckBox="False" CheckBoxDataIndex="0" ItemName="用户管理">
                    <Columns>
                        <asp:BoundField DataField="UserID" HeaderText="ID" />
                        <asp:BoundField DataField="Email" HeaderText="账号" />
                        <asp:TemplateField HeaderText="状态">
                            <ItemTemplate>
                                <%#DataBinder.Eval(Container.DataItem, "Status").Equals(1)?"正常":"禁用"%>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="操作">
                            <ItemTemplate>
                                <asp:LinkButton ID="LinkButton2" runat="server" CommandName="Delete" OnClientClick='javascript:return confirm("确定删除？")' Text="删除" CausesValidation="false"></asp:LinkButton>&nbsp;
                                <a href="UserEdit.aspx?UserID=<%#Eval("UserID") %>">修改</a>&nbsp;
                                <a href="ShopNavigationManage.aspx?UserID=<%#Eval("UserID") %>">商家黄页</a>
                                <a href="UserShopConfigEdit.aspx?UserID=<%#Eval("UserID") %>">商家配置</a>
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                </cc1:ExtendedGridView>
            </div>
        </div>
    </form>
</asp:Content>
