﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="FocusAdvertisement.ascx.cs"
    Inherits="Solution.Admin.Controls.FocusAdvertisement" %>
<%@ Register Src="WebFileUpload.ascx" TagName="WebFileUpload" TagPrefix="uc1" %>
<!--焦点广告控件-->
<asp:HiddenField ID="HiddenFieldADList" Value="" runat="server" />
<table style="width: 100%;">
    <tr>
        <td style="width: 60px;">
            广告列表:
        </td>
        <td>
            <table>
                <tr>
                    <td rowspan="4">
                        <select ondblclick="modifyOption();" id="ImgList" name="D1" multiple="multiple" size="8"
                            style="width: 326px;">
                        </select>
                    </td>
                    <td>
                        <asp:Button ID="Button8" runat="server" Text="删除" OnClientClick="deleteOption();return false;" />
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Button ID="Button1" runat="server" Text="修改" OnClientClick="modifyOption();return false;" />
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Button ID="Button4" runat="server" Text="上移" OnClientClick="upOption();return false;" />
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Button ID="Button5" runat="server" Text="下移" OnClientClick="downOption();return false;" />
                    </td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td>
            &nbsp;
        </td>
        <td>
            <table>
                <tr>
                    <td>
                        标题:
                    </td>
                    <td>
                        <asp:TextBox ID="txtAdImageTitle" runat="server" Width="290" MaxLength="100"></asp:TextBox>
                    </td>
                </tr>
                <tr>
                    <td>
                        描述:
                    </td>
                    <td>
                        <asp:TextBox ID="txtAdImageAlt" runat="server" Width="290" MaxLength="500" TextMode="MultiLine"></asp:TextBox>
                    </td>
                </tr>
                <tr>
                    <td>
                        图片:
                    </td>
                    <td>
                        <uc1:WebFileUpload ID="txtFocusImgUrl" runat="server" />
                    </td>
                </tr>
                <tr>
                    <td>
                        链接:
                    </td>
                    <td>
                        <asp:TextBox ID="txtFocusImgLink" runat="server" Width="290"></asp:TextBox>
                        <asp:Button ID="Button6" runat="server" Text="添加" OnClientClick="addOption();return false;" />
                        <asp:Button ID="Button2" runat="server" Text="修改" OnClientClick="saveModifyOption();return false;" />
                    </td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td>
            &nbsp;
        </td>
        <td>
        </td>
    </tr>
    <tr>
        <td>
            风格:
        </td>
        <td>
            &nbsp;
            <asp:DropDownList ID="ddlADStyle" runat="server">
                <asp:ListItem Value="1">风格1</asp:ListItem>
            </asp:DropDownList>
        </td>
    </tr>
    <tr>
        <td>
            规格:
        </td>
        <td>
            宽<asp:TextBox ID="txtADWidth" runat="server" Width="30px" 
                Height="19px"></asp:TextBox>px&nbsp;&nbsp;高<asp:TextBox
                ID="txtADHeight" runat="server" Width="30"></asp:TextBox>px
        </td>
    </tr>
    <tr>
        <td>
            目标:
        </td>
        <td>
            <asp:RadioButtonList ID="rblFocusADLinkTarget" runat="server" RepeatDirection="Horizontal"
                RepeatLayout="Flow">
                <asp:ListItem Selected="True" Value="1">新窗口</asp:ListItem>
                <asp:ListItem Value="2">原窗口</asp:ListItem>
            </asp:RadioButtonList>
        </td>
    </tr>
    <tr>
        <td>
            &nbsp;
        </td>
        <td>
            &nbsp;
        </td>
    </tr>
    <tr>
        <td>
            &nbsp;
        </td>
        <td>
            &nbsp;
        </td>
    </tr>
</table>
<script type="text/javascript">

    function id(id) {
        return document.getElementById(id);
    }
    var focusImgUrlObj = id("<%=txtFocusImgUrl.ImageTextClientID%>");
    var focusImgLinkObj = id("<%=txtFocusImgLink.ClientID%>");
    var focusImgTitleObj = id("<%=txtAdImageTitle.ClientID%>");
    var focusImgAltObj = id("<%=txtAdImageAlt.ClientID%>");
    var adListObj = id("<%=HiddenFieldADList.ClientID%>");
    var imgListObj = id("ImgList");

    function deleteOption() {
        if (imgListObj.selectedIndex != -1) {
            imgListObj.removeChild(imgListObj.options[imgListObj.selectedIndex]);
            asyncGetADList();
        }
    }
    function addOption() {
        var img = focusImgUrlObj.value;
        var link = focusImgLinkObj.value;
        var title = focusImgTitleObj.value;
        var alt = focusImgAltObj.value;
        if (img == "" || link == "") {
            alert("图片或链接不能为空");
            return false;
        }
        var optionObj = document.createElement("option");
        optionObj.value = link + "|" + img + "|" + title + "|" + alt;
        optionObj.innerHTML = link;
        imgListObj.appendChild(optionObj);

        focusImgUrlObj.value = focusImgLinkObj.value = focusImgTitleObj.value = focusImgAltObj.value = "";
        asyncGetADList();
    }
    function upOption() {
        if (imgListObj.selectedIndex > 0) {
            var op1 = imgListObj.options[imgListObj.selectedIndex - 1];
            var op2 = imgListObj.options[imgListObj.selectedIndex];
            imgListObj.insertBefore(op2, op1);
            asyncGetADList();
        }
        
    }
    function downOption() {
        if (imgListObj.selectedIndex != -1 && imgListObj.selectedIndex < imgListObj.options.length - 1) {
            var op1 = imgListObj.options[imgListObj.selectedIndex + 1];
            var op2 = imgListObj.options[imgListObj.selectedIndex];
            imgListObj.insertBefore(op1, op2);
            asyncGetADList();
        }
    }
    //修改
    function modifyOption() {
        if (imgListObj.selectedIndex != -1) {
            var v = imgListObj.options[imgListObj.selectedIndex].value.split('|');
            focusImgLinkObj.value =v.length>0?v[0]:"";
            focusImgUrlObj.value = v.length>1?v[1]:"";
            focusImgTitleObj.value = v.length>2?v[2]:"";
            focusImgAltObj.value = v.length > 3 ? v[3] : "";
            asyncGetADList();
        }
    }
    //保存修改
    function saveModifyOption() {
        var img = focusImgUrlObj.value;
        var link = focusImgLinkObj.value;
        var title = focusImgTitleObj.value;
        var alt = focusImgAltObj.value;
        if (img == "" || link == "") {
            alert("图片或链接不能为空");
            return false;
        }
        if (imgListObj.selectedIndex != -1) {
            var op1 = imgListObj.options[imgListObj.selectedIndex];
            op1.value = link + "|" + img + "|" + title + "|" + alt;
            op1.innerHTML = link;
            focusImgUrlObj.value = focusImgLinkObj.value = focusImgTitleObj.value = focusImgAltObj.value = "";
            asyncGetADList();
        }
        
    }
    //同步获取
    function asyncGetADList() {
        var oplist = imgListObj.options;
        var v="";
        for (var i = 0; i < oplist.length; i++) {
            v += oplist[i].value;
            if (i < oplist.length - 1) {
                v += "_";
            }
        }
        adListObj.value = v;
    }
    //同步设置
    function asyncSetADList() {
        var info = adListObj.value.split('_');
        if (info.length == 0) {
            return;
        }
        for (var i = 0; i < info.length; i++) {
            var v = info[i].split('|');
            if (v.length < 2) {
                continue;
            }
            var str = (v.length > 0 ? v[0] : "") + "|" + (v.length > 1 ? v[1] : "") + "|" + (v.length > 2 ? v[2] : "") + "|" + (v.length > 3 ? v[3] : "");
            if (str.length > 4) {
                var optionObj = document.createElement("option");
                optionObj.value = str;
                optionObj.innerHTML = v[0];
                imgListObj.appendChild(optionObj);
            }
        }
    }
    asyncSetADList();
</script>
