﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Default.aspx.cs" Inherits="Web.Install.Default" %>

<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>软件安装--<%=SoftwareName%></title>
    <script src="/js/jquery-1.4.1.min-vsdoc.js" type="text/javascript"></script>
    <link href="Static/install.css" rel="stylesheet" />
    <script src="Static/install.js" type="text/javascript"></script>

</head>
<body>
    <form id="form1" runat="server">
        <div class="InstallWindow">
            <asp:Wizard ID="Install" runat="server" Width="760px" Height="380px" BackColor="#E6E2D8" BorderColor="#999999" BorderWidth="1px" Font-Names="Verdana" Font-Size="0.8em" ActiveStepIndex="0" BorderStyle="Solid" OnNextButtonClick="Install_NextButtonClick" OnSideBarButtonClick="Install_SideBarButtonClick" OnFinishButtonClick="Install_FinishButtonClick">
                <HeaderStyle BackColor="#666666" BorderColor="#E6E2D8" BorderStyle="Solid" BorderWidth="2px" Font-Bold="True" Font-Size="0.9em" ForeColor="White" HorizontalAlign="Center" />
                <HeaderTemplate>
                    <%=SoftwareName%> 软件安装向导
                </HeaderTemplate>
                <NavigationButtonStyle BackColor="White" BorderColor="#C5BBAF" BorderStyle="Solid" BorderWidth="1px" Font-Names="Verdana" Font-Size="0.8em" ForeColor="#1C5E55" />
                <SideBarButtonStyle ForeColor="White" />
                <SideBarStyle Width="135" CssClass="InstallLeftMenu" BackColor="#1C5E55" Font-Size="0.9em" VerticalAlign="Top" />
                <StepStyle BackColor="#F7F6F3" BorderColor="#E6E2D8" BorderStyle="Solid" BorderWidth="2px" />
                <WizardSteps>
                    <asp:WizardStep runat="server" ID="Step0" Title="欢迎">
                        <div class="steptitle">
                            欢迎
                        </div>
                        <div id="Div1" class="step">
                            <div class="welcome">
                                <%=Welcome%>
                            </div>
                            <%--                            <fieldset>
                                <legend>维护操作</legend>
                                <div>
                                    <input id="Button1" type="button" value="清空数据库" onclick="clearDatabase(this);"/>
                                </div>
                            </fieldset>--%>
                        </div>
                    </asp:WizardStep>
                    <asp:WizardStep runat="server" ID="Step1" Title="环境检测">
                        <div class="steptitle">
                            使用环境检查
                        </div>
                        <div id="DivStep1" runat="server" class="step">
                        </div>
                    </asp:WizardStep>
                    <asp:WizardStep runat="server" ID="Step2" Title="数据库信息">
                        <div class="steptitle">
                            数据库信息
                        </div>
                        <div class="step">
                            <table class="TableDatabase" style="width: 100%;">
                                <tr>
                                    <td class="tdleft">数据库类型:</td>
                                    <td>
                                        <asp:DropDownList ID="DatabaseName" runat="server" Width="150">
                                            <asp:ListItem Value="mssql" Text="Sql Server" Selected="True"></asp:ListItem>
                                        </asp:DropDownList>
                                    </td>
                                    <td>&nbsp;</td>
                                </tr>
                                <tr>
                                    <td class="tdleft">数据库服务器:</td>
                                    <td>
                                        <asp:TextBox ID="txtServer" runat="server" Text="localhost" Width="150"></asp:TextBox>
                                        <asp:CustomValidator ControlToValidate="txtServer" ClientValidationFunction="Validator.NonEmpty" ErrorMessage="*" ValidateEmptyText="true" CssClass="fielderror" runat="server"></asp:CustomValidator>
                                    </td>
                                    <td>&nbsp;</td>
                                </tr>
                                <tr>
                                    <td class="tdleft">数据库名称:</td>
                                    <td>
                                        <asp:TextBox ID="txtDatabase" runat="server" Text="Demo" Width="150"></asp:TextBox>
                                        <asp:CustomValidator ControlToValidate="txtDatabase" ClientValidationFunction="Validator.NonEmpty" ErrorMessage="*" ValidateEmptyText="true" CssClass="fielderror" runat="server"></asp:CustomValidator>
                                    </td>
                                    <td>&nbsp;</td>
                                </tr>
                                <tr>
                                    <td class="tdleft">数据库用户名:</td>
                                    <td>
                                        <asp:TextBox ID="txtAccount" runat="server" Text="sa" Width="150"></asp:TextBox>
                                        <asp:CustomValidator ControlToValidate="txtAccount" ClientValidationFunction="Validator.NonEmpty" ErrorMessage="*" ValidateEmptyText="true" CssClass="fielderror" runat="server"></asp:CustomValidator>
                                    </td>
                                    <td>&nbsp;</td>
                                </tr>
                                <tr>
                                    <td class="tdleft">数据库密码:</td>
                                    <td>
                                        <asp:TextBox ID="txtPassword" runat="server" TextMode="Password" Text="sa" Width="150"></asp:TextBox>
                                        <asp:CustomValidator ControlToValidate="txtPassword" ClientValidationFunction="Validator.NonEmpty" ErrorMessage="*" ValidateEmptyText="true" CssClass="fielderror" runat="server"></asp:CustomValidator>
                                    </td>
                                    <td>&nbsp;</td>
                                </tr>
                                <tr>
                                    <td class="tdleft">安装方式:</td>
                                    <td>
                                        <asp:DropDownList ID="DatabaseInstallOption" runat="server" Width="150">
                                            <asp:ListItem Value="1" Text="先清空数据库再安装" Selected="True"></asp:ListItem>
                                            <asp:ListItem Value="2" Text="直接安装"></asp:ListItem>
                                        </asp:DropDownList> 
                                    </td>
                                    <td> &nbsp;
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="3">
                                        <fieldset>
                                            <legend>维护操作</legend>
                                            <div>
                                                <asp:Button ID="btnClearAdminAccount" runat="server" Text="初始化管理员账号" OnClick="btnClearAdminAccount_Click" />
                                                <asp:Button ID="btnClearDatabase" runat="server" Text="清空数据库" OnClick="btnClearDatabase_Click" OnClientClick="return confirm('清空后将不能还原,确定?');" />
                                            </div>
                                        </fieldset>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </asp:WizardStep>
                    <asp:WizardStep runat="server" ID="Step3" Title="网站配置信息">
                        <div class="steptitle">
                            网站配置信息
                        </div>
                        <div class="step">
                            <table class="TableDatabase" style="width: 100%;">
                                <tr>
                                    <td class="tdleft">管理员账号:</td>
                                    <td>
                                        <asp:TextBox ID="txtAdminAccount" runat="server" Text="admin"></asp:TextBox>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="tdleft">管理员密码:</td>
                                    <td>
                                        <asp:TextBox ID="txtAdminPassoword" TextMode="Password" runat="server" Text=""></asp:TextBox></td>
                                </tr>
                                <tr>
                                    <td class="tdleft">密码确认:</td>
                                    <td>
                                        <asp:TextBox ID="txtRepeatAdminPassword" TextMode="Password" runat="server" Text=""></asp:TextBox>

                                    </td>
                                </tr>
                                <tr>
                                    <td class="tdleft">&nbsp;</td>
                                    <td>&nbsp;</td>
                                </tr>
                                <tr>
                                    <td class="tdleft">&nbsp;</td>
                                    <td>&nbsp;</td>
                                </tr>
                            </table>
                        </div>
                    </asp:WizardStep>
                    <asp:WizardStep runat="server" ID="Step4" Title="安装完成">
                        <div class="steptitle">
                            安装完成
                        </div>
                        <div class="step">
                            恭喜,安装已经完成!单击"完成"安钮将跳转到首页
                        </div>
                    </asp:WizardStep>
                </WizardSteps>
            </asp:Wizard>
        </div>
    </form>
</body>
</html>
