﻿//客户端格式验证
var Validator = {
	Email: function (source, arguments) { arguments.IsValid = this.email(arguments.Value); },
	Digit: function (source, arguments) { arguments.IsValid = this.digit(arguments.Value); },
	Letter: function (source, arguments) { arguments.IsValid = this.letter(arguments.Value); },
	DigitLetter: function (source, arguments) { arguments.IsValid = this.digitLetter(arguments.Value); },
	Decimal: function (source, arguments) { arguments.IsValid = this.decimal(arguments.Value); },
	Word: function (source, arguments) { arguments.IsValid = this.word(arguments.Value); },//任何单词匹配
	Telephone: function (source, arguments) { arguments.IsValid = this.telephone(arguments.Value); },//国内电话
	MobilePhone: function (source, arguments) { arguments.IsValid = this.mobilePhone(arguments.Value); },//移动电话
	ChineseCharacter: function (source, arguments) { arguments.IsValid = this.chineseCharacter(arguments.Value); },//汉字
	Date: function (source, arguments) { arguments.IsValid = this.date(arguments.Value); },//日期(如2012-01-01)
	Datetime: function (source, arguments) { arguments.IsValid = this.datetime(arguments.Value); },//日期+时间
	Url: function (source, arguments) { arguments.IsValid = this.url(arguments.Value); },
	NonEmpty: function (source, arguments) { arguments.IsValid = this.nonEmpty(arguments.Value); },//非空
	email: function (data) { return this.test(/^[\w-]+(\.[\w-]+)*@[\w-]+(\.[\w-]+)+$/, data); },
	digit: function (data) { return this.test(/^\d+$/, data); },
	letter: function (data) { return this.test(/^[A-Za-z]+$/, data) },
	digitLetter: function (data) { return this.test(/^[A-Za-z0-9]+$/, data); },
	decimal: function (data) { return this.test(/^\d+(\.\d+)?$/, data); },
	word: function (data) { return this.test(/^\w+$/, data); },
	telephone: function (data) { return this.test(/(\d{3}-|\d{4}-)?(\d{8}|\d{7})/, data); },
	mobilePhone: function (data) { return this.test(/^1{1}\d{10}$/, data); },
	chineseCharacter: function (data) { return this.test(/[\u4e00-\u9fa5]+/, data); },
	date: function (data) { return this.test(/^\d{4}\W\d{1,2}\W\d{1,2}$/, data); },
	datetime: function (data) { return this.test(/^((((1[6-9]|[2-9]\d)\d{2})-(0?[13578]|1[02])-(0?[1-9]|[12]\d|3[01]))|(((1[6-9]|[2-9]\d)\d{2})-(0?[13456789]|1[012])-(0?[1-9]|[12]\d|30))|(((1[6-9]|[2-9]\d)\d{2})-0?2-(0?[1-9]|1\d|2[0-9]))|(((1[6-9]|[2-9]\d)(0[48]|[2468][048]|[13579][26])|((16|[2468][048]|[3579][26])00))-0?2-29-)) (20|21|22|23|[0-1]?\d):[0-5]?\d:[0-5]?\d$/, data); },
	url: function (data) { return this.test(/^[a-zA-z]+:\/\/(\w+(-\w+)*)(\.(\w+(-\w+)*))*(\?\S*)?$/, data); },
	nonEmpty: function (data) { if (data != null && data != "") { return true; } return false; },
	test: function (express, data) { return new RegExp(express).test(data); }
};