﻿/*数据交互接口(需要jquery)
*/
function LoadMap(_map1id, _map2id, _address) {
    var geocoder, map, marker = null;
    var panoService;
    var initMap = function (_map1id, _map2id, _address) {
        var center = new qq.maps.LatLng(39.916527, 116.397128);
        map = new qq.maps.Map(document.getElementById(_map1id), { center: center, zoom: 15 });
        geocoder = new qq.maps.Geocoder({
            complete: function (result) {
                map.setCenter(result.detail.location);
                var marker = new qq.maps.Marker({ map: map, position: result.detail.location });
            }
        });
        panoService = new qq.maps.PanoramaService();
        geocoder.getLocation(_address);
        geocoder.setComplete(function (result) {
            map.setCenter(result.detail.location);
            var marker = new qq.maps.Marker({ map: map, position: result.detail.location });
            panoService.getPano(result.detail.location, 1000, function (result) {
                if (result) {
                    var pano = new qq.maps.Panorama(_map2id, { "pano": result.svid });
                } else { document.getElementById(_map2id).innerHTML = "此处无街景"; }
            });
        });
        geocoder.setError(function () { document.getElementById(_map2id).innerHTML = "出错了，请输入正确的地址！！！"; });
    }
    initMap(_map1id, _map2id, _address);
}

function GetIPAddress(_ip, _callback) {//通过IP查询城市名称
    $.get("/Ashx/IP.ashx?ipv4=" + _ip, {}, function (result) { _callback(result); }, "json");
}

function AddLeaveMessage(_jsonData, _callback)//添加留言
{
    $.post(document.location.href + "?cmd=submitLeaveMessage", _jsonData, function (result) { _callback(result); }, "json");
}
function GetMessageList(_callback) {//获取系统消息,如公告
    $.post(document.location.href, { "cmd": "systemMessage" }, function (result) { _callback(result); }, "json");
}
//
function GetCollectList(_callback)//当前用户收藏列表
{//待删除
    $.post(document.location.href, { "cmd": "collectlist" }, function (result) { _callback(result); }, "json");
}
function CollectDelete(_infoid, _callback) {
    $.post(document.location.href, { "cmd": "collectdelete", "id": _infoid }, function (result) { _callback(result); }, "json");
}
var Info = {
    list: function (_callback) {//待删除
        $.post(document.location.href, { "cmd": "infolist" }, function (result) { _callback(result); }, "json");
    },
    del: function (_infoid, _callback) {
        $.post(document.location.href, { "cmd": "infolistdelete", "infoid": _infoid }, function (result) { _callback(result); }, "json");
    },
    refresh: function (_infoid, _callback) {
        $.post(document.location.href, { "cmd": "refreshinfo", "infoid": _infoid }, function (result) { _callback(result); }, "json")
    },
    release: function (_categoryId, _jsonData, _callback) {//信息发布
        $.post(document.location.href+"?cmd=release&id=" + _categoryId + "&r=", _jsonData, function (result) { _callback(result); }, "json");
    }
}
var User = {
    updateShopConfig: function (_jsonData, _callback) {//更新商家信息
        $.post(document.location.href, _jsonData, function (result) { _callback(result); }, "json")
    },
    updatePassword: function (_jsonData, _callback) {//更新用户密码
        $.post(document.location.href, _jsonData, function (result) { _callback(result); }, "json")
    },
    addCollect: function (_jsonData, _callback)//添加收藏
    {
        $.get(document.location.href + "?cmd=addcollect", _jsonData, function (result) { _callback(result); }, "json");
    },
    register: function (_jsonData, _callback) {//注册
        $.post(document.location.href + "?cmd=register", _jsonData, function (result) { _callback(result); }, "json");
    },
    login: function (_jsonData, _successCallbck, _failureCallback)//登录
    {
        var urlParams = "";
        for (var k in _jsonData) { urlParams += (k + "=" + _jsonData[k] + "&"); }
        urlParams = "cmd=login&" + urlParams.substring(0, urlParams.length - 1);
        $.ajax({
            url: document.location.href,
            type: "POST",
            cache: false,
            async: false,
            dataType: "json",
            data: urlParams,
            success: function (result) {
                _successCallbck(result);
            },
            failure: function (result) {
                if (typeof _failureCallback == "function") { _failureCallback(result); }
            }
        })
    },
    info: function (_callback) {//获取当前登录用户信息
        $.post(document.location.href, { "cmd": "loginUserInfo" }, function (result) { _callback(result); }, "json");
    },
    forgotPassword: function (_jsonData, _callback) {//找回密码
        $.post(document.location.href + "?cmd=forgetPassword", _jsonData, function (result) {
            _callback(result);
        }, "json")
    },
    emailAuth: function (_jsonData, _callback) {//发送邮箱验证
        $.post(document.location.href + "?cmd=emailAuth", _jsonData, function (result) {
            _callback(result);
        }, "json")
    },
    readMessage: function (_msgId, _callback) {//标记消息为已读状态
        $.post(document.location.href + "?cmd=readMessage", { MessageId: _msgId }, function (result) {
            _callback(result);
        }, "json")
    },
    modifyUserData: function (_jsonData, _callback) {//修改用户数据
        $.post(document.location.href + "?cmd=modifyUserData", _jsonData, function (result) {
            _callback(result);
        }, "json");
    },
    securitySet: function (_jsonData, _callback) {//安全设置
        $.post(document.location.href + "?cmd=userSecuritySet", _jsonData, function (result) {
            _callback(result);
        }, "json");
    }
}