﻿var BaiMap = function (mapid) {
    var baidumap; var mapobj = this;
    var city = "北京市"; var zoom = 12, longitude = null, latitude = null;
    var markerList = new Array();
    this.load = function () {
        var width = this.request("width") != "" ? this.request("width") : "100%";
        var height = this.request("height") != "" ? this.request("height") : "300px";
        city = this.request("address") != "" ? decodeURI(this.request("address")) : city;
        zoom = this.request("zoom") != "" && this.request("zoom") != "0" ? parseInt(this.request("zoom")) : zoom;
        if (this.request("coordinate") != "") {
            var v = this.request("coordinate").split(",");
            if (v.length > 1) {longitude = v[0]; latitude = v[1];}
        } else {
            longitude = this.request("longitude") != "" ? parseInt(this.request("longitude")) : longitude;
            latitude = this.request("latitude") != "" ? parseInt(this.request("latitude")) : latitude;
        }
        var enableScroll = this.request("enableScroll") != "" ? false : true;
        var _mapdiv = document.getElementById(mapid);
        if (window.parent != null && window.parent.document.getElementById("MapIframe") != null) {//将不支持自适应
            var mobj = window.parent.document.getElementById("MapIframe");
            _mapdiv.style.width = mobj.attributes["width"].value; _mapdiv.style.height = mobj.attributes["height"].value;
        } else {
            _mapdiv.style.width = width; _mapdiv.style.height = height;
        }
        baidumap = new BMap.Map(mapid);  
        if (enableScroll) { baidumap.enableScrollWheelZoom(); }
        if (longitude != null && latitude != null) { this.searchCoordinateAndAddMarker(longitude, latitude); } else { this.searchAddressAndAddMarker(city);}
        return baidumap;
    }; 
    this.searchAddressAndAddMarker = function (address, isclear) {
        var G = new BMap.Geocoder(); var f = this.addMarker; var removeMarker = this.removeMarker;
        G.getPoint(address, function (point) {
            if (point == null) { point = new BMap.Point(longitude, latitude); }
            baidumap.centerAndZoom(point, zoom);
            f(point, isclear);
        }, city);

    };
    this.searchCoordinateAndAddMarker = function (longitude, latitude, isclear) {
        var point = new BMap.Point(longitude, latitude);baidumap.centerAndZoom(point, zoom); return this.addMarker(point,isclear);
    }
    this.geocoder = function (address) {
        //对指定的地址进行解析。如果地址定位成功，则以地址所在的坐标点Point为参数调用回调函数。否则，回调函数的参数为null。city为地址所在的城市名，例如“北京市”
        var G = new BMap.Geocoder();
        G.getPoint(address, function (point) { return point;}, city);
    };
    //创建普通标注
    this.addMarker = function (point, isclear) {
        if (isclear != null && isclear == true) { this.removeMarker(); }
        var marker = new BMap.Marker(point);
        baidumap.addOverlay(marker);
        markerList.push(marker);
        return marker;
    };
    this.addMarkerAndInfoWindow = function (point, infoText, isclear) {
        if (isclear != null && isclear == true) { this.removeMarker(); }
        var marker = new BMap.Marker(point);
        baidumap.addOverlay(marker);
        var infoWindow = new BMap.InfoWindow(infoText);
        marker.addEventListener("click", function () { this.openInfoWindow(infoWindow); });
        return marker;
    };
    //创建带图标的标注
    this.addIcoMarker = function (point, ico) {
        var myIcon = new BMap.Icon(ico, new BMap.Size(18, 18));
        var marker = new BMap.Marker(point, { icon: myIcon });
        baidumap.addOverlay(marker);

        var infoWindow = new BMap.InfoWindow("==图标标注==");
        marker.addEventListener("mouseover", function () { this.openInfoWindow(infoWindow); });
    };
    this.addAnimationMarker = function (point, animationIco) {
        var myIcon = new BMap.Icon(animationIco, new BMap.Size(18, 18));
        var marker = new BMap.Marker(point, { icon: myIcon });
        baidumap.addOverlay(marker);
        marker.setAnimation(BMAP_ANIMATION_BOUNCE);
    };
    //创建标注+提示
    this.addMarkerAlt = function (point, ico) {
        var myIcon = new BMap.Icon(ico, new BMap.Size(22, 30));
        var marker = new BMap.Marker(point, { icon: myIcon });
        baidumap.addOverlay(marker); 
        var label = new BMap.Label("<div style='color:red;'>我是文字标注哦</div>", { offset: new BMap.Size(-25, -20) });
        marker.setLabel(label);
        label.setStyle({ display: "none", borderColor: "blue" });
        marker.addEventListener("mouseover", function (data) {
            label.setStyle({ display: "block" });
            baidumap.panTo(marker.getPosition()); 
        })
        marker.addEventListener("mouseout", function (data) {
            label.setStyle({ display: "none" });
        })
        markerList.push(marker);
    };
    this.removeMarker = function () { for (var i = 0; i < markerList.length; i++) { markerList.pop().hide(); } };
    this.request=function(key) {
        var _search = window.location.search.substring(window.location.search.lastIndexOf('?') + 1);
        var _searchArray = _search.split('&'); var _searchKeyValue;
        if (_search != "") {
            for (var i = 0; i < _searchArray.length; i++) {
                _searchKeyValue = _searchArray[i].split('=');
                if (_searchKeyValue.length == 2) { if (_searchKeyValue[0] == key) { return _searchKeyValue[1]; } else { continue; } }
            }
            return "";
        }
        else { return ""; }
    };
}