CREATE TABLE [jtbc_admin] (
  [a_id] [int] IDENTITY (1, 1) NOT NULL ,
  [a_username] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
  [a_password] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
  [a_role] [int] NULL CONSTRAINT [DF_jtbc_admin_a_role] DEFAULT (0),
  [a_popedom] [text] COLLATE Chinese_PRC_CI_AS NULL ,
  [a_name] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
  [a_gender] [int] NULL CONSTRAINT [DF_jtbc_admin_a_gender] DEFAULT (0),
  [a_email] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
  [a_phone] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
  [a_zipcode] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
  [a_address] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [a_lock] [int] NULL CONSTRAINT [DF_jtbc_admin_a_lock] DEFAULT (0),
  [a_lastip] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
  [a_lasttime] [datetime] NULL ,
  [a_userid] [int] NULL CONSTRAINT [DF_jtbc_admin_a_userid] DEFAULT (0),
  [a_time] [datetime] NULL ,
  CONSTRAINT [PK_jtbc_admin] PRIMARY KEY  CLUSTERED 
  (
    [a_id]
  )  ON [PRIMARY] 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];
CREATE TABLE [jtbc_admin_role] (
  [ar_id] [int] IDENTITY (1, 1) NOT NULL ,
  [ar_topic] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
  [ar_popedom] [text] COLLATE Chinese_PRC_CI_AS NULL ,
  [ar_database] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [ar_alone] [int] NULL CONSTRAINT [DF_jtbc_admin_role_ar_alone] DEFAULT (0),
  [ar_verify] [int] NULL CONSTRAINT [DF_jtbc_admin_role_ar_verify] DEFAULT (0),
  [ar_order] [int] NULL CONSTRAINT [DF_jtbc_admin_role_ar_order] DEFAULT (0),
  [ar_userid] [int] NULL CONSTRAINT [DF_jtbc_admin_role_ar_userid] DEFAULT (0),
  [ar_time] [datetime] NULL ,
  CONSTRAINT [PK_jtbc_admin_role] PRIMARY KEY  CLUSTERED 
  (
    [ar_id]
  )  ON [PRIMARY] 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];
CREATE TABLE [jtbc_admin_userlnk] (
  [al_id] [int] IDENTITY (1, 1) NOT NULL ,
  [al_topic] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
  [al_title] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [al_target] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
  [al_url] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [al_order] [int] NULL CONSTRAINT [DF_jtbc_admin_userlnk_al_order] DEFAULT (0),
  [al_userid] [int] NULL CONSTRAINT [DF_jtbc_admin_userlnk_al_userid] DEFAULT (0),
  [al_time] [datetime] NULL ,
  CONSTRAINT [PK_jtbc_admin_lnk] PRIMARY KEY  CLUSTERED 
  (
    [al_id]
  )  ON [PRIMARY] 
) ON [PRIMARY];
CREATE TABLE [jtbc_admin_userlog] (
  [al_id] [int] IDENTITY (1, 1) NOT NULL ,
  [al_username] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
  [al_error] [int] NULL CONSTRAINT [DF_jtbc_admin_log_al_type] DEFAULT (0),
  [al_date] [int] NULL CONSTRAINT [DF_jtbc_admin_userlog_al_date] DEFAULT (0),
  [al_ip] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
  [al_time] [datetime] NULL ,
  CONSTRAINT [PK_jtbc_admin_log] PRIMARY KEY  CLUSTERED 
  (
    [al_id]
  )  ON [PRIMARY] 
) ON [PRIMARY];
CREATE TABLE [jtbc_communal_linkimages] (
  [cl_id] [int] IDENTITY (1, 1) NOT NULL ,
  [cl_topic] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [cl_class] [int] NULL CONSTRAINT [DF_jtbc_communal_linkimages_cl_class] DEFAULT (0),
  [cl_tag] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [cl_image] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [cl_intro] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [cl_url] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [cl_target] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [cl_commendatory] [int] NULL CONSTRAINT [DF_jtbc_communal_linkimages_cl_commendatory] DEFAULT (0),
  [cl_hidden] [int] NULL CONSTRAINT [DF_jtbc_communal_linkimages_cl_hidden] DEFAULT (0),
  [cl_time] [datetime] NULL ,
  [cl_random] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [cl_userid] [int] NULL CONSTRAINT [DF_jtbc_communal_linkimages_cl_userid] DEFAULT (0),
  [cl_lng] [int] NULL CONSTRAINT [DF_jtbc_communal_linkimages_cl_lng] DEFAULT (0),
  CONSTRAINT [PK_jtbc_communal_linkimages] PRIMARY KEY  CLUSTERED 
  (
    [cl_id]
  )  ON [PRIMARY] 
) ON [PRIMARY];
CREATE TABLE [jtbc_communal_linktexts] (
  [cl_id] [int] IDENTITY (1, 1) NOT NULL ,
  [cl_topic] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [cl_class] [int] NULL CONSTRAINT [DF_jtbc_communal_linktexts_cl_class] DEFAULT (0),
  [cl_tag] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [cl_intro] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [cl_url] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [cl_target] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [cl_commendatory] [int] NULL CONSTRAINT [DF_jtbc_communal_linktexts_cl_commendatory] DEFAULT (0),
  [cl_hidden] [int] NULL CONSTRAINT [DF_jtbc_communal_linktexts_cl_hidden] DEFAULT (0),
  [cl_time] [datetime] NULL ,
  [cl_random] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [cl_userid] [int] NULL CONSTRAINT [DF_jtbc_communal_linktexts_cl_userid] DEFAULT (0),
  [cl_lng] [int] NULL CONSTRAINT [DF_jtbc_communal_linktexts_cl_lng] DEFAULT (0),
  CONSTRAINT [PK_jtbc_communal_linktexts] PRIMARY KEY  CLUSTERED 
  (
    [cl_id]
  )  ON [PRIMARY] 
) ON [PRIMARY];
CREATE TABLE [jtbc_communal_menu] (
  [cm_id] [int] IDENTITY (1, 1) NOT NULL ,
  [cm_topic] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [cm_class] [int] NULL CONSTRAINT [DF_jtbc_communal_menu_cm_class] DEFAULT (0),
  [cm_target] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [cm_url] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [cm_commendatory] [int] NULL CONSTRAINT [DF_jtbc_communal_menu_cm_commendatory] DEFAULT (0),
  [cm_hidden] [int] NULL CONSTRAINT [DF_jtbc_communal_menu_cm_hidden] DEFAULT (0),
  [cm_order] [int] NULL CONSTRAINT [DF_jtbc_communal_menu_cm_order] DEFAULT (0),
  [cm_time] [datetime] NULL ,
  [cm_random] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [cm_userid] [int] NULL CONSTRAINT [DF_jtbc_communal_menu_cm_userid] DEFAULT (0),
  [cm_lng] [int] NULL CONSTRAINT [DF_jtbc_communal_menu_cm_lng] DEFAULT (0),
  CONSTRAINT [PK_jtbc_communal_menu] PRIMARY KEY  CLUSTERED 
  (
    [cm_id]
  )  ON [PRIMARY] 
) ON [PRIMARY];
CREATE TABLE [jtbc_aboutus] (
	[s_id] [int] IDENTITY (1, 1) NOT NULL ,
	[s_topic] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[s_content] [ntext] COLLATE Chinese_PRC_CI_AS NULL ,
	[s_attachments] [ntext] COLLATE Chinese_PRC_CI_AS NULL ,
	[s_commendatory] [int] NULL CONSTRAINT [DF_jtbc_aboutus_s_commendatory] DEFAULT (0),
	[s_hidden] [int] NULL CONSTRAINT [DF_jtbc_aboutus_s_hidden] DEFAULT (0),
	[s_count] [int] NULL CONSTRAINT [DF_jtbc_aboutus_s_count] DEFAULT (0),
	[s_time] [datetime] NULL ,
	[s_random] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
	[s_userid] [int] NULL CONSTRAINT [DF_jtbc_aboutus_s_userid] DEFAULT (0),
	[s_lng] [int] NULL CONSTRAINT [DF_jtbc_aboutus_s_lng] DEFAULT (0),
	CONSTRAINT [PK_jtbc_aboutus] PRIMARY KEY  CLUSTERED 
	(
		[s_id]
	)  ON [PRIMARY] 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];
CREATE TABLE [jtbc_career_position] (
  [cp_id] [int] IDENTITY (1, 1) NOT NULL ,
  [cp_topic] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [cp_class] [int] NULL CONSTRAINT [DF_jtbc_career_position_cp_class] DEFAULT (0),
  [cp_tag] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [cp_image] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [cp_department] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [cp_edu] [int] NULL CONSTRAINT [DF_jtbc_career_position_cp_edu] DEFAULT (0),
  [cp_number] [int] NULL CONSTRAINT [DF_jtbc_career_position_cp_number] DEFAULT (0),
  [cp_area] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [cp_salary] [int] NULL CONSTRAINT [DF_jtbc_career_position_cp_salary] DEFAULT (0),
  [cp_contact] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [cp_contact_phone] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [cp_contact_email] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [cp_intro] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [cp_content] [ntext] COLLATE Chinese_PRC_CI_AS NULL ,
  [cp_attachments] [ntext] COLLATE Chinese_PRC_CI_AS NULL ,
  [cp_commendatory] [int] NULL CONSTRAINT [DF_jtbc_career_position_cp_commendatory] DEFAULT (0),
  [cp_hidden] [int] NULL CONSTRAINT [DF_jtbc_career_position_cp_hidden] DEFAULT (0),
  [cp_count] [int] NULL CONSTRAINT [DF_jtbc_career_position_cp_count] DEFAULT (0),
  [cp_time] [datetime] NULL ,
  [cp_random] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [cp_userid] [int] NULL CONSTRAINT [DF_jtbc_career_position_cp_userid] DEFAULT (0),
  [cp_lng] [int] NULL CONSTRAINT [DF_jtbc_career_position_cp_lng] DEFAULT (0),
  CONSTRAINT [PK_jtbc_career_position] PRIMARY KEY  CLUSTERED 
  (
    [cp_id]
  )  ON [PRIMARY] 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];
CREATE TABLE [jtbc_career_resume] (
  [cr_id] [int] IDENTITY (1, 1) NOT NULL ,
  [cr_topic] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [cr_name] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [cr_gender] [int] NULL CONSTRAINT [DF_jtbc_career_resume_cr_gender] DEFAULT (0),
  [cr_age] [int] NULL CONSTRAINT [DF_jtbc_career_resume_cr_age] DEFAULT (0),
  [cr_marriage] [int] NULL CONSTRAINT [DF_jtbc_career_resume_cr_marriage] DEFAULT (0),
  [cr_national] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [cr_experience] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [cr_edu] [int] NULL CONSTRAINT [DF_jtbc_career_resume_cr_edu] DEFAULT (0),
  [cr_college] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [cr_professional] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [cr_phone] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [cr_email] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [cr_intro] [ntext] COLLATE Chinese_PRC_CI_AS NULL ,
  [cr_content] [ntext] COLLATE Chinese_PRC_CI_AS NULL ,
  [cr_commendatory] [int] NULL CONSTRAINT [DF_jtbc_career_resume_cr_commendatory] DEFAULT (0),
  [cr_hidden] [int] NULL CONSTRAINT [DF_jtbc_career_resume_cr_hidden] DEFAULT (0),
  [cr_status] [int] NULL CONSTRAINT [DF_jtbc_career_resume_cr_status] DEFAULT (0),
  [cr_ip] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [cr_time] [datetime] NULL ,
  [cr_random] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [cr_userid] [int] NULL CONSTRAINT [DF_jtbc_career_resume_cr_userid] DEFAULT (0),
  [cr_lng] [int] NULL CONSTRAINT [DF_jtbc_career_resume_cr_lng] DEFAULT (0),
  CONSTRAINT [PK_jtbc_career_resume] PRIMARY KEY  CLUSTERED 
  (
    [cr_id]
  )  ON [PRIMARY] 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];
CREATE TABLE [jtbc_guestbook] (
  [g_id] [int] IDENTITY (1, 1) NOT NULL ,
  [g_topic] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [g_name] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [g_face] [int] NULL CONSTRAINT [DF_jtbc_guestbook_g_face] DEFAULT (0),
  [g_email] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [g_content] [ntext] COLLATE Chinese_PRC_CI_AS NULL ,
  [g_reply] [ntext] COLLATE Chinese_PRC_CI_AS NULL ,
  [g_rname] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [g_rtime] [datetime] NULL ,
  [g_commendatory] [int] NULL CONSTRAINT [DF_jtbc_guestbook_g_commendatory] DEFAULT (0),
  [g_hidden] [int] NULL CONSTRAINT [DF_jtbc_guestbook_g_hidden] DEFAULT (0),
  [g_ip] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [g_time] [datetime] NULL ,
  [g_random] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [g_userid] [int] NULL CONSTRAINT [DF_jtbc_guestbook_g_userid] DEFAULT (0),
  [g_lng] [int] NULL CONSTRAINT [DF_jtbc_guestbook_g_lng] DEFAULT (0),
  CONSTRAINT [PK_jtbc_guestbook] PRIMARY KEY  CLUSTERED 
  (
    [g_id]
  )  ON [PRIMARY] 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];
CREATE TABLE [jtbc_news] (
  [n_id] [int] IDENTITY (1, 1) NOT NULL ,
  [n_topic] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [n_class] [int] NULL CONSTRAINT [DF_jtbc_news_n_class] DEFAULT (0),
  [n_tag] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [n_image] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [n_intro] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [n_content] [ntext] COLLATE Chinese_PRC_CI_AS NULL ,
  [n_attachments] [ntext] COLLATE Chinese_PRC_CI_AS NULL ,
  [n_commendatory] [int] NULL CONSTRAINT [DF_jtbc_news_n_commendatory] DEFAULT (0),
  [n_hidden] [int] NULL CONSTRAINT [DF_jtbc_news_n_hidden] DEFAULT (0),
  [n_count] [int] NULL CONSTRAINT [DF_jtbc_news_n_count] DEFAULT (0),
  [n_time] [datetime] NULL ,
  [n_random] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [n_userid] [int] NULL CONSTRAINT [DF_jtbc_news_n_userid] DEFAULT (0),
  [n_lng] [int] NULL CONSTRAINT [DF_jtbc_news_n_lng] DEFAULT (0),
  CONSTRAINT [PK_jtbc_news] PRIMARY KEY  CLUSTERED 
  (
    [n_id]
  )  ON [PRIMARY] 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];
CREATE TABLE [jtbc_products] (
  [p_id] [int] IDENTITY (1, 1) NOT NULL ,
  [p_topic] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [p_class] [int] NULL CONSTRAINT [DF_jtbc_products_p_class] DEFAULT (0),
  [p_tag] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [p_image] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [p_intro] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [p_content] [ntext] COLLATE Chinese_PRC_CI_AS NULL ,
  [p_attachments] [ntext] COLLATE Chinese_PRC_CI_AS NULL ,
  [p_commendatory] [int] NULL CONSTRAINT [DF_jtbc_products_p_commendatory] DEFAULT (0),
  [p_hidden] [int] NULL CONSTRAINT [DF_jtbc_products_p_hidden] DEFAULT (0),
  [p_count] [int] NULL CONSTRAINT [DF_jtbc_products_p_count] DEFAULT (0),
  [p_time] [datetime] NULL ,
  [p_random] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [p_userid] [int] NULL CONSTRAINT [DF_jtbc_products_p_userid] DEFAULT (0),
  [p_lng] [int] NULL CONSTRAINT [DF_jtbc_products_p_lng] DEFAULT (0),
  CONSTRAINT [PK_jtbc_products] PRIMARY KEY  CLUSTERED 
  (
    [p_id]
  )  ON [PRIMARY] 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY];
CREATE TABLE [jtbc_sys_category] (
  [ca_id] [int] IDENTITY (1, 1) NOT NULL ,
  [ca_topic] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
  [ca_fid] [int] NULL CONSTRAINT [DF_jtbc_sys_category_ca_fid] DEFAULT (0),
  [ca_genre] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
  [ca_hidden] [int] NULL CONSTRAINT [DF_jtbc_sys_category_ca_hidden] DEFAULT (0),
  [ca_order] [int] NULL CONSTRAINT [DF_jtbc_sys_category_ca_order] DEFAULT (0),
  [ca_lng] [int] NULL CONSTRAINT [DF_jtbc_sys_category_ca_lng] DEFAULT (0),
  [ca_userid] [int] NULL CONSTRAINT [DF_jtbc_sys_category_ca_userid] DEFAULT (0),
  [ca_time] [datetime] NULL ,
  CONSTRAINT [PK_jtbc_sys_category] PRIMARY KEY  CLUSTERED 
  (
    [ca_id]
  )  ON [PRIMARY] 
) ON [PRIMARY];
CREATE TABLE [jtbc_sys_log] (
  [sl_id] [int] IDENTITY (1, 1) NOT NULL ,
  [sl_genre] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
  [sl_content] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [sl_ltype] [int] NULL CONSTRAINT [DF_jtbc_sys_log_sl_logtype] DEFAULT (0),
  [sl_userid] [int] NULL CONSTRAINT [DF_jtbc_sys_log_sl_userid] DEFAULT (0),
  [sl_userip] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
  [sl_username] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
  [sl_time] [datetime] NULL ,
  CONSTRAINT [PK_jtbc_sys_log] PRIMARY KEY  CLUSTERED 
  (
    [sl_id]
  )  ON [PRIMARY] 
) ON [PRIMARY];
CREATE TABLE [jtbc_sys_tag] (
  [st_id] [int] IDENTITY (1, 1) NOT NULL ,
  [st_tag] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [st_genre] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
  [st_degree] [int] NULL CONSTRAINT [DF_jtbc_sys_tag_st_degree] DEFAULT (0),
  [st_hidden] [int] NULL CONSTRAINT [DF_jtbc_sys_tag_st_hidden] DEFAULT (0),
  [st_lng] [int] NULL CONSTRAINT [DF_jtbc_sys_tag_st_lng] DEFAULT (0),
  [st_userid] [int] NULL CONSTRAINT [DF_jtbc_sys_tag_st_userid] DEFAULT (0),
  [st_time] [datetime] NULL 
) ON [PRIMARY];
CREATE TABLE [jtbc_sys_upload] (
  [up_id] [int] IDENTITY (1, 1) NOT NULL ,
  [up_genre] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
  [up_filename] [nvarchar] (255) COLLATE Chinese_PRC_CI_AS NULL ,
  [up_field] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
  [up_fid] [int] NULL CONSTRAINT [DF_jtbc_sys_upload_up_fid] DEFAULT (0),
  [up_time] [datetime] NULL ,
  [up_foreback] [int] NULL CONSTRAINT [DF_jtbc_sys_upload_up_foreback] DEFAULT (0),
  [up_userid] [int] NULL CONSTRAINT [DF_jtbc_sys_upload_up_userid] DEFAULT (0),
  [up_username] [nvarchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
  [up_valid] [int] NULL CONSTRAINT [DF_jtbc_sys_upload_up_valid] DEFAULT (0),
  [up_vlreason] [int] NULL CONSTRAINT [DF_jtbc_sys_upload_up_vlreason] DEFAULT (0),
  CONSTRAINT [PK_jtbc_sys_upload] PRIMARY KEY  CLUSTERED 
  (
    [up_id]
  )  ON [PRIMARY] 
) ON [PRIMARY];
INSERT INTO [jtbc_sys_category] (ca_topic, ca_fid, ca_genre, ca_userid, ca_time) VALUES ('首页大图', 0, 'communal/linkimages', 1, '2014-01-01 23:00:00');
INSERT INTO [jtbc_communal_linkimages] (cl_topic, cl_class, cl_image, cl_url, cl_target, cl_time, cl_userid) VALUES ('思姆特网站内容给管理系统', 1, '../../common/images/theme/default/img.banner.1.jpg', '#', '_self', '2014-01-01 23:00:00', 1);
INSERT INTO [jtbc_aboutus] (s_topic, s_time, s_userid) VALUES ('关于我们', '2014-01-01 23:00:00', 1);
INSERT INTO [jtbc_aboutus] (s_topic, s_time, s_userid) VALUES ('联系我们', '2014-01-01 23:00:00', 1);
INSERT INTO [jtbc_communal_menu] (cm_topic, cm_class, cm_target, cm_url, cm_order, cm_time, cm_userid) VALUES ('首页', 1, '_self', './', 0, '2014-01-01 23:00:00', 1);
INSERT INTO [jtbc_communal_menu] (cm_topic, cm_class, cm_target, cm_url, cm_order, cm_time, cm_userid) VALUES ('企业介绍', 1, '_self', 'aboutus/?type=detail&id=1', 1, '2014-01-01 23:00:00', 1);
INSERT INTO [jtbc_communal_menu] (cm_topic, cm_class, cm_target, cm_url, cm_order, cm_time, cm_userid) VALUES ('新闻动态', 1, '_self', 'news', 2, '2014-01-01 23:00:00', 1);
INSERT INTO [jtbc_communal_menu] (cm_topic, cm_class, cm_target, cm_url, cm_order, cm_time, cm_userid) VALUES ('产品中心', 1, '_self', 'products', 3, '2014-01-01 23:00:00', 1);
INSERT INTO [jtbc_communal_menu] (cm_topic, cm_class, cm_target, cm_url, cm_order, cm_time, cm_userid) VALUES ('招贤纳士', 1, '_self', 'career/position', 3, '2014-01-01 23:00:00', 1);
INSERT INTO [jtbc_communal_menu] (cm_topic, cm_class, cm_target, cm_url, cm_order, cm_time, cm_userid) VALUES ('访客留言', 1, '_self', 'guestbook', 5, '2014-01-01 23:00:00', 1);
INSERT INTO [jtbc_communal_menu] (cm_topic, cm_class, cm_target, cm_url, cm_order, cm_time, cm_userid) VALUES ('关于我们', 2, '_self', 'aboutus/?type=detail&id=1', 0, '2014-01-01 23:00:00', 1);
INSERT INTO [jtbc_communal_menu] (cm_topic, cm_class, cm_target, cm_url, cm_order, cm_time, cm_userid) VALUES ('联系我们', 2, '_self', 'aboutus/?type=detail&id=2', 1, '2014-01-01 23:00:00', 1)