var editor = {
  tClear: function()
  {
    for (te in tinymce.editors)
    {
      var tInstances = tinymce.get(te);
      if (tInstances) tinymce.remove(tInstances);
    };
  },
  tGetXHTML: function(_name)
  {
    var tXHTML = '';
    var tname = _name;
    tXHTML = tinymce.get(tname).getContent();
    return tXHTML;
  },
  tInsertHtml: function(_name, _strers)
  {
    var tname = _name;
    var tstrers = _strers;
    tinymce.get(tname).execCommand('mceInsertContent', false, tstrers);
  },
  tInsertImage: function(_name, _strers)
  {
    var tname = _name;
    var tstrers = _strers;
    if (tstrers)
    {
      var tLocation = location.href.substr(0, location.href.lastIndexOf('/'));
      tstrers = '<img src="' + tLocation + '/' + tstrers + '" />';
      editor.tInsertHtml(tname, tstrers);
    };
  },
  tInsertAttachments: function(_name, _strers, _text)
  {
    var tname = _name;
    var tstrers = _strers;
    var ttext = _text;
    if (tstrers)
    {
      var tLocation = location.href.substr(0, location.href.lastIndexOf('/'));
      var tfiletype = tstrers.substr(tstrers.lastIndexOf('.'));
      if (tfiletype == '.jpg' || tfiletype == '.gif' || tfiletype == '.png') tstrers = '<img src="' + tLocation + '/' + tstrers + '" />';
      else tstrers = '<a href="' + tLocation + '/' + tstrers + '" target="_blank">' + ttext + '</a>';
      editor.tInsertHtml(tname, tstrers);
    };
  },
  tSetInputValue: function(_name)
  {
    var tname = _name;
    var tobj = $I(tname);
    if (tobj) tobj.value = editor.tGetXHTML(tname);
  }
};

var tinymceArray = {
  selector: '.mceEditor',
  language: 'zh_CN',
  plugins: [
    'advlist autolink link image lists charmap print preview hr anchor pagebreak spellchecker',
    'searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking',
    'table contextmenu directionality emoticons template textcolor paste textcolor colorpicker'
  ],
  toolbar1: 'bold italic underline strikethrough | alignleft aligncenter alignright alignjustify | styleselect formatselect fontselect fontsizeselect',
  toolbar2: 'newdocument | cut copy paste pastetext | searchreplace | bullist numlist | outdent indent blockquote | undo redo | link unlink anchor image media',
  toolbar3: 'table | hr removeformat | subscript superscript | charmap emoticons | ltr rtl | visualchars visualblocks nonbreaking pagebreak restoredraft | insertfile insertimage | forecolor backcolor | insertdatetime | print preview code',
  menubar: false,
  toolbar_items_size: 'small'
};

tinymce.init(tinymceArray);
