﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.SqlClient;
using System.Data;

namespace DBUtility
{
    public class SqlServerDbHelper
    {
        static string connString = "server=.\\SQL2005;database=图书管理系统;uid=sa;pwd=sa";
        public static bool Execute(string sql, List<SqlParameter> lists)//数据增、删、改要调用的方法
        {
            try
            {
                SqlConnection conn = new SqlConnection();
                conn.ConnectionString = connString;
                conn.Open();
                SqlCommand cmd = new SqlCommand();
                cmd.Connection = conn;
                cmd.CommandText = sql;
                for (int i = 0; i < lists.Count; i++)
                    cmd.Parameters.Add(lists[i]);
                cmd.ExecuteNonQuery();
                return true;
            }
            catch
            {
                return false;
            }

        }
        public static DataTable query(string sql)//数据查询要调用的方法
        {
            try
            {

                SqlConnection conn = new SqlConnection();
                conn.ConnectionString = connString;
                SqlDataAdapter da = new SqlDataAdapter(sql, conn);
                DataSet ds = new DataSet();
                da.Fill(ds);
                return ds.Tables[0];
            }
            catch
            {
                return null;

            }
        }
        public static SqlDataReader querys(string sql)
        {
            try
            {
                SqlConnection conn = new SqlConnection(connString);
                SqlCommand com = new SqlCommand(sql, conn);
                conn.Open();
                return com.ExecuteReader();
            }
            catch
            {
                return null;
            }
        }
        public static int ExecuteNonQuery(List<String> sqlList)
        {
            SqlConnection conn = new SqlConnection(connString);
            if (conn.State == ConnectionState.Closed)
            {
                conn.Open();
            }
            SqlTransaction stran = conn.BeginTransaction();
            SqlCommand cmd = new SqlCommand();
            try
            {

                cmd.Transaction = stran;
                cmd.Connection = conn;
                cmd.CommandType = CommandType.Text;
                int count = 0;
                foreach (string strSql in sqlList)
                {
                    cmd.CommandText = strSql;
                    count += cmd.ExecuteNonQuery();
                }
                stran.Commit();
                return count;
            }
            catch (Exception)
            {
                stran.Rollback();
                throw;
            }
            finally
            {
                stran.Dispose();
                conn.Close();
            }
        }
    }
}
