﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Admin_Company_Manage : System.Web.UI.Page
{
    const Int32 rows = 15;

    protected void Page_Load(object sender, EventArgs e)
    {
        if (Session["username"] == null)
        {
            Response.Write("<script>window.top.navigate('Default.aspx');</script>");
            return;
        }
        if (!IsPostBack)
        {
            //getRecordCount();
            txtPageIndex.Value = "1";
            loadData(Convert.ToInt32(txtPageIndex.Value));
        }
    }

    private void loadData(int pageNo)
    {
        try
        {
            if (pageNo == 0) pageNo = 1;

            ArrayList parameters = new ArrayList();
            int index = 0;

            //0显示行数，1过滤行数，2单位名或用户名，3审核标志

            String SelectSql = String.Format( "SELECT TOP {0} a.comid,a.username,a.companyname,a.contact_person,a.contact_phone," +
                         "CASE a.IsVerified WHEN 0 THEN '未审核' WHEN 1 THEN '已审核' END isverified," +
                         "CONVERT(VARCHAR(10),a.reg_date,120) reg_date ",rows);

            String WhereSql = " Where 1 = 1 ";

            String Name = txtParamName.Text.Trim();
            if ( Name  != "")
            {
                WhereSql += string.Format( " AND ( a.companyname LIKE @{0} or a.username like @{0}) ",index);
                parameters.Add("%" + Name + "%");
                index++;
            }

            String type = cmbType.SelectedItem.Value;
            if (type != "2")
            {
                WhereSql += string.Format("AND a.isverified = @{0}", index);
                parameters.Add(cmbType.SelectedItem.Value);
                index++;
            }


            String FromSql = " From company_base a ";
            String OrderSql = "Order By a.reg_date DESC";

            String SqlGetCount = "Select count(comid) Rows " + FromSql + WhereSql;

            String inSql = String.Format( " AND a.comid NOT IN (SELECT TOP {0} a.comid " + FromSql + WhereSql + ") ",(pageNo - 1) * rows);
            String SqlData = SelectSql + FromSql + WhereSql + inSql + OrderSql;

            DataSet ds = DB.GetDataSet(SqlGetCount + ";" + SqlData, parameters);
            DataTable dt_Rows = ds.Tables[0];

            Int32 RowCount = Convert.ToInt32(dt_Rows.Rows[0][0]);
            txtPagesCnt.Value = Common.getPageCnt(RowCount, rows).ToString();
            lblRecCnt.Text = RowCount.ToString();
            if (txtPagesCnt.Value == "0")
            {
                lblCurrent.Text = "无记录";
            }
            else
            {
                lblCurrent.Text = String.Format("第{0}页", txtPageIndex.Value);
            }
            lblPageCnt.Text = txtPagesCnt.Value;



            DataTable jobs = ds.Tables[1];
            grdCompany.DataSource = jobs;
            grdCompany.DataBind();
            lblCurrent.Text = pageNo.ToString();
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }

    protected void btnOut_Click(object sender, EventArgs e)
    {

        String sql = "select comid 企业编号,username 用户名,companyname 企业名称,license 证件号码,industry 所属行业, "+
	                 "   type 类型,found_year + '-'+found_month+'-' + found_day 成立日期,reg_capital 注册资本,workers 员工数, "+
	                 "   province + city 所在地,contact_person  联系人,contact_phone 联系电话,contact_fax 传真,email 电子邮件, "+
	                 "   website 企业首页,zipcode 邮编,address 地址,reg_date 注册日期,last_update_date 更新日期, "+
                     "   memo 备注 " +
                    "from    dbo.company_base order by ncid asc ";
        ExcelObj.DataTable2Excel(this.Page.Response, DB.GetDataSet(sql).Tables[0], "company_base.xls");


    }


    protected void btnget_Click(object sender, EventArgs e)
    {
        CheckBox chkSelect;
        int index = 0;
        String UpdateId = "";
        ArrayList Params = new ArrayList();

        try
        {
            for (int i = 0; i < grdCompany.Rows.Count; i++)
            {
                chkSelect = (CheckBox)grdCompany.Rows[i].FindControl("chkSelect");
                if (chkSelect.Checked)
                {
                    UpdateId += String.Format("@{0},", index) ;
                    Params.Add( ((Label)grdCompany.Rows[i].FindControl("lblComId")).Text );
                    index++;
                }
            }
            if (index > 0)
            {
                UpdateId = UpdateId.Substring(0, UpdateId.Length - 1);
                String sql = String.Format("delete from company_base WHERE comid in ({0})", UpdateId);
                DB.ExecuteSQL(sql, Params);

                
                loadData(Convert.ToInt32(txtPageIndex.Value));
            }
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
        }

    }




    //private void getRecordCount()
    //{
    //    object[] parameters = new object[2];
    //    String sql = String.Format("SELECT COUNT(a.comid) cnt  " +
    //                 "FROM company_base a  {0} ", getWhere(ref parameters));

    //    DataTable inbox = DB.GetDataSet(sql, parameters).Tables[0];
    //    Int32 recCnt = Convert.ToInt32(inbox.Rows[0]["cnt"].ToString());
    //    txtPagesCnt.Value = Common.getPageCnt(recCnt, rows).ToString();
    //    lblRecCnt.Text = recCnt.ToString();
    //    if (txtPagesCnt.Value == "0")
    //    {
    //        lblCurrent.Text = "无记录";
    //    }
    //    else
    //    {
    //        lblCurrent.Text = String.Format("第{0}页", txtPageIndex.Value);
    //    }
    //    lblPageCnt.Text = txtPagesCnt.Value;
    //}

    //private String getWhere(ref object[] parameters)
    //{
    //    String where = "WHERE 1=1 ";

    //    if (txtParamName.Text.Trim() != "")
    //    {
    //        where += "AND ( a.companyname LIKE @0 or a.username like @0) ";
    //        parameters[ parameters.Length ] = "%" + txtParamName.Text + "%";
           
    //    }
    //    String type = cmbType.SelectedItem.Value;
    //    if (type != "2")
    //    {
    //        where += "AND a.isverified = @1" ;
    //        parameters[parameters.Length] = type;
    //    }

    //    return where;
    //}

    protected void btnFirst_Click(object sender, EventArgs e)
    {
        txtPageIndex.Value = "1";
        loadData(Convert.ToInt32(txtPageIndex.Value));

    }

    protected void btnPer_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtPageIndex.Value);
        if (index - 1 < 1)
            txtPageIndex.Value = "1";
        else
            txtPageIndex.Value = Convert.ToString(--index);
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnNext_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtPageIndex.Value);
        if (index + 1 > Convert.ToInt32(txtPagesCnt.Value))
            txtPageIndex.Value = txtPagesCnt.Value;
        else
            txtPageIndex.Value = Convert.ToString(++index);
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnLast_Click(object sender, EventArgs e)
    {
        txtPageIndex.Value = txtPagesCnt.Value;
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnGoto_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtGo.Text);
        txtPageIndex.Value = txtGo.Text;
        if (index < 1)
            txtPageIndex.Value = "1";
        if (index > Convert.ToInt32(txtPagesCnt.Value))
            txtPageIndex.Value = txtPagesCnt.Value;

        txtGo.Text = txtPageIndex.Value;
        loadData(Convert.ToInt32(txtPageIndex.Value));

    }

    protected void btnSearch_Click(object sender, EventArgs e)
    {
        //getRecordCount();
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnActive_Click(object sender, EventArgs e)
    {
        setVerified(1);
    }

    protected void btnDeactive_Click(object sender, EventArgs e)
    {
        setVerified(0);
    }

    private void setVerified(int verified)
    {
        CheckBox chkSelect;
        int index = 0;
        String UpdateId = "";
        ArrayList parameters = new ArrayList();
        try
        {
            for (int i = 0; i < grdCompany.Rows.Count; i++)
            {
                chkSelect = (CheckBox)grdCompany.Rows[i].FindControl("chkSelect");
                if (chkSelect.Checked)
                {
                    UpdateId += String.Format("@{0},",index);
                    parameters.Add( ((Label)grdCompany.Rows[i].FindControl("lblComId")).Text );
                    index++;
                }
            }

            if (index > 0)
            {
                UpdateId = UpdateId.Substring(0, UpdateId.Length - 1);
                parameters.Add( verified);
                String sql = String.Format("UPDATE company_base SET isverified=@{0} WHERE comid in ({1})", index,UpdateId);
                DB.ExecuteSQL(sql,parameters);

                //getRecordCount();
                if ( Convert.ToInt32(txtPageIndex.Value) > Convert.ToInt32(txtPagesCnt.Value))
                    txtPageIndex.Value = txtPagesCnt.Value;
                loadData(Convert.ToInt32(txtPageIndex.Value));
            }
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
        }
    }

    protected void cmbType_SelectedIndexChanged(object sender, EventArgs e)
    {
        //getRecordCount();
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }
}
