using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Admin_Job_Manage : System.Web.UI.Page
{
    const Int32 rows = 15;

    protected void Page_Load(object sender, EventArgs e)
    {
        if (Session["username"] == null)
        {
            Response.Write("<script>window.top.navigate('Default.aspx');</script>");
            return;
        }
        if (!IsPostBack)
        {
            getRecordCount();
            txtPageIndex.Value = "1";
            loadData(Convert.ToInt32(txtPageIndex.Value));
        }
    }



    protected void btnOut_Click(object sender, EventArgs e)
    {

        String sql = "SELECT * from jobs order by jobid asc ";
        ExcelObj.DataTable2Excel(this.Page.Response, DB.GetDataSet(sql).Tables[0], "jobs.xls");


    }


    protected void btnget_Click(object sender, EventArgs e)
    {
        CheckBox chkSelect;
        int index = 0;
        String UpdateId = "";
        ArrayList parameters = new ArrayList();
        try
        {
            for (int i = 0; i < grdCompany.Rows.Count; i++)
            {
                chkSelect = (CheckBox)grdCompany.Rows[i].FindControl("chkSelect");
                if (chkSelect.Checked)
                {
                    UpdateId += String.Format("@{0},", index);
                    parameters.Add(((Label)grdCompany.Rows[i].FindControl("lblJobId")).Text);
                    index++;
                }
            }
            if (index > 0)
            {
                UpdateId = UpdateId.Substring(0, UpdateId.Length - 1);
                String sql = String.Format("delete Jobs WHERE jobid in ({0})", UpdateId);
                DB.ExecuteSQL(sql, parameters);

                getRecordCount();
                if (Convert.ToInt32(txtPageIndex.Value) > Convert.ToInt32(txtPagesCnt.Value))
                    txtPageIndex.Value = txtPagesCnt.Value;

                loadData(Convert.ToInt32(txtPageIndex.Value));
            }
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
        }


    }
    private void loadData(int pageNo)
    {
        try
        {
            if (pageNo == 0)
                pageNo = 1;
            object[] parameters = new object[1];

            String sql = String.Format("SELECT TOP {0} a.jobid, a.number, a.jobname, a.comid, b.companyname," +
                         "CASE a.IsVerified WHEN 0 THEN 'δ' WHEN 1 THEN '' END IsVerified," +
                         "CASE a.IsActive WHEN 0 THEN 'δ' WHEN 1 THEN 'Ѽ' END IsActive," +
                         "CONVERT(VARCHAR(10),a.enddate,120) enddate," +
                         "CONVERT(VARCHAR(10),a.lastupdate_date,120) lastupdate_date ", rows);
            String whereSql = String.Format("FROM jobs a left join company_base b on b.comid = a.comid {0} ", getWhere(parameters,true));
            String ordSql = " ORDER BY a.jobid DESC";

            String inSql = String.Format(" AND b.IsVerified=1 AND a.jobid NOT IN (SELECT TOP {0} a.jobid {1} {2})", (pageNo - 1) * rows, whereSql, ordSql);
            sql = sql + whereSql + inSql + ordSql;

            DataTable jobs = DB.GetDataSet(sql, parameters).Tables[0];
            grdCompany.DataSource = jobs;
            grdCompany.DataBind();
            lblCurrent.Text = pageNo.ToString();
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }

    private void getRecordCount()
    {
        object[] parameters = new object[1];
        String sql = String.Format("SELECT COUNT(a.jobid) cnt  " +
                     "FROM jobs a  {0} ", getWhere(parameters));
        DataTable inbox = DB.GetDataSet(sql, parameters).Tables[0];
        Int32 recCnt = Convert.ToInt32(inbox.Rows[0]["cnt"].ToString());
        txtPagesCnt.Value = Common.getPageCnt(recCnt, rows).ToString();
        lblRecCnt.Text = recCnt.ToString();
        if (txtPagesCnt.Value == "0")
        {
            lblCurrent.Text = "޼¼";
        }
        else
        {
            lblCurrent.Text = String.Format("{0}ҳ", txtPageIndex.Value);
        }
        lblPageCnt.Text = txtPagesCnt.Value;
    }

    private String getWhere(object[] parameters, Boolean WithB)
    {
        String where = "WHERE 1=1 ";

        if (txtParamName.Text.Trim() != "")
        {
            if (WithB)
            {
                where += "AND (a.jobname LIKE @0 or b.companyname like @0 ) ";
            }
            else
            {
                where += "AND (a.jobname LIKE @0 ) ";
            }
            parameters[0] = "%" + txtParamName.Text + "%";
        }
        String type = cmbType.SelectedItem.Value;
        if (type != "2")
            where += "AND a.isverified = " + type;
        return where;
    }

    private String getWhere(object[] parameters)
    {
        return getWhere(parameters, false);
    }

    protected void btnFirst_Click(object sender, EventArgs e)
    {
        txtPageIndex.Value = "1";
        loadData(Convert.ToInt32(txtPageIndex.Value));

    }

    protected void btnPer_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtPageIndex.Value);
        if (index - 1 < 1)
            txtPageIndex.Value = "1";
        else
            txtPageIndex.Value = Convert.ToString(--index);
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnNext_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtPageIndex.Value);
        if (index + 1 > Convert.ToInt32(txtPagesCnt.Value))
            txtPageIndex.Value = txtPagesCnt.Value;
        else
            txtPageIndex.Value = Convert.ToString(++index);
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnLast_Click(object sender, EventArgs e)
    {
        txtPageIndex.Value = txtPagesCnt.Value;
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnGoto_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtGo.Text);
        txtPageIndex.Value = txtGo.Text;
        if (index < 1)
            txtPageIndex.Value = "1";
        if (index > Convert.ToInt32(txtPagesCnt.Value))
            txtPageIndex.Value = txtPagesCnt.Value;

        txtGo.Text = txtPageIndex.Value;
        loadData(Convert.ToInt32(txtPageIndex.Value));

    }

    protected void btnSearch_Click(object sender, EventArgs e)
    {
        getRecordCount();
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnActive_Click(object sender, EventArgs e)
    {
        setVerified(1);
    }

    protected void btnDeactive_Click(object sender, EventArgs e)
    {
        setVerified(0);
    }

    private void setVerified(int verified)
    {
        CheckBox chkSelect;
        int index = 0;
        String UpdateId = "";
        ArrayList parameters = new ArrayList();
        try
        {
            for (int i = 0; i < grdCompany.Rows.Count; i++)
            {
                chkSelect = (CheckBox)grdCompany.Rows[i].FindControl("chkSelect");
                if (chkSelect.Checked)
                {
                    UpdateId += String.Format("@{0},", index);
                    parameters.Add(((Label)grdCompany.Rows[i].FindControl("lblJobId")).Text);
                    index++;
                }
            }
            if (index > 0)
            {
                UpdateId = UpdateId.Substring(0, UpdateId.Length - 1);
                String sql = String.Format("UPDATE Jobs SET isverified=@{0} WHERE jobid in ({1})", index, UpdateId);
                parameters.Add(verified);
                index++;
                DB.ExecuteSQL(sql, parameters);

                getRecordCount();
                if (Convert.ToInt32(txtPageIndex.Value) > Convert.ToInt32(txtPagesCnt.Value))
                    txtPageIndex.Value = txtPagesCnt.Value;
                loadData(Convert.ToInt32(txtPageIndex.Value));
            }
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
        }
    }

    protected void cmbType_SelectedIndexChanged(object sender, EventArgs e)
    {
        getRecordCount();
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }
}
