﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Admin_Person_Manage : System.Web.UI.Page
{
    const Int32 rows = 15;
    protected void Page_Load(object sender, EventArgs e)
    {
        if (Session["username"] == null)
        {
            Response.Write("<script>window.top.navigate('Default.aspx');</script>");
            return;
        }
        if (!IsPostBack)
        {
            getRecordCount();
            txtPageIndex.Value = "1";
            loadData(Convert.ToInt32(txtPageIndex.Value));
        }
    }

    protected void btnOut_Click(object sender, EventArgs e)
    {

        String sql = "select a.perid 个人编号,username 用户名,realname 姓名,case sex when 1 then '男' when 0 then '女' else '保密' end as 性别,"+
		             "       nation,birth_year+'-'+birth_month+'-'+birth_day as 出生日期,"+
		             "       case marrage when 1 then '未婚' when 2 then '已婚' when 3 then '离异' else '保密' end as 婚姻状况,"+
		             "       stature 身高,weight 体重,education 学历,zhuanye 专业,mobilephone 手机号码,phone 电话号码,email 电子邮件,zipcode 邮编,address 地址,"+
                     "       usertype 用户类型,idcardtype 证件类型,idcardno 证件号码,hukou_province+hukou_city 户口所在地,current_province+current_city 目前所在地," +
		             "       webhome 个人主页,reg_date 注册日期,lastupdate_date 更新日期 "+
                    "from personal_base a "+
                    "    join personal_info b on a.perid = b.perid " +
                    "order by Ncid asc ";
        ExcelObj.DataTable2Excel(this.Page.Response, DB.GetDataSet(sql).Tables[0], "personal_base.xls");


    }


    protected void btnget_Click(object sender, EventArgs e)
    {
        CheckBox chkSelect;
        int index = 0;
        String UpdateId = "";
        ArrayList Params = new ArrayList();

        try
        {
            for (int i = 0; i < grdPerson.Rows.Count; i++)
            {
                chkSelect = (CheckBox)grdPerson.Rows[i].FindControl("chkSelect");
                if (chkSelect.Checked)
                {
                    UpdateId += String.Format("@{0},", index);
                    Params.Add(((Label)grdPerson.Rows[i].FindControl("lblPerId")).Text);
                    index++;
                }
            }
            if (index > 0)
            {
                UpdateId = UpdateId.Substring(0, UpdateId.Length - 1);
                String sql = String.Format("delete from personal_base WHERE perid in ({0})", UpdateId);
                DB.ExecuteSQL(sql, Params);


                loadData(Convert.ToInt32(txtPageIndex.Value));
            }
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
        }
    }



    private void loadData(int pageNo)
    {
        try
        {
            if (pageNo == 0)
                pageNo = 1;
            object[] parameters = new object[1];

            String sql = String.Format("SELECT TOP {0} a.perid,b.realname,a.username,b.education,a.mobilephone," +
                         "CASE a.IsVerified WHEN 0 THEN '未审核' WHEN 1 THEN '已审核' END isverified," +
                         "CONVERT(VARCHAR(10),a.reg_date,120) reg_date ", rows);
            String whereSql = String.Format("FROM personal_base a LEFT JOIN personal_info b on a.perid=b.perid {0} ", getWhere(parameters));
            String ordSql = "ORDER BY a.reg_date DESC";

            String inSql = String.Format(" AND a.perid NOT IN (SELECT TOP {0} a.perid {1} {2})", (pageNo - 1) * rows, whereSql, ordSql);
            sql = sql + whereSql + inSql + ordSql;

            DataTable jobs = DB.GetDataSet(sql, parameters).Tables[0];
            grdPerson.DataSource = jobs;
            grdPerson.DataBind();
            lblCurrent.Text = pageNo.ToString();
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }

    private void getRecordCount()
    {
        object[] parameters = new object[1];
        String sql = String.Format("SELECT COUNT(a.perid) cnt  " +
                     "FROM personal_base a LEFT JOIN personal_info b on a.perid=b.perid {0} ", getWhere(parameters));
        DataTable inbox = DB.GetDataSet(sql, parameters).Tables[0];
        Int32 recCnt = Convert.ToInt32(inbox.Rows[0]["cnt"].ToString());
        txtPagesCnt.Value = Common.getPageCnt(recCnt, rows).ToString();
        lblRecCnt.Text = recCnt.ToString();
        if (txtPagesCnt.Value == "0")
        {
            lblCurrent.Text = "无记录";
        }
        else
        {
            lblCurrent.Text = String.Format("第{0}页", txtPageIndex.Value);
        }
        lblPageCnt.Text = txtPagesCnt.Value;
    }

    private String getWhere(object[] parameters)
    {
        String where = "WHERE 1= 1 ";

        if (txtParamName.Text.Trim() != "")
        {
            where += "AND (b.RealName LIKE @0 or a.username like @0) ";
            parameters[0] = "%" + txtParamName.Text + "%";
        }

        return where;
    }

    protected void btnFirst_Click(object sender, EventArgs e)
    {
        txtPageIndex.Value = "1";
        loadData(Convert.ToInt32(txtPageIndex.Value));

    }

    protected void btnPer_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtPageIndex.Value);
        if (index - 1 < 1)
            txtPageIndex.Value = "1";
        else
            txtPageIndex.Value = Convert.ToString(--index);
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnNext_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtPageIndex.Value);
        if (index + 1 > Convert.ToInt32(txtPagesCnt.Value))
            txtPageIndex.Value = txtPagesCnt.Value;
        else
            txtPageIndex.Value = Convert.ToString(++index);
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnLast_Click(object sender, EventArgs e)
    {
        txtPageIndex.Value = txtPagesCnt.Value;
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnGoto_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtGo.Text);
        txtPageIndex.Value = txtGo.Text;
        if (index < 1)
            txtPageIndex.Value = "1";
        if (index > Convert.ToInt32(txtPagesCnt.Value))
            txtPageIndex.Value = txtPagesCnt.Value;

        txtGo.Text = txtPageIndex.Value;
        loadData(Convert.ToInt32(txtPageIndex.Value));

    }

    protected void btnSearch_Click(object sender, EventArgs e)
    {
        getRecordCount();
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnActive_Click(object sender, EventArgs e)
    {
        setVerified(1);
    }

    protected void btnDeactive_Click(object sender, EventArgs e)
    {
        setVerified(0);
    }

    private void setVerified(int verified)
    {
        CheckBox chkSelect;
        int index = 0;
        String UpdateId = "";
        ArrayList parameters = new ArrayList();

        try
        {
            for (int i = 0; i < grdPerson.Rows.Count; i++)
            {
                chkSelect = (CheckBox)grdPerson.Rows[i].FindControl("chkSelect");
                if (chkSelect.Checked)
                {
                    UpdateId += String.Format("@{0},",index);
                    parameters.Add( ((Label)grdPerson.Rows[i].FindControl("lblPerId")).Text );
                    index++;
                }
            }
            if (index > 0)
            {
                UpdateId = UpdateId.Substring(0, UpdateId.Length - 1);
                String sql = String.Format("UPDATE personal_base SET isverified=@{0} WHERE perid in ({1})", index, UpdateId);
                parameters.Add(verified);
                index++;
                DB.ExecuteSQL(sql);

                sendOkSms(UpdateId, parameters);

                getRecordCount();
                if (Convert.ToInt32(txtPageIndex.Value) > Convert.ToInt32(txtPagesCnt.Value))
                    txtPageIndex.Value = txtPagesCnt.Value;

                loadData(Convert.ToInt32(txtPageIndex.Value));
            }
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
        }
    }
    protected void cmbType_SelectedIndexChanged(object sender, EventArgs e)
    {
        getRecordCount();
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }

    protected void sendOkSms(String perids, ArrayList parameters)
    {
        String sql = "select MobilePhone, UserName from personal_base where perid in ({0})";
        sql = String.Format(sql, perids);
        DataSet ds = DB.GetDataSet(sql, parameters);

        for (int i = 0; i < ds.Tables[0].Rows.Count; i++)
        {
            DataRow row = ds.Tables[0].Rows[i];
            sendSms(row["UserName"].ToString(), "您在五华就业网上注册的用户已经通过了管理员审核，您可以使用手机登录wap.mzjob.gd.chinamobile.com查询职位信息。", "System");
        }
    }

    protected void sendSms(String mobile, String content, String userName)
    {
        ArrayList listParam = new ArrayList();
        String sql = "INSERT INTO send_sms(Mobilephone, MessageContent, UserName) " +
                          "VALUES(@0,@1,@2)";

        listParam.Add(mobile);
        listParam.Add(content);
        listParam.Add(userName);

        DB.ExecuteSQL(sql, listParam);
    }

}
