using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Admin_User_Manager : System.Web.UI.Page
{
    const Int32 rows = 15;
    protected void Page_Load(object sender, EventArgs e)
    {
        if (Session["username"] == null)
        {
            Response.Write("<script>window.top.navigate('Default.aspx');</script>");
            return;
        }
        if (!IsPostBack)
        {
            getRecordCount();
            txtPageIndex.Value = "1";
            loadData(Convert.ToInt32(txtPageIndex.Value));
        }
    }
    private void loadData(int pageNo)
    {
        try
        {
            if (pageNo == 0)
                pageNo = 1;
            object[] parameters = new object[1];

            String sql = String.Format("SELECT TOP {0} a.AdminId,a.username,a.Email,a.MobilePhone," +
                        " CASE a.IsActive WHEN 0 THEN '' WHEN 1 THEN '' END IsActive," +
                         " CONVERT(VARCHAR(11),a.AddDate,120) AddDate ", rows);
            String whereSql = String.Format("FROM admin_base a {0} ", getWhere(parameters));
            String ordSql = "ORDER BY a.AddDate DESC";

            String inSql = String.Format(" AND a.AdminId NOT IN (SELECT TOP {0} a.AdminId {1} {2})", (pageNo - 1) * rows, whereSql, ordSql);
            sql = sql + whereSql + inSql + ordSql;

            DataTable jobs = DB.GetDataSet(sql, parameters).Tables[0];
            grdUser.DataSource = jobs;
            grdUser.DataBind();
            lblCurrent.Text = pageNo.ToString();
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }

    private void getRecordCount()
    {
        object[] parameters = new object[1];
        String sql = String.Format("SELECT COUNT(a.AdminID) cnt  " +
                     "FROM admin_base a  {0} ", getWhere(parameters));
        DataTable inbox = DB.GetDataSet(sql, parameters).Tables[0];
        Int32 recCnt = Convert.ToInt32(inbox.Rows[0]["cnt"].ToString());
        txtPagesCnt.Value = Common.getPageCnt(recCnt, rows).ToString();
        lblRecCnt.Text = recCnt.ToString();
        if (txtPagesCnt.Value == "0")
        {
            lblCurrent.Text = "޼¼";
        }
        else
        {
            lblCurrent.Text = String.Format("{0}ҳ", txtPageIndex.Value);
        }
        lblPageCnt.Text = txtPagesCnt.Value;
    }

    private String getWhere(object[] parameters)
    {
        String where = "WHERE 1=1 and username <> 'admin' ";

        if (txtParamName.Text.Trim() != "")
        {
            where += "AND a.UserName LIKE @0 ";
            parameters[0] = "%" + txtParamName.Text + "%";
        }

        return where;
    }

    protected void btnFirst_Click(object sender, EventArgs e)
    {
        txtPageIndex.Value = "1";
        loadData(Convert.ToInt32(txtPageIndex.Value));

    }

    protected void btnPer_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtPageIndex.Value);
        if (index - 1 < 1)
            txtPageIndex.Value = "1";
        else
            txtPageIndex.Value = Convert.ToString(--index);
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnNext_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtPageIndex.Value);
        if (index + 1 > Convert.ToInt32(txtPagesCnt.Value))
            txtPageIndex.Value = txtPagesCnt.Value;
        else
            txtPageIndex.Value = Convert.ToString(++index);
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnLast_Click(object sender, EventArgs e)
    {
        txtPageIndex.Value = txtPagesCnt.Value;
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnGoto_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtGo.Text);
        txtPageIndex.Value = txtGo.Text;
        if (index < 1)
            txtPageIndex.Value = "1";
        if (index > Convert.ToInt32(txtPagesCnt.Value))
            txtPageIndex.Value = txtPagesCnt.Value;

        txtGo.Text = txtPageIndex.Value;
        loadData(Convert.ToInt32(txtPageIndex.Value));

    }

    protected void btnSearch_Click(object sender, EventArgs e)
    {
        getRecordCount();
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnAdd_Click(object sender, EventArgs e)
    {
        Response.Redirect("user_detail.aspx");
    }

    protected void btnActive_Click(object sender, EventArgs e)
    {
        setVerified(1);
    }

    protected void btnDeactive_Click(object sender, EventArgs e)
    {
        setVerified(0);
    }

    private void setVerified(int verified)
    {
        CheckBox chkSelect;
        int index = 0;
        String UpdateId = "";
        ArrayList paramsList = new ArrayList();

        try
        {
            for (int i = 0; i < grdUser.Rows.Count; i++)
            {
                chkSelect = (CheckBox)grdUser.Rows[i].FindControl("chkSelect");
                if (chkSelect.Checked)
                {
                    UpdateId += String.Format("@{0},", index);
                    paramsList.Add(((Label)grdUser.Rows[i].FindControl("lblAdminId")).Text);
                    index++;
                }
            }
            if (index > 0)
            {
                UpdateId = UpdateId.Substring(0, UpdateId.Length - 1);
                String sql = String.Format("UPDATE admin_base SET isactive=@{0} WHERE adminid in ({1})", index, UpdateId);
                paramsList.Add(verified);
                index++;

                DB.ExecuteSQL(sql, paramsList);

                getRecordCount();
                if (Convert.ToInt32(txtPageIndex.Value) > Convert.ToInt32(txtPagesCnt.Value))
                    txtPageIndex.Value = txtPagesCnt.Value;
                loadData(Convert.ToInt32(txtPageIndex.Value));
            }
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
        }
    }
    protected void btnDel_Click(object sender, EventArgs e)
    {
        CheckBox chkSelect;
        int index = 0;
        String UpdateId = "";
        ArrayList paramsList = new ArrayList();

        try
        {
            for (int i = 0; i < grdUser.Rows.Count; i++)
            {
                chkSelect = (CheckBox)grdUser.Rows[i].FindControl("chkSelect");
                if (chkSelect.Checked)
                {
                    UpdateId += String.Format("@{0},", index);
                    paramsList.Add(((Label)grdUser.Rows[i].FindControl("lblAdminId")).Text);
                    index++;
                }
            }
            if (index > 0)
            {
                UpdateId = UpdateId.Substring(0, UpdateId.Length - 1);
                String sql = String.Format("delete admin_base WHERE adminid in ({0})", UpdateId);

                DB.ExecuteSQL(sql, paramsList);

                getRecordCount();
                if (Convert.ToInt32(txtPageIndex.Value) > Convert.ToInt32(txtPagesCnt.Value))
                    txtPageIndex.Value = txtPagesCnt.Value;
                loadData(Convert.ToInt32(txtPageIndex.Value));
            }
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
        }
    }
}
