﻿using System;
using System.Data;
using System.Configuration;
using System.Data.SqlClient;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Admin_news_Manage : System.Web.UI.Page
{
    const Int32 rows = 15;
    protected void Page_Load(object sender, EventArgs e)
    {
        if (Session["username"] == null)
        {
            Response.Write("<script>window.top.navigate('Default.aspx');</script>");
            return;
        }
        if (!IsPostBack)
        {
            //getRecordCount();
            txtPageIndex.Value = "1";
            loadData(Convert.ToInt32(txtPageIndex.Value));


            string SQL = "select top 1 0 as typeid,'(全部)'  as typename,0 as OrderNum from news_type "+
                        "union all "+
                        "select typeid,case when parentid = 0 then '' else '|--' end +typename,OrderNum "+
                        "from news_type "+
                        "order by OrderNum";
            DataTable dt = DB.GetDataSet(SQL).Tables[0];

            ddl_ParentType.DataSource = dt;
            ddl_ParentType.DataTextField = "typename";
            ddl_ParentType.DataValueField = "typeid";
            ddl_ParentType.DataBind();
        }
    }
  

    private void loadData(int pageNo)
    {
        try
        {
            if (pageNo == 0)
                pageNo = 1;
            object[] parameters = new object[2];
            int paramsNum = 0;

            String sql = String.Format("SELECT TOP {0} a.newsid,a.title,b.typename, (c.typename + ' -') as parenttypename, a.isHot,a.isRecommend,a.isActive,b.orderNum," +
                         "CONVERT(VARCHAR(10),a.adddate,120) adddate ", rows);

            String fromSql = "FROM news_info a "+
                             "     LEFT JOIN news_type b on a.typeid = b.typeid "+
                             "      left join news_type c on b.parentid = c.typeid ";
            
            String whereSql = "WHERE 1=1 ";
            if (txtParamName.Text.Trim() != "")
            {
                whereSql += string.Format("AND a.Title LIKE @{0} ",paramsNum);
                parameters[paramsNum] = "%" + txtParamName.Text + "%";
                paramsNum++;
            }

            string ParentType = this.ddl_ParentType.SelectedValue + "";
            if (ParentType != "" && ParentType != "0")
            {
                whereSql += string.Format( "AND (b.parentid = @{0} or b.typeid = @{0} ) ",paramsNum);
                parameters[paramsNum] = ParentType;
                paramsNum++;
            }

            
            String ordSql = "ORDER BY b.orderNum,a.adddate DESC";

            String inSql = String.Format(" AND a.newsid NOT IN (SELECT TOP {0} a.newsid {1} {2} {3})", (pageNo - 1) * rows, fromSql, whereSql, ordSql);
            sql = sql + fromSql + whereSql + inSql + ordSql;



            /////////////////////////////生成记录数*************************************************
            //object[] parameters = new object[1];
            sql += ";SELECT COUNT(a.newsid) cnt  " +
                         "FROM news_info a LEFT JOIN news_type b on a.typeid = b.typeid " + whereSql;
            
            DataSet ds = DB.GetDataSet(sql, parameters);

            DataTable inbox = ds.Tables[1];
            Int32 recCnt = Convert.ToInt32(inbox.Rows[0]["cnt"].ToString());
            txtPagesCnt.Value = Common.getPageCnt(recCnt, rows).ToString();
            lblRecCnt.Text = recCnt.ToString();
            if (txtPagesCnt.Value == "0")
            {
                lblCurrent.Text = "无记录";
            }
            else
            {
                lblCurrent.Text = String.Format("第{0}页", txtPageIndex.Value);
            }
            lblPageCnt.Text = txtPagesCnt.Value;

            /////////////////////////////生成记录数******************************************************



            DataTable jobs = ds.Tables[0];
            grdPerson.DataSource = jobs;
            grdPerson.DataBind();
            lblCurrent.Text = pageNo.ToString();




        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }

    //private void getRecordCount()
    //{
    //    object[] parameters = new object[1];
    //    String sql = String.Format("SELECT COUNT(a.newsid) cnt  " +
    //                 "FROM news_info a LEFT JOIN news_type b on a.typeid=b.typeid {0} ", getWhere(parameters));
    //    DataTable inbox = DB.GetDataSet(sql, parameters).Tables[0];
    //    Int32 recCnt = Convert.ToInt32(inbox.Rows[0]["cnt"].ToString());
    //    txtPagesCnt.Value = Common.getPageCnt(recCnt, rows).ToString();
    //    lblRecCnt.Text = recCnt.ToString();
    //    if (txtPagesCnt.Value == "0")
    //    {
    //        lblCurrent.Text = "无记录";
    //    }
    //    else
    //    {
    //        lblCurrent.Text = String.Format("第{0}页", txtPageIndex.Value);
    //    }
    //    lblPageCnt.Text = txtPagesCnt.Value;
    //}

    //private String getWhere(object[] parameters)
    //{
    //    String where = "WHERE 1=1 ";

    //    if (txtParamName.Text.Trim() != "")
    //    {
    //        where += "AND a.Title LIKE @0 ";
    //        parameters[0] = "%" + txtParamName.Text + "%";
    //    }

    //    string ParentType = this.ddl_ParentType.SelectedValue + "";
    //    if (ParentType != "")
    //    {
    //        where += "AND b.parentid = @1 ";
    //        parameters[1] = ParentType;
    //    }


    //    return where;
    //}

    public String getImageUrl(String isRead)
    {
        if (isRead == "0")
            return "";
        else
            return "√";

    }

    protected void btnFirst_Click(object sender, EventArgs e)
    {
        txtPageIndex.Value = "1";
        loadData(Convert.ToInt32(txtPageIndex.Value));

    }

    protected void btnPer_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtPageIndex.Value);
        if (index - 1 < 1)
            txtPageIndex.Value = "1";
        else
            txtPageIndex.Value = Convert.ToString(--index);
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnNext_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtPageIndex.Value);
        if (index + 1 > Convert.ToInt32(txtPagesCnt.Value))
            txtPageIndex.Value = txtPagesCnt.Value;
        else
            txtPageIndex.Value = Convert.ToString(++index);
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnLast_Click(object sender, EventArgs e)
    {
        txtPageIndex.Value = txtPagesCnt.Value;
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnGoto_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtGo.Text);
        txtPageIndex.Value = txtGo.Text;
        if (index < 1)
            txtPageIndex.Value = "1";
        if (index > Convert.ToInt32(txtPagesCnt.Value))
            txtPageIndex.Value = txtPagesCnt.Value;

        txtGo.Text = txtPageIndex.Value;
        loadData(Convert.ToInt32(txtPageIndex.Value));

    }

    protected void btnSearch_Click(object sender, EventArgs e)
    {
        //getRecordCount();
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }

    protected void grdPerson_RowEditing(object sender, GridViewEditEventArgs e)
    {
        Label newsid = (Label)grdPerson.Rows[e.NewEditIndex].FindControl("lblNewsId");
        Response.Redirect("news_detail.aspx?newsid=" + newsid.Text);
    }

    protected void grdPerson_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        try
        {
            Label newsid = (Label)grdPerson.Rows[e.RowIndex].FindControl("lblNewsId");
            String sql = "DELETE FROM news_info WHERE newsid=@0";
            DB.ExecuteSQL(sql, newsid.Text);

            //getRecordCount();
            loadData(Convert.ToInt32(txtPageIndex.Value));
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }

    protected void btnAdd_Click(object sender, EventArgs e)
    {
        Response.Redirect("news_detail.aspx");
    }

    protected string Left(object s, int length)
    {
        try
        {
            string ret;

            if (s.ToString().Trim() == "")
                return "---";
            if (s.ToString().Length > length)
            {
                ret = s.ToString();
                ret = ret.Substring(0, length) + "...";
            }
            else
            {
                return s.ToString();
            }
            return ret;
        }
        catch (Exception ex)
        {
            throw ex;
        }
    }
    protected void ddl_ParentType_SelectedIndexChanged(object sender, EventArgs e)
    {
        

        this.loadData(Convert.ToInt32(txtPageIndex.Value));
    }


}
