﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.IO;

public partial class Admin_news_detail : System.Web.UI.Page
{
    private bool _state = true; //是否允许上传 
    private Stream _pic;
    private int _picsize = 0;
    private byte[] Docbuffer;

    protected void Page_Load(object sender, EventArgs e)
    {
        if (Session["username"] == null)
        {
            Response.Write("<script>window.top.navigate('Default.aspx');</script>");
            return;
        }
        if (!IsPostBack)
        {
            if (Request.QueryString["newsid"] != null)
            {
                txtNewsId.Value = Request.QueryString["newsid"].ToString();
                loadData();
            }
            else
            {
                initType();
            }

            //txtContent.config.toolbar = "Full";
          //  txtContent.config.toolbar = new object[]
          // {
          //      new object[] { "Source", "-", "Save", "NewPage", "Preview", "-", "Templates" },
          //      new object[] { "Cut", "Copy", "Paste", "PasteText", "PasteFromWord", "-", "Print", "SpellChecker", "Scayt" },
          //      new object[] { "Undo", "Redo", "-", "Find", "Replace", "-", "SelectAll", "RemoveFormat" },
          //      new object[] { "Form", "Checkbox", "Radio", "TextField", "Textarea", "Select", "Button", "ImageButton", "HiddenField" },
          //      "/",
          //      new object[] { "Bold", "Italic", "Underline", "Strike", "-", "Subscript", "Superscript" },
          //      new object[] { "NumberedList", "BulletedList", "-", "Outdent", "Indent", "Blockquote", "CreateDiv" },
          //      new object[] { "JustifyLeft", "JustifyCenter", "JustifyRight", "JustifyBlock" },
          //      new object[] { "BidiLtr", "BidiRtl" },
          //      new object[] { "Link", "Unlink", "Anchor" },
          //      new object[] { "Image", "Flash", "Table", "HorizontalRule", "Smiley", "SpecialChar", "PageBreak", "Iframe" },
          //      "/",
          //      new object[] { "Styles", "Format", "Font", "FontSize" },
          //      new object[] { "TextColor", "BGColor" },
          //      new object[] { "Maximize", "ShowBlocks", "-", "About" }
          //};


            CKFinder.FileBrowser _FileBrowser = new CKFinder.FileBrowser();
            _FileBrowser.BasePath = "../ckfinder/";
            _FileBrowser.SetupCKEditor(txtContent);
        }
    }

    private void initType()
    {
        String sql = "SELECT typeid,typename FROM news_type where ParentId = 0 ORDER BY orderNum";
        DataTable type = DB.GetDataSet(sql).Tables[0];
        cmbType.Items.Clear();
        for (int i = 0; i < type.Rows.Count; ++i)
        {
            cmbType.Items.Add(new ListItem(Convert.ToString(type.Rows[i]["typename"]), Convert.ToString(type.Rows[i]["typeid"])));
        }

        sql = "SELECT typeid,typename FROM news_type where ParentId=@0 ORDER BY orderNum";
        DataTable subtype = DB.GetDataSet(sql, cmbType.Items[0].Value ).Tables[0];
        cmbChildType.Items.Clear();
        if (subtype.Rows.Count > 0)
        {
            cmbChildType.Visible = true;
            cmbChildType.Items.Add(new ListItem("请选择", "0"));
            for (int i = 0; i < subtype.Rows.Count; ++i)
            {
                cmbChildType.Items.Add(new ListItem(Convert.ToString(subtype.Rows[i]["typename"]), Convert.ToString(subtype.Rows[i]["typeid"])));
            }
        }

    }

    private void loadData()
    {
        try
        {
            String sql = "SELECT * FROM news_info WHERE newsid=@0";
            sql += ";SELECT typeid,typename FROM news_type ORDER BY typeid";
            DataSet records = DB.GetDataSet(sql, txtNewsId.Value);
            DataTable news = records.Tables[0];
            DataTable type = records.Tables[1];

            cmbType.Items.Clear();
            for (int i = 0; i < type.Rows.Count; ++i)
            {
                cmbType.Items.Add(new ListItem(Convert.ToString(type.Rows[i]["typename"]), Convert.ToString(type.Rows[i]["typeid"])));
            }

            if (news.Rows.Count > 0)
            {
                DataRow row = news.Rows[0];
                txtTitle.Text = Convert.ToString(row["title"]);
                txtContent.Text = Convert.ToString(row["Content"]);
                

                sql = "SELECT typeid,typename,parentid FROM news_type where typeid=@0";
                DataTable subtype = DB.GetDataSet(sql, Convert.ToString(row["typeid"]) ).Tables[0];
                if (subtype.Rows.Count > 0)
                {
                    if (Convert.ToInt32(subtype.Rows[0]["parentid"]) == 0)
                        cmbType.SelectedValue = Convert.ToString(row["typeid"]);
                    else
                    {
                        cmbType.SelectedValue = Convert.ToString(subtype.Rows[0]["parentid"]);

                        sql = "SELECT typeid,typename FROM news_type where ParentId=@0 ORDER BY typeid";
                        DataTable subtype1 = DB.GetDataSet(sql, Convert.ToString(subtype.Rows[0]["parentid"]) ).Tables[0];
                        cmbChildType.Items.Clear();
                        if (subtype1.Rows.Count > 0)
                        {
                            cmbChildType.Visible = true;
                            cmbChildType.Items.Add(new ListItem("请选择", "0"));
                            for (int i = 0; i < subtype1.Rows.Count; ++i)
                            {
                                cmbChildType.Items.Add(new ListItem(Convert.ToString(subtype1.Rows[i]["typename"]), Convert.ToString(subtype1.Rows[i]["typeid"])));
                            }

                            cmbChildType.SelectedValue = Convert.ToString(row["typeid"]);
                            if (cmbChildType.SelectedItem.Text.Equals("Flash新闻"))
                            {
                                filePictureUrl.Visible = true;
                                lblPictureUrl.Visible = true;

                                lblDescription.Visible = true;

                                flashPicture.Visible = true;
                                flashPicture.ImageUrl = getPicUrl(Convert.ToString(row["PictureUrl"]), txtNewsId.Value);
                            }
                            else
                            {
                                filePictureUrl.Visible = false;
                                lblPictureUrl.Visible = false;

                                lblDescription.Visible = false;

                                flashPicture.Visible = false;
                                flashPicture.ImageUrl = "";
                            }
                        }
                    }
                }

                txtAuthor.Text = Convert.ToString(row["author"]);
                txtSource.Text = Convert.ToString(row["newsSource"]);
                chkHot.Checked = Convert.ToBoolean(row["isHot"]);
                chkRecommend.Checked = Convert.ToBoolean(row["isRecommend"]);
                chkActive.Checked = Convert.ToBoolean(row["isActive"]);
            }
            else
            {
                txtNewsId.Value = "";
            }
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }


    protected string getPicUrl(string url, string id)
    {
        string path = Server.MapPath("~/temp/image/");
        return Common.downloadFile(url, path, id, "~/temp/image/");
    }

    protected void btnOk_Click(object sender, EventArgs e)
    {
        saveData();
    }

    private void saveData()
    {
        try
        {
            if (txtContent.Text.Length <= 0)
            {
                Common.Alert("信息内容不能为空!", this);
                return;
            }
            ArrayList listParam = new ArrayList();
            String sql = "";
            String picPath = "";
          

            if (filePictureUrl.PostedFile != null)
            {
                string _FileType = filePictureUrl.PostedFile.ContentType;

                bool _state = ImageExe(_FileType);

                if (!_state) { Common.Alert("Flash图片仅支持jpg格式!", this); return; }

                string fileExtension = System.IO.Path.GetExtension(filePictureUrl.FileName).ToLower();
                string picName = DateTime.Now.ToString("yyyyMMddhhmmss") + fileExtension;
                picPath = Server.MapPath("~/News/image/") + picName;
                filePictureUrl.PostedFile.SaveAs(picPath);

                picPath = Common.uploadFile(filePictureUrl.PostedFile, "news", picName);
                if (picPath.Equals("")) { Common.Alert("上传图片失败。", this); return; }
            }


            if (txtNewsId.Value == "")
            {
                sql = "INSERT INTO news_info(title,content,typeid,author,newsSource,isHot,isVerified,isRecommend,isActive,adddate,pictureurl) " +
                      "VALUES(@0,@1,@4,@2,@3,@5,1,@6,@7,GETDATE(),@8)";
            }
            else
            {
                sql = "UPDATE news_info SET title=@0,content=@1,typeid=@4,author=@2,newsSource=@3,isHot=@5,isVerified=1," +
                      "isRecommend=@6,isActive=@7,addDate=GETDATE(),pictureurl=@8 WHERE newsid=@9";
            }

            String typeId = cmbType.SelectedItem.Value;
            if (cmbChildType.Items.Count > 0 && cmbChildType.SelectedIndex != 0)
                typeId = cmbChildType.SelectedItem.Value;

            int isHot = chkHot.Checked ? 1 : 0;
            int isRecommend = chkRecommend.Checked ? 1 : 0;
            int isActive = chkActive.Checked ? 1 : 0;
            //sql = String.Format(sql, typeId, isHot, isRecommend, isActive, picPath);

            listParam.Add(txtTitle.Text);
            listParam.Add(txtContent.Text);
            listParam.Add(txtAuthor.Text);
            listParam.Add(txtSource.Text);
            listParam.Add(typeId);
            listParam.Add(isHot);
            listParam.Add(isRecommend);
            listParam.Add(isActive);
            listParam.Add(picPath);
            listParam.Add(txtNewsId.Value);

            DB.ExecuteSQL(sql, listParam);

            //clearData();
            Common.Alert("保存信息成功!", this);


        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }

    private void clearData()
    {
        txtTitle.Text = "";
        txtContent.Text = "";
        txtAuthor.Text = "";
        txtSource.Text = "";
        cmbType.SelectedIndex = 0;
        chkHot.Checked = false;
        chkRecommend.Checked = false;
        chkActive.Checked = true;

        filePictureUrl.Visible = false;
        lblPictureUrl.Visible = false;
        flashPicture.Visible = false;
        lblDescription.Visible = false;
        flashPicture.ImageUrl = "";
    }

    protected void cmbType_SelectedIndexChanged(object sender, EventArgs e)
    {
        String sql = "SELECT typeid,typename FROM news_type where ParentId=@0 ORDER BY typeid";
        DataSet records = DB.GetDataSet(sql, cmbType.SelectedItem.Value);
        DataTable type = records.Tables[0];
        cmbChildType.Items.Clear();
        if (type.Rows.Count <= 0)
        {
            cmbChildType.Visible = false;
            return;
        }

        cmbChildType.Visible = true;
        cmbChildType.Items.Add(new ListItem("请选择", "0"));
        for (int i = 0; i < type.Rows.Count; ++i)
        {
            cmbChildType.Items.Add(new ListItem(Convert.ToString(type.Rows[i]["typename"]), Convert.ToString(type.Rows[i]["typeid"])));
        }

        filePictureUrl.Visible = false;
        lblPictureUrl.Visible = false;
        lblDescription.Visible = false;

    }
    protected void cmbChildType_SelectedIndexChanged(object sender, EventArgs e)
    {
        if (cmbChildType.SelectedItem.Text.Equals("Flash新闻"))
        {
            filePictureUrl.Visible = true;
            lblPictureUrl.Visible = true;
            lblDescription.Visible = true;
        }
        else
        {
            filePictureUrl.Visible = false;
            lblPictureUrl.Visible = false;
            lblDescription.Visible = false;
        }
    }

    /// <summary> 
    /// 把图片变成二进制流 
    /// </summary> 
    private String Binary_Code()
    {
        string _FileType = "";
        _FileType = filePictureUrl.PostedFile.ContentType;

        _state = ImageExe(_FileType);

        if (_state == true)
        {
            _pic = filePictureUrl.PostedFile.InputStream;
            _picsize = filePictureUrl.PostedFile.ContentLength;

            if (_picsize / 1024 > 1024)
            {
                Response.Write("<script>alert('图片大小超过1M')</script>");
                return "";
            }
            else
            {
                Docbuffer = new byte[_picsize];
                _pic.Read(Docbuffer, 0, _picsize);
            }

            string path = Server.MapPath(".." + "//News//image");
            string type = filePictureUrl.PostedFile.FileName.ToString().Substring(filePictureUrl.PostedFile.FileName.ToString().LastIndexOf("."), 4);
            string pic_name = DateTime.Now.ToString("yyyyMMddhhmmss") + type;

            return CreatAndUpdate(path, pic_name, Docbuffer);
        }
        else
        {
            Response.Write("<script>alert('图片格式不对，只能上传JPG格式的图片')</script>");
        }

        return "";
    }

    /// <summary> 
    /// 创建和修改图片 
    /// </summary> 
    /// <param name="path">所在文件夹路径</param> 
    /// <param name="picname">图片名</param> 
    /// <param name="pic">图片</param> 
    public String CreatAndUpdate(string path, string picname, byte[] pic)
    {
        if (!Directory.Exists(path))
        {
            Directory.CreateDirectory(path);
        }
        //pic = getThumbBype(pic, 1); //设置上传比例为1 

        if (pic.Length != 0)
        {
            path += "\\" + picname;
            if (File.Exists(path))
            {
                File.Delete(path);
            }
            FileStream fs = new FileStream(path, FileMode.Create, FileAccess.Write);
            fs.Write(pic, 0, pic.Length);
            fs.Close();

            //将path插入数据库 
            return picname;
        }
        else
        {
            Response.Write("<script>alert('图片长宽比例不正确,图片写入失败')</script>");
        }

        return "";
    }


    public byte[] getThumbBype(byte[] img, decimal scale)
    {
        System.IO.MemoryStream ms = new System.IO.MemoryStream(img);
        System.Drawing.Image panalImage = System.Drawing.Image.FromStream(ms);

        decimal ow = Convert.ToDecimal(panalImage.Width);
        decimal oh = Convert.ToDecimal(panalImage.Height);
        System.Drawing.Image bitmap;
        if (ow / oh == scale)
        {
            bitmap = panalImage;
            MemoryStream ms1 = new MemoryStream();
            bitmap.Save(ms1, System.Drawing.Imaging.ImageFormat.Jpeg);
            return ms1.GetBuffer();
        }
        else
        {
            byte[] cc = new byte[] { };
            return cc;
        }
    }

    /// <summary> 
    /// 判断是否为图片|png|jpg|gif| 
    /// </summary> 
    /// <param name="filetype">文件类型</param> 
    /// <returns>是返回true 否返回false</returns> 
    public static bool ImageExe(string filetype)
    {
        bool ReturnValue = false;
        switch (filetype)
        {
            case "image/pjpeg": //jpg 
                ReturnValue = true;
                break;
            case "image/x-png": //png 
                ReturnValue = false;
                break;
            case "image/gif": //gif 
                ReturnValue = false;
                break;
            case "image/bmp": //bmp 
                ReturnValue = false;
                break;
            default:
                break;
        }

        return ReturnValue;
    }

}
