using System;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Admin_user_detail : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (Session["username"] == null)
        {
            Response.Write("<script>window.top.navigate('Default.aspx');</script>");
            return;
        }
        if (!IsPostBack)
        {
            TreeNode node = new TreeNode("̨", "0");
            tvRigths.Nodes.Add(node);

            String sql = "SELECT FuncId, FuncName from admin_functions order by FuncId";
            DataTable funcs = DB.GetDataSet(sql).Tables[0];
            for (int i = 0; i < funcs.Rows.Count; i++)
            {
                TreeNode chilnode = new TreeNode(funcs.Rows[i]["FuncName"].ToString(), funcs.Rows[i]["FuncId"].ToString());
                tvRigths.Nodes[0].ChildNodes.Add(chilnode);
            }
        }
    }
    protected void btnOk_Click(object sender, EventArgs e)
    {
        saveData();
    }

    private void saveData()
    {
        SqlTransaction trans = null;
        try
        {
            trans = DB.GetConnection().BeginTransaction();

            ArrayList listParam = new ArrayList();
            String sql = "";
            if (txtAdminId.Value == "")
            {
                sql = "INSERT INTO admin_base(UserName,Password,Email,MobilePhone,isActive,adddate, lastip, lastdate) VALUES(@0,@1,@2,@3,@4,GETDATE(),'','')";
            }
            else
            {
                sql = "UPDATE admin_base SET UserName=@0, Password=@1, Email=@2, MobilePhone=@3, isActive=@4 WHERE adminid=@5";
            }

            int isActive = chkActive.Checked ? 1 : 0;

            listParam.Add(txtUserName.Text);
            listParam.Add(Common.Md5(txtPwd.Text));
            listParam.Add(txtEmail.Text);
            listParam.Add(txtMobilePhone.Text);
            listParam.Add(isActive);
            listParam.Add(txtAdminId.Value);

            DB.ExecuteSQL(sql, listParam);

            sql = "select AdminId from admin_base where UserName=@0";
            DB.GetDataSet(sql, txtUserName.Text);
            String adminid = DB.GetDataSet(sql).Tables[0].Rows[0]["AdminId"].ToString();

            for (int i = 0; i < tvRigths.Nodes[0].ChildNodes.Count; i++)
            {
                if (tvRigths.Nodes[0].ChildNodes[i].Checked)
                {
                    sql = "INSERT INTO admin_authority(FuncId, AdminId) VALUES(@0,@1)";
                    listParam.Clear();
                    listParam.Add(tvRigths.Nodes[0].ChildNodes[i].Value);
                    listParam.Add(adminid);

                    DB.ExecuteSQL(sql, listParam);
                }
            }

            Common.Alert("Ϣɹ!", this);
            clearData();

            trans.Commit();
        }
        catch (Exception ex)
        {
            if (trans != null)
                trans.Rollback();

            Response.Write(ex.Message);
            Response.End();
        }
    }

    private void clearData()
    {
        txtUserName.Text = "";
        txtPwd.Text = "";
        txtPwd2.Text = "";
        txtEmail.Text = "";
        txtMobilePhone.Text = "";
        chkActive.Checked = true;
    }
}
