﻿using System;
using System.Drawing;
using System.Drawing.Imaging;
using System.IO;
using System.Web;
using System.Web.UI.HtmlControls;

public class BaseSystem
{
    public void CreateImages(string checkCode)
    {
        int width = checkCode.Length * 13;
        Bitmap image = new Bitmap(width, 0x17);
        Graphics graphics = Graphics.FromImage(image);
        graphics.Clear(Color.BlanchedAlmond);
        Color[] colorArray = new Color[] { Color.Black, Color.Red, Color.DarkBlue, Color.Green, Color.Orange, Color.Brown, Color.DarkCyan, Color.Purple };
        string[] strArray = new string[] { "Verdana", "Microsoft Sans Serif", "Comic Sans MS", "Arial", "宋体" };
        Random random = new Random();
        for (int i = 0; i < 50; i++)
        {
            int x = random.Next(image.Width);
            int y = random.Next(image.Height);
            graphics.DrawRectangle(new Pen(Color.LightGray, 0f), x, y, 1, 1);
        }
        for (int j = 0; j < checkCode.Length; j++)
        {
            int index = random.Next(7);
            int num7 = random.Next(5);
            Font font = new Font(strArray[num7], 10f, FontStyle.Bold);
            Brush brush = new SolidBrush(colorArray[index]);
            int num8 = 4;
            if (((j + 1) % 2) == 0)
            {
                num8 = 2;
            }
            graphics.DrawString(checkCode.Substring(j, 1), font, brush, (float)(3 + (j * 12)), (float)num8);
        }
        graphics.DrawRectangle(new Pen(Color.White, 0f), 0, 0, image.Width - 1, image.Height - 1);
        MemoryStream stream = new MemoryStream();
        image.Save(stream, ImageFormat.Jpeg);
        HttpContext.Current.Response.ClearContent();
        HttpContext.Current.Response.ContentType = "image/Jpeg";
        HttpContext.Current.Response.BinaryWrite(stream.ToArray());
        graphics.Dispose();
        image.Dispose();
    }

    public string Decode(string str)
    {
        str = str.Replace("<br/>", "\n");
        str = str.Replace("<br>", "\n");
        str = str.Replace("&gt", ">");
        str = str.Replace("&lt", "<");
        str = str.Replace("&nbsp;", " ");
        str = str.Replace("&quot;", "\"");
        str = str.Replace("''", "'");
        str = str.Replace("&amp", "&");
        return str;
    }

    public bool DelImg(string strFilename)
    {
        FileInfo info = new FileInfo(strFilename);
        if (info.Exists)
        {
            try
            {
                info.Delete();
                return true;
            }
            catch
            {
                return false;
            }
        }
        return false;
    }

    public static void DrawImage()
    {
        BaseSystem system = new BaseSystem();
        HttpContext.Current.Session["CheckCode"] = system.RndNum(4);
        system.CreateImages(HttpContext.Current.Session["CheckCode"].ToString());
    }

    public string Encode(string str)
    {
        str = str.Replace("&", "&amp");
        str = str.Replace("'", "''");
        str = str.Replace("\"", "&quot;");
        str = str.Replace(" ", "&nbsp;");
        str = str.Replace("<", "&lt;");
        str = str.Replace(">", "&gt;");
        str = str.Replace("\n", "<br/>");
        str = str.Replace("\n", "<br>");
        return str;
    }

    public string ReNameUpLoadPic(string PicName)
    {
        PicName = DateTime.Now.ToString();
        PicName = PicName.Replace("-", "").Trim();
        PicName = PicName.Replace(":", "").Trim();
        string str = PicName.Substring(0, 7);
        string str2 = PicName.Substring(PicName.Length - 6, 6);
        Random random = new Random();
        string str3 = random.Next(0x3e8).ToString();
        PicName = str + str2 + str3;
        PicName = PicName.Replace(" ", "").Trim();
        return PicName;
    }

    public string RndNum(int VcodeNum)
    {
        string[] strArray = "0,1,2,3,4,5,6,7,8,9".Split(new char[] { ',' });
        string str2 = "";
        int num = -1;
        Random random = new Random();
        for (int i = 1; i < (VcodeNum + 1); i++)
        {
            if (num != -1)
            {
                random = new Random((i * num) * ((int)DateTime.Now.Ticks));
            }
            int index = random.Next(strArray.Length);
            if ((num != -1) && (num == index))
            {
                return this.RndNum(VcodeNum);
            }
            num = index;
            str2 = str2 + strArray[index];
        }
        return str2;
    }

    public string ShowWindow(string Msg)
    {
        string str = "";
        str = "<script language=\"javascript\">";
        return ((str + "alert(\"" + Msg + "\");") + "window.history.go(-1);" + "</script>");
    }

    public string ShowWindow(string Msg, string Url)
    {
        string str = "";
        str = "<script language=\"javascript\">";
        return (((str + "alert(\"" + Msg + "\");") + "window.location=\"" + Url + "\";") + "</script>");
    }

    public string UpLoadPicture(HtmlInputFile UpFileObject, string ImgUrl)
    {
        string str6;
        string str2 = "images/none.jpg";
        bool flag = true;
        bool flag2 = true;
        string fileName = UpFileObject.PostedFile.FileName;
        string picName = Path.GetFileName(fileName).ToLower();
        string extension = Path.GetExtension(fileName);
        string str = this.ReNameUpLoadPic(picName);
        if (((str6 = extension) == null) || (((str6 != ".gif") && (str6 != ".jpeg")) && (str6 != ".jpg")))
        {
            flag2 = false;
        }
        if (!flag2)
        {
            flag = false;
        }
        else
        {
            try
            {
                UpFileObject.PostedFile.SaveAs(HttpContext.Current.Server.MapPath(ImgUrl + str + extension));
            }
            catch
            {
                flag = false;
            }
        }
        if (flag)
        {
            str2 = ImgUrl + str + extension;
        }
        return str2;
    }
}

