using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text.RegularExpressions;
using System.IO;

/// <summary>
/// Summary description for Common
/// </summary>
public class Common
{
    public static String[] UserType={"ְ","ҵ","Ӧ","У"};
    public static String[] sex={"Ů","",""};
    public static String[] jobType ={ "ȫְ", "ְ", "" };
	public Common()
	{
		
	}

    public static Int32 getPageCnt(Int32 count,Int32 pageSize)
    {
        Int32 pageCount =  count / pageSize;

        if (count % pageSize != 0)
	    {
            ++pageCount;
	    }
        return pageCount;
    }

    public static void Alert(string sMessage, Page page)
    {
        page.ClientScript.RegisterStartupScript(page.GetType(), "", "<script>alert('" + sMessage + "')</script>");
    }

    public static void ChangeImage(string sIndex,string sJustCounter, Page page)
    {
        page.ClientScript.RegisterStartupScript(page.GetType(), "", "<script>ChangeImage(" + sIndex + "," + sJustCounter + ")</script>");
    }

    public static string GetParam(string sParamList,string sParam)
    {
        int iLength = sParam.Length ;
        string strReturn = "";
        string[] aryParam = sParamList.Split(';');
        
        for(int i=0;i<aryParam.Length;i++)
        {
            string sTmpParam = aryParam[i].ToString();
            string[] aryTmpParam = sTmpParam.Split('=');
            if (aryTmpParam[0] == sParam)
            {
                strReturn = aryTmpParam[1];
                break;
            }
        }

        return strReturn;
    }

    public static string SetParam(string sParamList, string sParam,string sValue)
    {
        string[] aryParam = sParamList.Split(';');
        int iLength = sParam.Length;
        string sReturn = "";

        for (int i = 0; i < aryParam.Length; i++)
        {
            string sTmpParam = aryParam[i];
            string[] aryTmpParam = sTmpParam.Split('=');
            if (sTmpParam == "")
            {
                continue;
            }
            if (aryTmpParam[0] == sParam)
            {
                sReturn += aryTmpParam[0] + "=" + sValue + ";";
            }
            else
            {
                sReturn += sTmpParam + ";";
            }

        }
        return sReturn;
    }


    public static string FormatDate(string sDate)
    {
        try
        {
            DateTime dateTmp = Convert.ToDateTime(sDate);
            return string.Format("{0}-{1}-{2}", dateTmp.Year, dateTmp.Month, dateTmp.Day);
        }
        catch 
        {
            return "";
        }
    }


    public static void BindDialog(System.Web.UI.WebControls.Button btnShow, string Url, int iWidth, int iHeight)
    {
        string strResValue = "";
        strResValue += "window.showModalDialog('" + Url + "?rand=" + new Random().Next().ToString() + "','','";
        strResValue += "dialogHeight: " + iHeight.ToString();
        strResValue += "px; dialogWidth: " + iWidth.ToString();
        strResValue += "px;edge: Sunken;center: Yes; help: No; resizable: No; status: No;');";
        btnShow.Attributes.Add("onclick", strResValue);

    }

    public static void Confirm(string str_Message, string btn, Page page)
    {
        page.ClientScript.RegisterStartupScript(page.GetType(), "", "<script> if (confirm('" + str_Message + "')==true){document.forms(0)." + btn + ".click();}</script>");
    }


    #region <ToYMD>
    /// <summary>
    /// return a string by 'YYYY-MM-DD'
    /// </summary>
    /// <param name="sDate"></param>
    /// <returns></returns>
    public static string ToYMD(string sDate)
    {
        try
        {
            if (sDate.Trim().Length <= 0)
                return sDate;
            DateTime datTmp = Convert.ToDateTime(sDate);
            string strDate = string.Format("{0}-{1}-{2}", datTmp.Year, datTmp.Month, datTmp.Day);
            return strDate;
        }
        catch 
        {
            return sDate;
        }
    }

    public static string ToYMD(string year,string month,string day)
    {
        String retDate = "";
        try
        {
            DateTime datTmp = Convert.ToDateTime(year+"-"+month+"-"+day);
            retDate = string.Format("{0}-{1}-{2}", datTmp.Year, datTmp.Month, datTmp.Day);
        }
        catch
        {
        }
        return retDate;
        
    }

    public static string ToYMD(DateTime dt)
    {
        return string.Format("{0:u}", dt).Substring(0,10);
    }

    public static string DayToWeek(DayOfWeek dw)
    {
        switch(dw) {
            case DayOfWeek.Sunday :
                return "";
            case DayOfWeek.Monday :
                return "һ";
            case DayOfWeek.Thursday :
                return "";
            case DayOfWeek.Wednesday :
                return "";
            case DayOfWeek.Tuesday :
                return "";
            case DayOfWeek.Friday :
                return "";
            case DayOfWeek.Saturday :
                return "";
        }

        return "";
    }

    public static string DateToString(DateTime dt)
    {
        String retDate = "";
        try
        {
            retDate = string.Format("{0}{1}{2} {3}", dt.Year, dt.Month, dt.Day, DayToWeek(dt.DayOfWeek));
        }
        catch
        {
        }
        return retDate;
    }
    #endregion

    public static bool IsNumeric(string sNumber)
    {
        Regex re = new Regex("^[0-9]+([.]{0}|[.]{1}[0-9]+)$");
        if (!re.IsMatch(sNumber, 0))
        {
            return false;
        }
        else
        {
            return true;
        }
    }

    public static bool IsDate(string sDate)
    { 
        DateTime datTemp = new DateTime();
        bool bolRet = true;
        bolRet = DateTime.TryParse(sDate, out datTemp);

        return bolRet;
    }

    public static String ReadFile(String fileName)
    {
        String buf = string.Empty;
        StreamReader file = new StreamReader(fileName, System.Text.Encoding.GetEncoding("gb2312"));
        buf = file.ReadToEnd();
        file.Close();
        return buf;
    }

    public static String Md5(String field)
    {
        return System.Web.Security.FormsAuthentication.HashPasswordForStoringInConfigFile(field, "MD5");
    }


    public static string uploadFile(HttpPostedFile file, string type, string filename)
    {
        string fileServerUrl = ConfigurationManager.AppSettings["FileServer"].ToString();
        if (fileServerUrl.Equals("")) fileServerUrl = "http://192.168.112.25/Upload/";

        string postUrl = fileServerUrl + "uploadpic.aspx?type=" + type + "&filename=" + filename;
        byte[] fileByte = new byte[file.InputStream.Length];
        file.InputStream.Read(fileByte, 0, fileByte.Length);
        System.Net.WebClient webClient = new System.Net.WebClient();
        byte[] responseArray = webClient.UploadData(postUrl, "POST", fileByte);

        //صֽתַҲuploadpic.aspxҳݣ
        string result = System.Text.Encoding.Default.GetString(responseArray, 0, responseArray.Length);

        //ؽĴ
        switch (result)
        {
            case "-1":
                return "";
            case "0":
                return "";
        }

        return (fileServerUrl + type + "/photo/" + filename);
    }

    public static string downloadFile(string url, string path, string id, string localPath)
    {
        if (url == null || url.Equals("")) return "";
        if (!url.ToLower().Contains("http")) return "";

        try
        {
            string fileExt = System.IO.Path.GetExtension(url).ToLower();
            if (!Directory.Exists(path))
            {
                Directory.CreateDirectory(path);
            }

            if (id == null || id == "") 
                id = DateTime.Now.ToString("yyyyMMddhhmmss") + getRandomString(4);

            string filename = id + fileExt;
            path += filename;
            System.Net.WebClient webClient = new System.Net.WebClient();

            webClient.DownloadFile(url, path);

            return localPath + filename;
        }
        catch (Exception ex)
        {
            System.Console.WriteLine(ex.Message);
        }

        return "";
    }

    private static char[] constant = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z' };

    public static string getRandomString(int length)
    {
        if (length > 62) length = 62;
        else if (length < 0) length = 1;

        System.Text.StringBuilder newRandom = new System.Text.StringBuilder(62);
        Random rd = new Random();
        for (int i = 0; i < length; i++)
        {
            newRandom.Append(constant[rd.Next(62)]);
        }
        return newRandom.ToString();
    }

}
