using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Collections;
using System.Data.SqlClient;
using System.Web.UI;
using System.Text.RegularExpressions;
//51aspx.com
/// <summary>
/// Summary description for DB
/// </summary>
public class DB
{
    static string strConnect = ConfigurationManager.AppSettings["server"].ToString();

    /// <summary>
    /// construction function
    /// </summary>
    /// <param name="sConnect"></param>
    public DB(string sConnect)
    {
        strConnect = sConnect;
    }

    /// <summary>
    /// return a oledbconnection object
    /// </summary>
    public static SqlConnection GetConnection()
    {
        SqlConnection myConnection = null;
        try
        {
            if (myConnection == null)
                myConnection = new SqlConnection(strConnect);
            if (myConnection.State != ConnectionState.Open)
                myConnection.Open();
        }
        catch (Exception ex)
        {
            throw ex;
        }
        return myConnection;
    }

    /// <summary>
    /// return a datatable object by SQL command
    /// </summary>
    /// <param name="sSQL"></param>
    /// <returns></returns>
    public static System.Data.DataSet GetDataSet(string sSQL)
    {
        SqlConnection Conn = null;
        DataSet datObject = new DataSet();

        try
        {
            Conn = GetConnection(); ;
            SqlCommand cmdObject = new SqlCommand(sSQL, Conn);
            SqlDataAdapter adpObject = new SqlDataAdapter(cmdObject);
            adpObject.Fill(datObject);
        }
        catch (Exception ex)
        {
            throw ex;
        }
        finally
        {
            if (Conn != null)
            {
                Conn.Close();
                Conn.Dispose();
            }
        }

        return datObject;
    }

    /// <summary>
    /// execute a SQL command
    /// </summary>
    /// <param name="sSQL"></param>
    /// <returns></returns>
    public static int ExecuteSQL(string sSQL)
    {

        int iCount = 0;

        SqlConnection Conn = null;
        SqlTransaction traObject = null;
        try
        {
            Conn = GetConnection();
            traObject = Conn.BeginTransaction();

            SqlCommand cmdObject = new SqlCommand(sSQL, Conn, traObject);
            iCount = cmdObject.ExecuteNonQuery();
            traObject.Commit();
        }
        catch (Exception ex)
        {
            if (traObject != null)
                traObject.Rollback();

            throw ex;
        }
        finally
        {
            if (Conn != null)
            {
                Conn.Close();
                Conn.Dispose();
            }
        }

        return iCount;
    }

    
    public static int ExecuteSQL(string sSQL, object param)
    {
        ArrayList paramList = new ArrayList();
        paramList.Add(param);
        return ExecuteSQL(sSQL, paramList);
    }

    public static int ExecuteSQL(string sSQL, params object[] param)
    {
        ArrayList paramList = new ArrayList();
        for (int i = 0; i < param.Length; i++)
        {
            paramList.Add(param[i]);
        }
        return ExecuteSQL(sSQL, paramList);
    }


    public static int ExecuteSQL(string sSQL, ArrayList paramList)
    {
        if ( !CheckParams(paramList.ToArray())) return 0;

        int iCount = 0;

        SqlConnection Conn = null; ;
        SqlTransaction traObject = null;
        try
        {
            Conn = GetConnection();
            traObject = Conn.BeginTransaction();

            SqlCommand cmdObject = new SqlCommand(sSQL, Conn, traObject);
            SqlParameter[] parameters = new SqlParameter[paramList.Count];
            for (int i = 0; i < paramList.Count; ++i)
            {
                parameters[i] = new SqlParameter();
                parameters[i].ParameterName = "@" + i.ToString();
                parameters[i].Value = paramList[i];
                cmdObject.Parameters.Add(parameters[i]);
            }

            iCount = cmdObject.ExecuteNonQuery();
            traObject.Commit();
        }
        catch (Exception ex)
        {
            if (traObject != null)
                traObject.Rollback();

            throw ex;
        }
        finally
        {
            if (Conn != null)
            {
                Conn.Close();
                Conn.Dispose();
            }
        }

        return iCount;
    }


    public static DataSet GetDataSet(SqlConnection connection, string commandText, params SqlParameter[] commandParameters)
    {
        SqlCommand cmd = new SqlCommand();
        cmd.Connection = connection;
        cmd.CommandText = commandText;
        cmd.CommandType = CommandType.Text;

        if (commandParameters != null)
            foreach (SqlParameter p in commandParameters)
                cmd.Parameters.Add(p);

        SqlDataAdapter da = new SqlDataAdapter(cmd);
        DataSet ds = new DataSet();

        da.Fill(ds);
        cmd.Parameters.Clear();

        return ds;
    }

    //public static DataSet GetDataSet(SqlConnection connection, string commandText, SqlTransaction trans, params object[] commandParameters)
    //{
    //    SqlParameter[] parameters = new SqlParameter[commandParameters.Length];
    //    for (int i = 0; i < commandParameters.Length; ++i)
    //    {
    //        parameters[i] = new SqlParameter();
    //        parameters[i].ParameterName = "@" + i.ToString();
    //        parameters[i].Value = commandParameters[i];
    //    }
    //    return GetDataSet(connection, commandText, trans, parameters);
    //}

    public static DataSet GetDataSet(SqlConnection connection, string commandText, SqlTransaction trans, params SqlParameter[] commandParameters)
    {
        SqlCommand cmd = new SqlCommand();
        cmd.Connection = connection;
        cmd.Transaction = trans;
        cmd.CommandText = commandText;
        cmd.CommandType = CommandType.Text;

        if (commandParameters != null)
            foreach (SqlParameter p in commandParameters)
                cmd.Parameters.Add(p);

        SqlDataAdapter da = new SqlDataAdapter(cmd);
        DataSet ds = new DataSet();

        da.Fill(ds);
        cmd.Parameters.Clear();

        return ds;
    }

    public static DataSet GetDataSet(string commandText, ArrayList paramList)
    {
        object[] commandParameters = new object[paramList.Count];
        for (int i = 0; i < paramList.Count; ++i)
        {
            commandParameters[i] = paramList[i];
        }

        return GetDataSet(commandText, commandParameters);
    }

    public static DataSet GetDataSet(string commandText, object commandParameters)
    {
        object[] parameters = new object[1];
        parameters[0] = commandParameters;

        return GetDataSet(commandText, parameters);
    }

    public static DataSet GetDataSet(string commandText, params object[] commandParameters)
    {
        SqlConnection Conn = null;
        try
        {
            if ( !CheckParams(commandParameters)) return null;

            Conn = GetConnection();
            SqlCommand cmd = new SqlCommand();
            cmd.Connection = Conn;
            cmd.CommandText = commandText;
            cmd.CommandType = CommandType.Text;

            if (commandParameters != null)
            {
                SqlParameter[] param = new SqlParameter[commandParameters.Length];

                for (int i = 0; i < commandParameters.Length; ++i)
                {
                    if (commandParameters[i] == null)
                        continue;
                    param[i] = new SqlParameter();
                    param[i].ParameterName = "@" + i.ToString();
                    param[i].Value = commandParameters[i];
                    cmd.Parameters.Add(param[i]);
                }

            }
            SqlDataAdapter da = new SqlDataAdapter(cmd);
            DataSet ds = new DataSet();

            da.Fill( ds );
            cmd.Parameters.Clear();

            return ds;
        }
        catch (Exception ex)
        {
            throw ex;
        }
        finally
        {
            if (Conn != null)
            {
                Conn.Close();
                Conn.Dispose();
            }
        }
    }

    public static SqlParameter[] Params2SqlParameter( object Params)
    {
        SqlParameter[] SqlParams = new SqlParameter[1];
        if (Params != null)
        {
            SqlParams[0] = new SqlParameter();
            SqlParams[0].ParameterName = "@0";
            SqlParams[0].Value = Params;
        }
        return SqlParams;
    }

    public static SqlParameter[] Params2SqlParameter(params object[] Params)
    {
        SqlParameter[] SqlParams = new SqlParameter[Params.Length];
        if (Params != null)
        {
            for (int i = 0; i < Params.Length; ++i)
            {
                if (Params[i] == null)
                    continue;
                SqlParams[i] = new SqlParameter();
                SqlParams[i].ParameterName = "@" + i.ToString();
                SqlParams[i].Value = Params[i];
            }

        }
        return SqlParams;
    }

    public static SqlParameter[] Params2SqlParameter( ArrayList Params)
    {
        SqlParameter[] SqlParams = new SqlParameter[Params.Count];
        if (Params != null)
        {
            for (int i = 0; i < Params.Count; ++i)
            {
                if (Params[i] == null)
                    continue;
                SqlParams[i] = new SqlParameter();
                SqlParams[i].ParameterName = "@" + i.ToString();
                SqlParams[i].Value = Params[i];
                
            }

        }
        return SqlParams;
    }



    /*Ӵ洢ȡݣҳ
     * 
     * ˵commandText   ҪִеSQL
     *           CurrentPage   ǰҳ
     *           RowsPerPage   ÿҳ
     *           commandParameters   SQL
     * */
    public static DataSet GetDataSetFromProc(string commandText,int CurrentPage,int RowsPerPage, params object[] commandParameters)
    {
        SqlConnection Conn = null;
        try
        {
            if ( !CheckParams(commandParameters)) return null;

            Conn = GetConnection();
            SqlCommand cmd = new SqlCommand(commandText,Conn);
            cmd.CommandType = CommandType.StoredProcedure;


            SqlParameter[] param = new SqlParameter[commandParameters.Length + 2];
            param[0] = new SqlParameter();
            param[0].ParameterName = "@CurrentPage";
            param[0].Value = CurrentPage;
            cmd.Parameters.Add(param[0]);

            param[1] = new SqlParameter();
            param[1].ParameterName = "@PageSize";
            param[1].Value = RowsPerPage;
            cmd.Parameters.Add(param[1]);


            if (commandParameters != null)
            {
                for (int i = 0; i < commandParameters.Length; ++i)
                {
                    if (commandParameters[i] == null)
                        continue;
                    param[i] = new SqlParameter();
                    param[i].ParameterName = "@" + i.ToString();
                    param[i].Value = commandParameters[i];
                    cmd.Parameters.Add(param[i]);
                }

            }
            SqlDataAdapter da = new SqlDataAdapter(cmd);
            DataSet ds = new DataSet();

            da.Fill(ds);
            cmd.Parameters.Clear();

            return ds;
        }
        catch (Exception ex)
        {
            throw ex;
        }
        finally
        {
            if (Conn != null)
            {
                Conn.Close();
                Conn.Dispose();
            }
        }
    }



    public static int ExecuteSQL(SqlCommand cmd, params SqlParameter[] commandParameters)
    {
        if (commandParameters != null)
            foreach (SqlParameter p in commandParameters)
                cmd.Parameters.Add(p);

        int result = cmd.ExecuteNonQuery();
        cmd.Parameters.Clear();

        return result;
    }

    public static bool HasSameRecord(Page p, string sTable, string sId, string sValue, string sAlertName)
    {
        bool bolRet = false;
        SqlConnection Conn = null;

        try
        {
            Conn = DB.GetConnection();

            string strSQL = string.Format("SELECT * FROM {0} WHERE UPPER({1})=UPPER(@0) AND status<>1", sTable, sId);
            SqlParameter[] parameters = new SqlParameter[1];
            parameters[0] = new SqlParameter();
            parameters[0].ParameterName = "@0";
            parameters[0].Value = sValue;

            if (DB.GetDataSet(Conn, strSQL, parameters).Tables[0].Rows.Count > 0)
            {
                p.Response.Write(string.Format("<script>alert('Same {0} already exists!');</script>", sAlertName));
                bolRet = true;
            }

            return bolRet;
        }
        catch (Exception ex)
        {
            throw ex;
        }
        finally
        {
            if (Conn != null)
            {
                Conn.Close();
                Conn.Dispose();
            }
        }
    }

    public static int HasSameRecord(string sTable, string sId, string sValue)
    {
        int intRet = 0;
        SqlConnection Conn = null;

        try
        {
            Conn = DB.GetConnection();

            string strSQL = string.Format("SELECT * FROM {0} WHERE UPPER({1})=UPPER(@0) AND status<>1", sTable, sId);
            SqlParameter[] parameters = new SqlParameter[1];
            parameters[0] = new SqlParameter();
            parameters[0].ParameterName = "@0";
            parameters[0].Value = sValue;

            intRet = DB.GetDataSet(Conn, strSQL, parameters).Tables[0].Rows.Count;

            return intRet;
        }
        catch (Exception ex)
        {
            throw ex;
        }
        finally
        {
            if (Conn != null)
            {
                Conn.Close();
                Conn.Dispose();
            }
        }
    }

    public static void setLastUpdateTime(String perid)
    {
        try
        {
            String sql = "UPDATE personal_base SET lastupdate_date = GETDATE() WHERE perid=@0";
            ExecuteSQL(sql, perid);
        }
        catch (Exception ex)
        {
            throw ex;
        }
    }

    public static bool CheckParams(params object[] args)
    {
        //string[] Lawlesses ={ "=", "'" };
        //if (Lawlesses == null || Lawlesses.Length <= 0) return true;

        ////ʽ,:Lawlesses=ź',ʽΪ .*[=}'].*  (ʽMSDN)
        ////,ͨö޸ĵĺ,Զһַ鵽ʽ,ʵʹ,ֱдʽ;
        //string str_Regex = ".*[";
        //for (int i = 0; i < Lawlesses.Length - 1; i++)
        //    str_Regex += Lawlesses[i] + "|";
        //str_Regex += Lawlesses[Lawlesses.Length - 1] + "].*";

        //foreach (object arg in args)
        //{
        //    if (arg is string)//ַ,ֱӼ
        //    {
        //        if (Regex.Matches(arg.ToString(), str_Regex).Count > 0)
        //            return false;
                    
        //    }
        //    else if (arg is ICollection)//һ,鼯ԪǷַ,ַ,ͽм
        //    {
        //        foreach (object obj in (ICollection)arg)
        //        {
        //            if (obj is string)
        //            {
        //                if (Regex.Matches(obj.ToString(), str_Regex).Count > 0)
        //                    return false;
                            
        //            }
        //        }
        //    }
        //}
        return true;
    }
}
