using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.OleDb;
using System.IO;
using System.Collections;
/// 
/// Excel
/// 
public class ExcelObj
{
    public ExcelObj()
    {

    }

    /// <summary> 
    /// ͨú,ıļ 
    /// </summary> 
    /// <param name="fileName">ıļ</param> 
    public static ArrayList ReadTextFromFileName(string fileName)
    {
        string strRecord = "";
        ArrayList arr = new ArrayList();

        //ıļʱ,һҪָļıʽ.:defaultΪıļıʽ 
        //Ǽĵıļ,Ҳñʽ: System.Text.Encoding.GetEncode("gb2312") 
        //Encoding.GetEncode("gb2312")Ϊıʽ,Encoding.GetEncode("big5")Ϊıʽ. 
        StreamReader reader = new StreamReader(fileName, System.Text.Encoding.Default);

        //i is the really row 
        //j is the row of writed to database 
        int i, j;
        i = 0;
        j = 0;
        try
        {
            while (reader.Peek() >= 0)
            {
                strRecord = reader.ReadLine();
                arr.Add(strRecord);

                j++;

                i++;
            }
        }
        catch (Exception ex)
        {
            throw new Exception(ex.Message);
        }
        //Դ 
        finally
        {
            reader.Close();
        }

        return arr;
    }


    //private static void    
    /// <summary> 
    /// ȹ̶ı,ȡÿֶεֵ 
    /// </summary> 
    /// <param name="aStr">ıļÿıתByte</param> 
    /// <param name="iStart">ȡʼλ</param> 
    /// <param name="iLength">ȡĳ</param> 
    /// <returns>صַ,Ӧھֵֶ</returns> 
    private static string GetString(byte[] aStr, int iStart, int iLength)
    {

        byte[] tempStr = new byte[iLength];
        for (int i = 0; i < iLength; i++)
        {
            tempStr[i] = (byte)aStr.GetValue(iStart + i);
        }

        return System.Text.Encoding.Default.GetString(tempStr);
    }


    #region 沢Excelе
    /// 
    /// 沢Excelе
    /// 
    /// ·
    /// ϴؼ
    /// 
    public static ArrayList SaveAndReturn(string SavePath, FileUpload myFileUpload)
    {
        string fileName = myFileUpload.FileName;
        if (fileName != "")
        {
            int index = fileName.IndexOf(".");
            if (index > 0)
            {
                try
                {
                    myFileUpload.SaveAs(SavePath + "\\" + fileName);
                }
                catch (Exception ee)
                {
                    System.Console.Write(ee.Message);
                    return null;
                }

                String subfix = fileName.Substring(index + 1);
                if (string.Compare(subfix, "txt", true) == 0)
                {
                    return ReadTextFromFileName(SavePath + "\\" + fileName);
                }
                else if (string.Compare(subfix, "xls", true) == 0)
                {
                    string mystring = "Provider = Microsoft.Jet.OLEDB.4.0 ; Data Source = '" + SavePath + "//" + fileName + "';Extended Properties=Excel 8.0";

                    OleDbConnection cnnxls = new OleDbConnection(mystring);
                    OleDbDataAdapter myDa = new OleDbDataAdapter("select * from [Sheet1$]", cnnxls);
                    DataSet myDs = new DataSet();
                    myDa.Fill(myDs);
                    ArrayList arr = new ArrayList();

                    for (int i = 0; i < myDs.Tables[0].Rows.Count; i++)
                    {
                        DataRow dr = myDs.Tables[0].Rows[i];
                        arr.Add(dr[0].ToString());
                    }

                    return arr;
                }
                else
                {
                    return null;
                }
            }
        }

        return null;

    }

    public static ArrayList getValues(string SavePath, String fileName)
    {
        if (fileName != "")
        {
            int index = fileName.IndexOf(".");
            if (index > 0)
            {
                String subfix = fileName.Substring(index + 1);
                if (string.Compare(subfix, "txt", true) == 0)
                {
                    return ReadTextFromFileName(SavePath + "\\" + fileName);
                }
                else if (string.Compare(subfix, "xls", true) == 0)
                {
                    string mystring = "Provider = Microsoft.Jet.OLEDB.4.0 ; Data Source = '" + SavePath + "//" + fileName + "';Extended Properties=Excel 8.0";

                    OleDbConnection cnnxls = new OleDbConnection(mystring);
                    OleDbDataAdapter myDa = new OleDbDataAdapter("select * from [Sheet1$]", cnnxls);
                    DataSet myDs = new DataSet();
                    myDa.Fill(myDs);
                    ArrayList arr = new ArrayList();

                    for (int i = 0; i < myDs.Tables[0].Rows.Count; i++)
                    {
                        DataRow dr = myDs.Tables[0].Rows[i];
                        arr.Add(dr[0].ToString());
                    }

                    return arr;
                }
                else
                {
                    return null;
                }
            }
        }

        return null;

    }

    public static String SaveFile(string SavePath, FileUpload myFileUpload)
    {
        string fileName = myFileUpload.FileName;
        if (fileName != "")
        {
            int index = fileName.IndexOf(".");
            if (index > 0)
            {
                String subfix = fileName.Substring(index + 1);
                if (string.Compare(subfix, "txt", true) != 0 && string.Compare(subfix, "xls", true) != 0)
                {
                    return "";
                }
                try
                {
                    myFileUpload.SaveAs(SavePath + "\\" + fileName);
                    return fileName;
                }
                catch (Exception ee)
                {
                    System.Console.Write(ee.Message);
                    return "";
                }
            }
        }

        return "";

    }
    #endregion

    public static void ExportExcel(HttpResponse resp, DataSet ds, string FileName)
    {
        if (resp == null || ds == null) return;

        resp.ClearContent();
        resp.ClearHeaders();
        resp.ContentEncoding = System.Text.Encoding.GetEncoding("GB2312");
        resp.AppendHeader("Content-Disposition", "attachment;filename=" + FileName);
        resp.ContentType = "application/ms-excel";
        string colHeaders = "", ls_item = "";

        //жͬʱDataSetֵгʼ 
        DataTable dt = ds.Tables[0];
        DataRow[] myRow = dt.Select();//dt.Select("id>10")֮ʽﵽɸѡĿ
        int i = 0;
        int cl = dt.Columns.Count;

        //ȡݱб⣬֮\tָһбӻس 
        for (i = 0; i < cl; i++)
        {
            if (i == (cl - 1))//һУ\n
            {
                colHeaders += dt.Columns[i].Caption.ToString() + "\n";
            }
            else
            {
                colHeaders += dt.Columns[i].Caption.ToString() + "\t";
            }

        }
        resp.Write(colHeaders);
        //HTTPдȡõϢ 

        //д   
        foreach (DataRow row in myRow)
        {
            //ǰдHTTPÿls_itemԱ     
            for (i = 0; i < cl; i++)
            {
                if (i == (cl - 1))//һУ\n
                {
                    ls_item += row[i].ToString() + "\n";
                }
                else
                {
                    ls_item += row[i].ToString() + "\t";
                }

            }
            resp.Write(ls_item);
            ls_item = "";

        }
        resp.End();
    }

    public static void DataTable2Excel(HttpResponse resp, System.Data.DataTable dtData, string FileName)
    {
        System.Web.UI.WebControls.DataGrid dgExport = null;

        // IOڵexcelļ
        System.IO.StringWriter strWriter = null;
        System.Web.UI.HtmlTextWriter htmlWriter = null;

        if (dtData != null)
        {
            resp.ClearContent();
            resp.ClearHeaders();
            // ñ͸ʽ
            resp.AppendHeader("Content-Disposition", "attachment;filename=" + FileName);
            resp.ContentType = "application/vnd.ms-excel";
            resp.ContentEncoding = System.Text.Encoding.GetEncoding("GB2312");
            resp.Charset = "";

            // excelļ
            strWriter = new System.IO.StringWriter();
            htmlWriter = new System.Web.UI.HtmlTextWriter(strWriter);

            // Ϊ˽dgDataпܽ˷ҳҪ¶һ޷ҳDataGrid
            dgExport = new System.Web.UI.WebControls.DataGrid();
            dgExport.DataSource = dtData.DefaultView;
            dgExport.AllowPaging = false;
            dgExport.DataBind();

            // ؿͻ
            dgExport.RenderControl(htmlWriter);
            resp.Write(strWriter.ToString());
            resp.End();
        }
    }
}
