using System;
using System.Data;
using System.Collections;

/// <summary>
/// Summary description for GenerateSQL
/// </summary>
public class GenerateSQL
{
    /// <summary>
    /// ݱ,ֵֶInsert SQL
    /// </summary>
    /// <param name="tableName"></param>
    /// <param name="fieldName"></param>
    /// <param name="fieldValue"></param>
    /// <returns></returns>
    public string GenerateInsertSQL(string tableName, ArrayList fieldName, ArrayList fieldValue)
    {

        try
        {
            //صSQL
            string ret = string.Empty;
            string field = string.Empty;
            string content = string.Empty;

            //Ϊ,ֶκֵֶһһӦ
            if ((tableName.Trim() != "") && (fieldName.Count == fieldValue.Count))
            {

                if (fieldName.Count != 0)
                {
                    for (int i = 0; i < fieldName.Count; i++)
                    {
                        //ֶһ
                        string strField = fieldName[i].ToString().Trim();
                        //ѶӦֵһһ
                        string strValue = this.TypeOfData(fieldValue[i]);

                        //һֶ,","
                        if (i != fieldName.Count - 1)
                        {
                            strField += ",";
                            strValue += ",";
                        }

                        field += strField;
                        content += strValue;
                    }
                }

                //SQL 
                ret = string.Format("Insert into {0} ({1}) values ({2})", tableName, field, content);
            }

            return ret;

        }
        catch (Exception ex)
        {
            throw ex;
        }
    }//end function



    /// <summary>
    /// ݱ,ֵֶUpdate SQL,,һ
    /// </summary>
    /// <param name="tableName"></param>
    /// <param name="fieldName"></param>
    /// <param name="fieldValue"></param>
    /// <returns></returns>
    public string GenerateUpdateSQL(string tableName, ArrayList fieldName, ArrayList fieldValue, ArrayList updateID, ArrayList updateContent)
    {
        try
        {
            //صSQL
            string ret = string.Empty;
            //µ
            string content = string.Empty;

            //ҪµID
            string id_content = string.Empty;

            //ֵֶһһӦ
            string str1 = string.Empty;
            //µȥ
            string str2 = string.Empty;

            //Ϊ,ֶκֵֶһһӦ
            if ((tableName.Trim() != "") && (fieldName.Count == fieldValue.Count))
            {

                if (fieldName.Count > 0)
                {
                    for (int i = 0; i < fieldName.Count; i++)
                    {
                        //ֶһ
                        string strField = fieldName[i].ToString().Trim();
                        //ѶӦֵһһ
                        string strValue = this.TypeOfData(fieldValue[i]);

                        //һֶ,","
                        if (i != fieldName.Count - 1)
                        {
                            str1 = string.Format("{0} = {1}", strField, strValue) + ",";
                        }
                        else
                        {
                            str1 = string.Format("{0} = {1}", strField, strValue);
                        }

                        content += str1;
                    }
                }

                //ɸµ,ȻҪUpdate
                ret = string.Format("Update {0} set {1} ", tableName, content);

                //ϸµ
                if (updateID.Count == updateContent.Count)
                {
                    if (updateID.Count > 0)
                    {
                        for (int i = 0; i < updateID.Count; i++)
                        {
                            //ֶһ
                            string strField = updateID[i].ToString().Trim();
                            //ѶӦֵһһ
                            string strValue = this.TypeOfData(updateContent[i]);

                            str2 = string.Format(" and {0} = {1}", strField, strValue);

                            id_content += str2;
                        }
                    }
                }

                //SQL 
                ret = string.Format("{0}where 1 = 1{1}", ret, id_content);


            }

            return ret;
        }
        catch (Exception ex)
        {
            throw ex;
        }

    }//end function


    /// <summary>
    /// ݱ,ֵֶUpdate SQL,,¶
    /// </summary>
    /// <param name="tableName"></param>
    /// <param name="fieldName"></param>
    /// <param name="fieldValue"></param>
    /// <returns></returns>
    public string GenerateMultiUpdateSQL(string tableName, ArrayList fieldName, ArrayList fieldValue, ArrayList updateID, ArrayList updateContent)
    {
        try
        {
            //صSQL
            string ret = string.Empty;
            //µ
            string content = string.Empty;

            //ҪµID
            string id_content = string.Empty;

            //ֵֶһһӦ
            string str1 = string.Empty;
            //µȥ
            string str2 = string.Empty;

            //Ϊ,ֶκֵֶһһӦ
            if ((tableName.Trim() != "") && (fieldName.Count == fieldValue.Count))
            {

                if (fieldName.Count > 0)
                {
                    for (int i = 0; i < fieldName.Count; i++)
                    {
                        //ֶһ
                        string strField = fieldName[i].ToString().Trim();
                        //ѶӦֵһһ
                        string strValue = this.TypeOfData(fieldValue[i]);

                        //һֶ,","
                        if (i != fieldName.Count - 1)
                        {
                            str1 = string.Format("{0} = {1}", strField, strValue) + ",";
                        }
                        else
                        {
                            str1 = string.Format("{0} = {1}", strField, strValue);
                        }

                        content += str1;
                    }
                }

                //ɸµ,ȻҪUpdate
                ret = string.Format("Update {0} set {1} ", tableName, content);

                //ϸµ
                if (updateID.Count == updateContent.Count)
                {
                    if (updateID.Count > 0)
                    {
                        //ֶһ
                        string strField = updateID[0].ToString().Trim();
                        //ѶӦֵһһ
                        string strValue = this.TypeOfData(updateContent[0]);

                        str2 = string.Format(" and {0} = {1}", strField, strValue);

                        id_content += str2;

                        for (int i = 1; i < updateID.Count; i++)
                        {
                            //ֶһ
                            strField = updateID[i].ToString().Trim();
                            //ѶӦֵһһ
                            strValue = this.TypeOfData(updateContent[i]);

                            str2 = string.Format(" or {0} = {1}", strField, strValue);

                            id_content += str2;
                        }
                    }
                }

                //SQL 
                ret = string.Format("{0}where 1 = 1{1}", ret, id_content);


            }

            return ret;
        }
        catch (Exception ex)
        {
            throw ex;
        }

    }//end function



    /// <summary>
    /// ݱ,KeyֵDelete SQL,,ɾһ
    /// </summary>
    /// <param name="tableName"></param>
    /// <param name="updateID"></param>
    /// <param name="updateContent"></param>
    /// <returns></returns>
    public string GenerateDeleteSQL(string tableName, ArrayList deleteID, ArrayList deleteContent)
    {
        try
        {
            //صSQL
            string ret = string.Empty;
            //ҪɾID
            string id_content = string.Empty;

            string str = string.Empty;

            //Ϊ,ֶκֵֶһһӦ
            if (tableName.Trim() != "")
            {
                //ɸµ,ȻҪUpdate
                ret = string.Format("Delete from {0} ", tableName);

                //ɾ
                if (deleteID.Count == deleteContent.Count)
                {
                    if (deleteID.Count > 0)
                    {
                        for (int i = 0; i < deleteID.Count; i++)
                        {
                            //ֶһ
                            string strField = deleteID[i].ToString().Trim();
                            //ѶӦֵһһ
                            string strValue = this.TypeOfData(deleteContent[i]);

                            str = string.Format(" and {0} = {1}", strField, strValue);

                            id_content += str;
                        }
                    }
                }

                //SQL 
                ret = string.Format("{0}where 1 = 1{1}", ret, id_content);
            }

            return ret;
        }
        catch (Exception ex)
        {
            throw ex;
        }

    }//end function



    /// <summary>
    /// ݱ,KeyֵDelete SQL,,ɾ
    /// </summary>
    /// <param name="tableName"></param>
    /// <param name="updateID"></param>
    /// <param name="updateContent"></param>
    /// <returns></returns>
    public string GenerateDeleteSQL(string tableName, string deleteID, ArrayList deleteContent)
    {
        try
        {
            //صSQL
            string ret = string.Empty;
            //ҪɾID
            string id_content = string.Empty;

            string str = string.Empty;

            //Ϊ,ֶκֵֶһһӦ
            if (tableName.Trim() != "")
            {
                //ɸµ,ȻҪUpdate
                ret = string.Format("Delete from {0} ", tableName);

                //ɾ
                if (deleteID.Trim() != "")
                {
                    if (deleteContent.Count > 0)
                    {
                        //һֵҪand
                        id_content = string.Format(" and {0} = {1}", deleteID, this.TypeOfData(deleteContent[0]));
                        //ӵڶֵ,Ҫor
                        for (int i = 1; i < deleteContent.Count; i++)
                        {

                            //ѶӦֵһһ
                            string strValue = this.TypeOfData(deleteContent[i]);

                            str = string.Format(" or {0} = {1}", deleteID, strValue);

                            id_content += str;
                        }
                    }
                }

                //SQL 
                ret = string.Format("{0}where 1 = 1{1}", ret, id_content);
            }

            return ret;
        }
        catch (Exception ex)
        {
            throw ex;
        }

    }//end function



    /// <summary>
    /// ϼ,иµSQL.
    /// </summary>
    /// <param name="sqlObject"></param>
    /// <returns></returns>
    public string GenerateMultiKeyRowUpdateSQL(SQLObject[] sqlObject)
    {
        try
        {
            //صSQL
            string strRet = string.Empty;
            //ֶ,Ӧֵ
            string strSql1 = string.Empty;
            //key,Ӧֵ
            string strSql2 = string.Empty;
            string strSql3 = string.Empty;

            string strContent = string.Empty;
            string strKeyContent = string.Empty;


            //ȡ 
            string strTableName = string.Empty;
            //ֶ
            string strFieldName = string.Empty;
            //ֶ
            string strFieldValue = string.Empty;

            //ϼ
            string strKey = string.Empty;
            //ϼ
            string strKeyValue = string.Empty;


            //ûж,ͷؿյSQL
            if (sqlObject.Length < 1)
            {
                return "";
            }
            else
            {
                //ȡñ
                strTableName = sqlObject[0].TableName;
                //Ϊ
                if (strTableName != "")
                {
                    //ֶμӦֵ,ֻҪȡ׸ԪؾͿ.
                    for (int i = 0; i < sqlObject[0].TableField.Count; i++)
                    {
                        //ֶ
                        strFieldName = sqlObject[0].TableField[i].ToString();
                        //ֶӦֵ
                        strFieldValue = this.TypeOfData(sqlObject[0].TableFieldValue[i]);

                        //һֶ,","
                        if (i != sqlObject[0].TableField.Count - 1)
                        {
                            strContent = string.Format("{0} = {1}", strFieldName, strFieldValue) + ",";
                        }
                        else
                        {
                            strContent = string.Format("{0} = {1}", strFieldName, strFieldValue);
                        }

                        strSql1 += strContent;
                    }

                    //ɸµ,ȻҪUpdate
                    strRet = string.Format("Update {0} set {1} ", strTableName, strSql1);

                    //һϼ  			
                    for (int j = 0; j < sqlObject[0].TableKey.Count; j++)
                    {
                        strKey = sqlObject[0].TableKey[j].ToString();

                        strKeyValue = this.TypeOfData(sqlObject[0].TableKeyValue[j]);

                        if (j != sqlObject[0].TableKey.Count - 1)
                        {
                            strKeyContent = string.Format("{0} = {1}", strKey, strKeyValue) + " and ";
                        }
                        else
                        {
                            strKeyContent = string.Format("{0} = {1}", strKey, strKeyValue);
                        }

                        strSql2 += strKeyContent;

                    }
                    //ֻһ¼ʱ,ʱѾ˲Update.
                    strRet = string.Format("{0} where ({1})", strRet, strSql2);

                    //м¼ʱͽȥ
                    for (int k = 1; k < sqlObject.Length; k++)
                    {
                        strSql3 = string.Empty;

                        for (int p = 0; p < sqlObject[k].TableKey.Count; p++)
                        {
                            strKey = sqlObject[k].TableKey[p].ToString();

                            strKeyValue = this.TypeOfData(sqlObject[k].TableKeyValue[p]);

                            if (p != sqlObject[k].TableKey.Count - 1)
                            {
                                strKeyContent = string.Format("{0} = {1}", strKey, strKeyValue) + " and ";
                            }
                            else
                            {
                                strKeyContent = string.Format("{0} = {1}", strKey, strKeyValue);
                            }
                            strSql3 += strKeyContent;

                        }//end for

                        strRet += string.Format(" or ({0})", strSql3);

                    }//end for



                }//end if

            }//end else


            return strRet;

        }//end try
        catch (Exception ex)
        {
            throw ex;
        }

    }//end function

    /// <summary>
    /// ϼ,ɾSQL.
    /// </summary>
    /// <param name="sqlObject"></param>
    /// <returns></returns>
    public string GenerateMultiKeyRowDeleteSQL(SQLObject[] sqlObject)
    {
        try
        {
            //صSQL
            string strRet = string.Empty;
            //ֶ,Ӧֵ
            string strSql1 = string.Empty;
            //key,Ӧֵ
            string strSql2 = string.Empty;

            string strContent = string.Empty;
            string strKeyContent = string.Empty;

            //ȡ 
            string strTableName = string.Empty;
            //ϼ
            string strKey = string.Empty;
            //ϼ
            string strKeyValue = string.Empty;


            //ûж,ͷؿյSQL
            if (sqlObject.Length < 1)
            {
                return "";
            }
            else
            {
                //ȡñ
                strTableName = sqlObject[0].TableName;
                //Ϊ
                if (strTableName != "")
                {


                    //ɸµ,ȻҪDelete
                    strRet = string.Format("Delete from {0}", strTableName);

                    //һϼ  			
                    for (int j = 0; j < sqlObject[0].TableKey.Count; j++)
                    {
                        strKey = sqlObject[0].TableKey[j].ToString();

                        strKeyValue = this.TypeOfData(sqlObject[0].TableKeyValue[j]);

                        if (j != sqlObject[0].TableKey.Count - 1)
                        {
                            strKeyContent = string.Format("{0} = {1}", strKey, strKeyValue) + " and ";
                        }
                        else
                        {
                            strKeyContent = string.Format("{0} = {1}", strKey, strKeyValue);
                        }

                        strSql1 += strKeyContent;

                    }
                    //ֻһ¼ʱ,ʱѾ˲Update.
                    strRet = string.Format("{0} where ({1})", strRet, strSql1);

                    //м¼ʱͽȥ
                    for (int k = 1; k < sqlObject.Length; k++)
                    {
                        strSql2 = string.Empty;

                        for (int p = 0; p < sqlObject[k].TableKey.Count; p++)
                        {
                            strKey = sqlObject[k].TableKey[p].ToString();

                            strKeyValue = this.TypeOfData(sqlObject[k].TableKeyValue[p]);

                            if (p != sqlObject[k].TableKey.Count - 1)
                            {
                                strKeyContent = string.Format("{0} = {1}", strKey, strKeyValue) + " and ";
                            }
                            else
                            {
                                strKeyContent = string.Format("{0} = {1}", strKey, strKeyValue);
                            }
                            strSql2 += strKeyContent;

                        }//end for

                        strRet += string.Format(" or ({0})", strSql2);

                    }//end for



                }//end if

            }//end else


            return strRet;
        }
        catch (Exception ex)
        {
            throw ex;
        }
    }//end function

    public static string GenerateSelectSQL()
    {
        string strSQL = string.Empty;

        return strSQL;
    }

    /// <summary>
    /// жݵ,Ϊ,ȫ''
    /// </summary>
    /// <param name="s"></param>
    /// <returns></returns>
    private string TypeOfData(object obj)
    {
        try
        {
            string ret = string.Empty;
            //
            if (obj is byte || obj is int || obj is Int16 || obj is Int32 || obj is Int64 || obj is long || obj is float || obj is double || obj is decimal)
            {
                ret = obj.ToString().Trim();
                return ret;
            }
            else
            {
                ret = string.Format("'{0}'", obj.ToString().Trim()).Trim();
            }

            return ret;
        }
        catch (Exception ex)
        {
            throw ex;
        }
    }//end function
}
