﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Collections;
using System.Data.SqlClient;
using System.Web.UI;
using System.Text.RegularExpressions;
using MySql.Data.MySqlClient;



/// <summary>
/// Summary description for MySQL
/// </summary>
public class MySQL
{
    static string strConnect = ConfigurationManager.AppSettings["MySQL"].ToString();

    /// <summary>
    /// construction function
    /// </summary>
    /// <param name="sConnect"></param>
    public MySQL(string sConnect)
    {
        strConnect = sConnect;
    }

    /// <summary>
    /// return a oledbconnection object
    /// </summary>
    public static MySqlConnection GetConnection()
    {
        MySqlConnection myConnection = null;
        try
        {
            if (myConnection == null)
                myConnection = new MySqlConnection(strConnect);
            if (myConnection.State != ConnectionState.Open)
                myConnection.Open();
        }
        catch (MySql.Data.MySqlClient.MySqlException ex)
        {
            throw ex;
        }
        return myConnection;
    }

    /// <summary>
    /// return a datatable object by SQL command
    /// </summary>
    /// <param name="sSQL"></param>
    /// <returns></returns>
    public static System.Data.DataSet GetDataSet(string sSQL)
    {
        MySqlConnection Conn = null;
        DataSet datObject = new DataSet();

        try
        {
            Conn = GetConnection(); ;
            MySqlCommand cmdObject = new MySqlCommand(sSQL, Conn);
            MySqlDataAdapter adpObject = new MySqlDataAdapter(cmdObject);
            adpObject.Fill( datObject );
        }
        catch ( Exception ex)
        {
            throw ex;
        }
        finally
        {
            if (Conn != null)
                Conn.Close();
        }

        return datObject;
    }

    /// <summary>
    /// execute a SQL command
    /// </summary>
    /// <param name="sSQL"></param>
    /// <returns></returns>
    public static int ExecuteSQL(string sSQL)
    {

        int iCount = 0;

        MySqlConnection Conn = null;
        MySqlTransaction traObject = null;
        try
        {
            Conn = GetConnection();
            traObject = Conn.BeginTransaction();

            MySqlCommand cmdObject = new MySqlCommand(sSQL, Conn, traObject);
            iCount = cmdObject.ExecuteNonQuery();
            traObject.Commit();
        }
        catch (MySql.Data.MySqlClient.MySqlException ex)
        {
            if (traObject != null)
                traObject.Rollback();

            throw ex;
        }
        finally
        {
            if (Conn != null)
                Conn.Close();
        }

        return iCount;
    }

    public static int ExecuteSQL(string sSQL, ArrayList paramList)
    {
        if (paramList != null && !CheckParams(paramList.ToArray())) return 0;

        int iCount = 0;

        MySqlConnection Conn = null; ;
        MySqlTransaction traObject = null;
        try
        {
            Conn = GetConnection();
 //           traObject = Conn.BeginTransaction();

            MySqlCommand cmdObject = new MySqlCommand(sSQL, Conn, traObject);
            MySqlParameter[] parameters = new MySqlParameter[paramList.Count];
            for (int i = 0; i < paramList.Count; ++i)
            {
                parameters[i] = new MySqlParameter();
                parameters[i].ParameterName = "@" + i.ToString();
                parameters[i].Value = paramList[i];
                cmdObject.Parameters.Add(parameters[i]);
            }

            iCount = cmdObject.ExecuteNonQuery();
            traObject.Commit();
        }
        catch (MySql.Data.MySqlClient.MySqlException ex)
        {
            if (traObject != null)
                traObject.Rollback();

            throw ex;
        }
        finally
        {
            if (Conn != null)
                Conn.Close();
        }

        return iCount;
    }


    public static DataSet GetDataSet(MySqlConnection connection, string commandText, params MySqlParameter[] commandParameters)
    {
        MySqlCommand cmd = new MySqlCommand();
        cmd.Connection = connection;
        cmd.CommandText = commandText;
        cmd.CommandType = CommandType.Text;

        if (commandParameters != null)
            foreach (MySqlParameter p in commandParameters)
                cmd.Parameters.Add(p);

        MySqlDataAdapter da = new MySqlDataAdapter(cmd);
        DataSet ds = new DataSet();

        da.Fill(ds);
        cmd.Parameters.Clear();

        return ds;
    }

    public static DataSet GetDataSet(MySqlConnection connection, string commandText, MySqlTransaction trans, params MySqlParameter[] commandParameters)
    {
        MySqlCommand cmd = new MySqlCommand();
        cmd.Connection = connection;
        cmd.Transaction = trans;
        cmd.CommandText = commandText;
        cmd.CommandType = CommandType.Text;

        if (commandParameters != null)
            foreach (MySqlParameter p in commandParameters)
                cmd.Parameters.Add(p);

        MySqlDataAdapter da = new MySqlDataAdapter(cmd);
        DataSet ds = new DataSet();

        da.Fill(ds);
        cmd.Parameters.Clear();

        return ds;
    }

    public static DataSet GetDataSet(string commandText, params object[] commandParameters)
    {
        MySqlConnection Conn = null;
        try
        {
            if (commandParameters != null && !CheckParams(commandParameters)) return null;

            Conn = GetConnection();
            MySqlCommand cmd = new MySqlCommand();
            cmd.Connection = Conn;
            cmd.CommandText = commandText;
            cmd.CommandType = CommandType.Text;

            if (commandParameters != null)
            {
                MySqlParameter[] param = new MySqlParameter[commandParameters.Length];

                for (int i = 0; i < commandParameters.Length; ++i)
                {
                    if (commandParameters[i] == null)
                        continue;
                    param[i] = new MySqlParameter();
                    param[i].ParameterName = "@" + i.ToString();
                    param[i].Value = commandParameters[i];
                    cmd.Parameters.Add(param[i]);
                }

            }
            MySqlDataAdapter da = new MySqlDataAdapter(cmd);
            DataSet ds = new DataSet();

            da.Fill(ds);
            cmd.Parameters.Clear();

            return ds;
        }
        catch (Exception ex)
        {
            throw ex;
        }
        finally
        {
            if (Conn != null)
                Conn.Close();
        }
    }

    public static int ExecuteSQL(MySqlCommand cmd, params MySqlParameter[] commandParameters)
    {
        if (commandParameters != null)
            foreach (MySqlParameter p in commandParameters)
                cmd.Parameters.Add(p);

        int result = cmd.ExecuteNonQuery();
        cmd.Parameters.Clear();

        return result;
    }

    public static bool HasSameRecord(Page p, string sTable, string sId, string sValue, string sAlertName)
    {
        bool bolRet = false;
        MySqlConnection Conn = null;

        try
        {
            Conn = MySQL.GetConnection();

            string strSQL = string.Format("SELECT * FROM {0} WHERE UPPER({1})=UPPER(@0) AND status<>1", sTable, sId);
            MySqlParameter[] parameters = new MySqlParameter[1];
            parameters[0] = new MySqlParameter();
            parameters[0].ParameterName = "@0";
            parameters[0].Value = sValue;

            if (MySQL.GetDataSet(Conn, strSQL, parameters).Tables[0].Rows.Count > 0)
            {
                p.Response.Write(string.Format("<script>alert('Same {0} already exists!');</script>", sAlertName));
                bolRet = true;
            }

            return bolRet;
        }
        catch (Exception ex)
        {
            throw ex;
        }
        finally
        {
            if (Conn != null)
                Conn.Close();
        }
    }

    public static int HasSameRecord(string sTable, string sId, string sValue)
    {
        int intRet = 0;
        MySqlConnection Conn = null;

        try
        {
            Conn = MySQL.GetConnection();

            string strSQL = string.Format("SELECT * FROM {0} WHERE UPPER({1})=UPPER(@0) AND status<>1", sTable, sId);
            MySqlParameter[] parameters = new MySqlParameter[1];
            parameters[0] = new MySqlParameter();
            parameters[0].ParameterName = "@0";
            parameters[0].Value = sValue;

            intRet = MySQL.GetDataSet(Conn, strSQL, parameters).Tables[0].Rows.Count;

            return intRet;
        }
        catch (Exception ex)
        {
            throw ex;
        }
        finally
        {
            if (Conn != null)
                Conn.Close();
        }
    }

    public static void setLastUpdateTime(String perid)
    {
        try
        {
            String sql = String.Format("UPDATE personal_base SET lastupdate_date = GETDATE() WHERE perid='{0}'", perid);
            ExecuteSQL(sql);
        }
        catch (Exception ex)
        {
            throw ex;
        }
    }

    public static bool CheckParams(params object[] args)
    {
        string[] Lawlesses ={ "=", "'" };
        if (Lawlesses == null || Lawlesses.Length <= 0) return true;

        //构造正则表达式,例:Lawlesses是=号和'号,则正则表达式为 .*[=}'].*  (正则表达式相关内容请见MSDN)
        //另外,由于我是想做通用而且容易修改的函数,所以多了一步由字符数组到正则表达式,实际使用中,直接写正则表达式亦可;
        string str_Regex = ".*[";
        for (int i = 0; i < Lawlesses.Length - 1; i++)
            str_Regex += Lawlesses[i] + "|";
        str_Regex += Lawlesses[Lawlesses.Length - 1] + "].*";

        foreach (object arg in args)
        {
            if (arg is string)//如果是字符串,直接检查
            {
                if (Regex.Matches(arg.ToString(), str_Regex).Count > 0)
                    return false;
            }
            else if (arg is ICollection)//如果是一个集合,则检查集合内元素是否字符串,是字符串,就进行检查
            {
                foreach (object obj in (ICollection)arg)
                {
                    if (obj is string)
                    {
                        if (Regex.Matches(obj.ToString(), str_Regex).Count > 0)
                            return false;
                    }
                }
            }
        }
        return true;
    }
}
