﻿using System.Configuration;

namespace DBUtility
{
    using System;
    using System.Collections.Generic;
    using System.Data;
    using System.Data.OleDb;
    using System.Web;

    public class SqlHelper
    {
        public static DataTable ExecuteDt(string OleDbstr)
        {
            using (OleDbConnection connection = new OleDbConnection(GetOleDbConnection()))
            {
                OleDbDataAdapter adapter = new OleDbDataAdapter(OleDbstr, connection);
                DataTable dataTable = new DataTable();
                connection.Open();
                adapter.Fill(dataTable);
                connection.Close();
                return dataTable;
            }
        }

        public static DataTable ExecuteDt(string OleDbstr, OleDbParameter[] param)
        {
            using (OleDbConnection connection = new OleDbConnection(GetOleDbConnection()))
            {
                DataTable dataTable = new DataTable();
                OleDbDataAdapter adapter = new OleDbDataAdapter();
                OleDbCommand command = new OleDbCommand(OleDbstr, connection);
                command.Connection = connection;
                command.Parameters.AddRange(param);
                adapter.SelectCommand = command;
                connection.Open();
                adapter.Fill(dataTable);
                connection.Close();
                command.Dispose();
                return dataTable;
            }
        }

        public static bool ExecuteSql(string OleDb)
        {
            using (OleDbConnection connection = new OleDbConnection(GetOleDbConnection()))
            {
                OleDbCommand command = new OleDbCommand();
                command.Connection = connection;
                command.CommandText = OleDb;
                connection.Open();
                command.ExecuteNonQuery();
                connection.Close();
                return true;
            }
        }

        public static bool ExecuteSql(string OleDbstr, OleDbParameter[] param)
        {
            using (OleDbConnection connection = new OleDbConnection(GetOleDbConnection()))
            {
                OleDbCommand command = new OleDbCommand();
                command.Connection = connection;
                command.CommandText = OleDbstr;
                command.Parameters.AddRange(param);
                connection.Open();
                command.ExecuteNonQuery();
                connection.Close();
                return true;
            }
        }

        public static int ExecuteSqls(string[] OleDbstr, List<OleDbParameter[]> param)
        {
            int num3;
            using (OleDbConnection connection = new OleDbConnection(GetOleDbConnection()))
            {
                OleDbCommand command = new OleDbCommand();
                OleDbTransaction transaction = null;
                command.Transaction = transaction;
                try
                {
                    connection.Open();
                    transaction = connection.BeginTransaction();
                    command.Connection = connection;
                    command.Transaction = transaction;
                    int length = OleDbstr.Length;
                    for (int i = 0; i < length; i++)
                    {
                        command.CommandText = OleDbstr[i];
                        command.Parameters.AddRange(param[i]);
                        command.ExecuteNonQuery();
                    }
                    transaction.Commit();
                    num3 = 1;
                }
                catch
                {
                    transaction.Rollback();
                    num3 = 0;
                }
                finally
                {
                    command.Dispose();
                    connection.Close();
                }
            }
            return num3;
        }

        public static string GetOleDbConnection()
        {
            return ("Provider=SQLOLEDB;" + ConfigurationManager.AppSettings["server"].ToString()); 
            //return ("Provider=SQLOLEDB;Data Source=ROYA-087E387F4F;database=MZMT;user id=wwbiaogyz;password=123456");
        }

        public static OleDbParameter GetParameter(string paramName, OleDbType paramType, object paramValue)
        {
            OleDbParameter parameter = new OleDbParameter(paramName, paramType);
            parameter.Value = paramValue;
            return parameter;
        }

        public static OleDbParameter GetParameter(string paramName, OleDbType paramType, int paramSize, string ColName)
        {
            return new OleDbParameter(paramName, paramType, paramSize, ColName);
        }

        public static OleDbParameter GetParameter(string paramName, OleDbType paramType, int paramSize, string ColName, object paramValue)
        {
            OleDbParameter parameter = new OleDbParameter(paramName, paramType, paramSize, ColName);
            parameter.Value = paramValue;
            return parameter;
        }
    }
}

