﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

public partial class Company_CompanyBasic : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Session["comid"] != null)
            {
                IniMonthDay();
                loadBaseInfo();
            }
            else
            {
                Response.Redirect("~/include/Register_Company.aspx?mode=0");
                return;
            }
        }
    }

    protected void btnOk_Click(object sender, EventArgs e)
    {
        String sql = String.Empty;
        ArrayList paramList = new ArrayList();

        String comid = txtComId.Value;

        SqlConnection conn = null;
        SqlTransaction trans = null;
        bool transBegin = false;
        try
        {
            conn = DB.GetConnection();

            SqlCommand cmd = new SqlCommand();
            cmd.Connection = conn;
            cmd.CommandType = CommandType.Text;
            trans = conn.BeginTransaction();
            cmd.Transaction = trans;
            transBegin = true;

            paramList.Clear();
            sql = "UPDATE company_base SET companyname=@1,license=@2," +
                      "industry=@3,type=@4,found_year=@5,found_month=@6,found_day=@7,reg_capital=@8,reg_currency=@9," +
                      "workers=@10,province=@11,city=@12,memo=@13,contact_phone=@14,contact_person=@15,contact_phone_isshow=@16," +
                      "contact_fax=@17,email=@18,email_isshow=@19,website=@20,zipcode=@21,address=@22,Last_ip=@23," +
                      "last_date=GETDATE() WHERE comid=@0  ";

            txtProvince.Text = "广东省";
            paramList.Add(comid);
            paramList.Add(txtCompanyName.Text);
            paramList.Add(txtLicense.Text);
            paramList.Add(cmbIndustry.SelectedItem.Text);
            paramList.Add(cmbType.SelectedItem.Text);
            paramList.Add(txtFoundYear.Text);
            paramList.Add(cmbFoundMonth.SelectedItem.Text);
            paramList.Add(cmbFoundDay.SelectedItem.Text);
            paramList.Add(Convert.ToInt32(txtRegCapital.Text));
            paramList.Add(Convert.ToInt32(cmbRegCurrency.SelectedItem.Value));
            paramList.Add(Convert.ToInt32(cmbWorkers.SelectedItem.Value));
            paramList.Add(txtProvince.Text);
            paramList.Add(txtCity.Text);
            paramList.Add(txtMemo.Text);
            paramList.Add(txtPhone.Text);
            paramList.Add(txtContactPerson.Text);
            paramList.Add(chkPhoneIsShow.Checked ? 1 : 0);
            paramList.Add(txtFax.Text);
            paramList.Add(txtEmail2.Text);
            paramList.Add(chkEmailIsShow.Checked ? 1 : 0);
            paramList.Add(txtWebsite.Text);
            paramList.Add(txtZipCode.Text);
            paramList.Add(txtAddress.Text);
            paramList.Add(Request.ServerVariables.Get("REMOTE_ADDR").ToString());

            SqlParameter[] parameters = new SqlParameter[paramList.Count];

            for (int i = 0; i < paramList.Count; ++i)
            {
                parameters[i] = new SqlParameter();
                parameters[i].ParameterName = "@" + i.ToString();
                parameters[i].Value = paramList[i];
            }
            cmd.CommandText = sql;
            DB.ExecuteSQL(cmd, parameters);

            trans.Commit();

            transBegin = false;
            Session["comid"] = comid;
            Common.Alert("保存数据成功!", this);
        }
        catch (Exception ex)
        {
            if (transBegin)
                trans.Rollback();
            Response.Write(ex.Message);
            Response.End();
        }
        finally
        {
            if (conn != null && conn.State == ConnectionState.Open)
                conn.Close();
        }
    }

    private void loadBaseInfo()
    {
        String comid = Session["comid"].ToString();
        txtComId.Value = comid;

        String sql = "SELECT * FROM company_base WHERE comid = @0";

        DataTable company = DB.GetDataSet(sql, comid).Tables[0];

        if (company.Rows.Count > 0)
        {
            DataRow row = company.Rows[0];

            txtCompanyName.Text = Convert.ToString(row["companyname"]);
            txtLicense.Text = Convert.ToString(row["license"]);
            if (cmbIndustry.Items.FindByText(row["industry"].ToString()) != null)
                cmbIndustry.SelectedValue = cmbIndustry.Items.FindByText(row["industry"].ToString()).Value;
            else
                cmbIndustry.SelectedIndex = 0;
            if (cmbType.Items.FindByText(row["Type"].ToString()) != null)
                cmbType.SelectedValue = cmbType.Items.FindByText(row["Type"].ToString()).Value;
            else
                cmbType.SelectedIndex = 0;
            txtFoundYear.Text = Convert.ToString(row["found_year"]);
            cmbFoundMonth.SelectedValue = Convert.ToString(row["found_month"]);
            cmbFoundDay.SelectedValue = Convert.ToString(row["found_day"]);
            txtRegCapital.Text = Convert.ToString(row["reg_capital"]);
            cmbRegCurrency.SelectedValue = Convert.ToString(row["reg_currency"]);
            cmbWorkers.SelectedValue = Convert.ToString(row["workers"]);
            txtProvince.Text = Convert.ToString(row["province"]);
            txtCity.Text = Convert.ToString(row["city"]);
            txtMemo.Text = Convert.ToString(row["memo"]);
            txtPhone.Text = Convert.ToString(row["contact_phone"]);
            txtContactPerson.Text = Convert.ToString(row["contact_person"]);
            chkPhoneIsShow.Checked = Convert.ToBoolean(row["contact_phone_isshow"]);
            txtFax.Text = Convert.ToString(row["contact_fax"]);
            txtEmail2.Text = Convert.ToString(row["email"]);
            chkEmailIsShow.Checked = Convert.ToBoolean(row["email_isshow"]);
            txtWebsite.Text = Convert.ToString(row["website"]);
            txtZipCode.Text = Convert.ToString(row["zipcode"]);
            txtAddress.Text = Convert.ToString(row["address"]);
        }
    }

    private void IniMonthDay()
    {
        for (int i = 1; i < 13; ++i)
        {
            cmbFoundMonth.Items.Add(i.ToString());
        }

        for (int i = 1; i < 32; ++i)
        {
            cmbFoundDay.Items.Add(i.ToString());
        }
    }
}
