﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Company_CompanyCenter : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Session["comid"] != null)
            {
                InitInformation();
                saveLoginInfo();
            }
            else
            {
                Response.Redirect("index.aspx");
                return;
            }

        }
    }

    private void InitInformation()
    {
        String comid = Session["comid"].ToString();
        String sql = String.Empty;
        sql = "SELECT companyname,last_date,view_clicks FROM company_base WHERE comid=@0;" ;
        sql += "SELECT COUNT(jobid) jobcnt FROM jobs WHERE comid=@0;" ;
        sql += "SELECT COUNT(comid) mailcnt FROM company_inbox WHERE comid=@0;" ;
        sql += "SELECT COUNT(comid) newmailcnt FROM company_inbox WHERE comid=@0 AND isread=0;" ;
        sql += "SELECT COUNT(comid) personcnt FROM company_db WHERE comid=@0;" ;

        DataSet company = DB.GetDataSet(sql, comid);
        if (company.Tables.Count > 0)
        {
            lblUserName.Text = company.Tables[0].Rows[0]["companyname"].ToString();
            lbllastDate.Text = company.Tables[0].Rows[0]["last_date"].ToString();
            lblViewClicks.Text = company.Tables[0].Rows[0]["view_clicks"].ToString();
            lblJobs.Text = company.Tables[1].Rows[0]["jobcnt"].ToString();
            lblInbox.Text = company.Tables[2].Rows[0]["mailcnt"].ToString();
            lblInboxNew.Text = company.Tables[3].Rows[0]["newmailcnt"].ToString();
            lblDb.Text = company.Tables[4].Rows[0]["personcnt"].ToString();
        }

    }

    private void saveLoginInfo()
    {
        String comid = Session["comid"].ToString();
        String sql = "UPDATE company_base SET last_ip=@1,last_date=GETDATE() " +
                          "WHERE comid=@0";
        ArrayList paramList = new ArrayList();
        paramList.Add( comid);
        paramList.Add( Request.ServerVariables.Get("REMOTE_ADDR").ToString());

        DB.ExecuteSQL(sql, paramList);

    }
}
