﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Company_CompanyDepartment : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Session["comid"] != null)
            {
                InitForm();
            }
        }
    }

    private void InitForm()
    {
        txtComId.Value = Session["comid"].ToString();
        LoadData(txtComId.Value);
    }

    private void LoadData(String comid)
    {
        String sql =  "SELECT deptid,deptname,dept_contact,email FROM company_dept WHERE comid=@0 ORDER BY deptid";

        DataTable department = DB.GetDataSet(sql, comid).Tables[0];

        grdDepartment.DataSource = department;
        grdDepartment.DataBind();
    }

    protected void btnOk_Click(object sender, EventArgs e)
    {
        try
        {
            ArrayList paramList = new ArrayList();
            String sql = string.Empty;

            paramList.Add(txtDeptName.Text);
            paramList.Add(txtDeptContact.Text);
            paramList.Add(txtEmail.Text);
            if (txtDeptId.Value.Trim() != "")
            {
                sql = "UPDATE company_dept SET deptname=@0,dept_contact=@1,email=@2 WHERE deptid=@4";
                paramList.Add(txtComId.Value);
                paramList.Add(txtDeptId.Value);
            }
            else
            {
                sql = "INSERT INTO company_dept(comid,deptname,dept_contact,email) " +
                             "VALUES(@3,@0,@1,@2)";
                paramList.Add(txtComId.Value);
            }
            sql += ";UPDATE company_base SET last_update_date = GETDATE() WHERE comid=@3";
            
            

            DB.ExecuteSQL(sql, paramList);
            clearData();
            LoadData(txtComId.Value);

            txtDeptId.Value = "";
            Session["comid"] = txtComId.Value;
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }

    private void clearData()
    {
        txtDeptName.Text = "";
        txtDeptContact.Text = "";
        txtEmail.Text = "";
    }
    protected void grdDepartment_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        String deptid = ((Label)grdDepartment.Rows[e.RowIndex].FindControl("lblDeptId")).Text;
        DeleteItem(deptid);
    }

    private void DeleteItem(String deptid)
    {
        try
        {
            String sql = "DELETE FROM company_dept WHERE deptid=@0";
            DB.ExecuteSQL(sql,  deptid);
            clearData();
            LoadData(txtDeptId.Value);
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }

    protected void grdDepartment_RowEditing(object sender, GridViewEditEventArgs e)
    {
        String deptid = ((Label)grdDepartment.Rows[e.NewEditIndex].FindControl("lblDeptId")).Text;
        UpdateItem(deptid);
    }

    private void UpdateItem(String deptid)
    {
        try
        {
            String sql = "SELECT * FROM company_dept WHERE deptid = @0";
            DataTable work = DB.GetDataSet(sql, deptid).Tables[0];
            if (work.Rows.Count > 0)
            {
                DataRow row = work.Rows[0];
                txtDeptName.Text = row["deptName"].ToString();
                txtDeptContact.Text = Convert.ToString(row["dept_Contact"]);
                txtEmail.Text = Convert.ToString(row["email"]);
                txtDeptId.Value = deptid;
            }
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }
}
