﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Company_CompanyLogo : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Session["comid"] != null)
            {
                txtComId.Value = Session["comid"].ToString();
                loadImage();
            }
            else
                Response.Redirect("~/include/Register_Company.aspx?mode=0");
        }
    }

    private bool loadImage()
    {
        bool ret = false;
        String sql = "SELECT logo_url FROM company_base WHERE comid=@0";
        DataTable logo = DB.GetDataSet(sql, txtComId.Value).Tables[0];

        if (logo.Rows.Count > 0)
        {
            String url = Convert.ToString(logo.Rows[0]["logo_url"]);
            if (url.Trim() != "")
            {
                string path = Server.MapPath("~/temp/image/");
                string picUrl = Common.downloadFile(url, path, txtComId.Value, "~/temp/image/");
                if (picUrl != "")
                {
                    Image1.ImageUrl = picUrl;
                    ret = true;
                }
            }
        }
        return ret;
    }

    private void uploadFile()
    {
        Boolean fileOK = false;
        String path = Server.MapPath("~/company/photo/");
        String fileExtension = "";
        if (FileUpload1.HasFile)
        {
            long MaxLength = Convert.ToInt32(ConfigurationManager.AppSettings["FileMax"]) * 1024;
            if (FileUpload1.FileContent.Length > MaxLength)
            {
                Label1.Text = "文件大小超出限制";
                return;
            }
            fileExtension = System.IO.Path.GetExtension(FileUpload1.FileName).ToLower();
            String[] allowedExtensions = { ".gif", ".jpeg", ".jpg" };
            for (int i = 0; i < allowedExtensions.Length; i++)
            {
                if (fileExtension == allowedExtensions[i])
                    fileOK = true;
            }
        }

        if (fileOK)
        {
            try
            {
                FileUpload1.PostedFile.SaveAs(path + txtComId.Value + fileExtension);
                String url = "photo/" + txtComId.Value + fileExtension;

              

                url = Common.uploadFile(FileUpload1.PostedFile, "company", txtComId.Value + fileExtension);
                if (url.Equals("")) { Label1.Text = "上传图片失败。"; return; }

                String sql = "UPDATE company_base SET logo_url=@0 WHERE comid=@1";

                ArrayList paramList = new ArrayList();
                paramList.Add( url);
                paramList.Add( txtComId.Value);

                DB.ExecuteSQL(sql, paramList);
                Image1.ImageUrl = "photo/" + txtComId.Value + fileExtension; ;
                Label1.Text = "文件上传成功";
            }
            catch (Exception ex)
            {
                Label1.Text = String.Format("文件上传失败-{0}", ex.Message);
            }
        }
        else
        {
            Label1.Text = "不能上传这种类型的文件";
        }

    }
    protected void btnUpload_Click(object sender, EventArgs e)
    {
        uploadFile();
    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        try
        {
            String sql = "UPDATE company_base SET logo_url = '' WHERE comid = @0";
            DB.ExecuteSQL(sql, txtComId.Value);
            Image1.ImageUrl = "~/Images/Company.gif";
            Label1.Text = "图片标识已删除";
        }
        catch (Exception ex)
        {
            Label1.Text = ex.Message;
        }
    }
}
