﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Company_CompanyPublish : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Session["comid"] != null)
            {
                txtComId.Value = Session["comid"].ToString();
                InitDepartment();
                IniMonthDay();
                loadData();
            }
            else
                Response.Redirect("~/include/Register_Company.aspx?mode=0");
        }
    }

    protected void btnOk_Click(object sender, EventArgs e)
    {
        try
        {
            SaveData();
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }

    private void loadData()
    {
        String sql = "SELECT contact_person,contact_phone,contact_phone_isshow," +
                                   "contact_fax,email,email_isshow,zipcode,address " +
                                   "FROM company_base WHERE comid= @0";
        DataTable company = DB.GetDataSet(sql, txtComId.Value).Tables[0];
        if (company.Rows.Count > 0)
        {
            DataRow row = company.Rows[0];
            txtContactPerson.Text = Convert.ToString(row["contact_person"]);
            txtPhone.Text = Convert.ToString(row["contact_phone"]);
            if (row["contact_phone_isshow"] != null)
                chkIsShowPhone.Checked = Convert.ToBoolean(row["contact_phone_isshow"]);
            txtFax.Text = Convert.ToString(row["contact_fax"]);
            txtEmail.Text = Convert.ToString(row["email"]);
            if (row["email_isshow"] != null)
                chkIsShowEmail.Checked = Convert.ToBoolean(row["email_isshow"]);
            txtZipCode.Text = Convert.ToString(row["zipcode"]);
            txtAddress.Text = Convert.ToString(row["address"]);
        }
    }


    private void SaveData()
    {
        try
        {
            ArrayList paramList = new ArrayList();
            String sql = "";
            sql = "INSERT INTO jobs(comid,jobtype,jobclass,jobname,ishot,deptid,number,salary," +
                  "enddate_year,enddate_month,enddate_day,enddate,work_province,work_city," +
                  "required,education,sex,work_years,current_province,current_city,age_max,age_min," +
                  "hukou,contact_person,contact_phone,contact_phone_isShow,contact_fax," +
                  "contact_email,contact_email_isshow,address,zipcode,lastupdate_date," +
                  "viewclicks,sendclicks,isactive,isverified) " +
                  "VALUES(@0,@1,@2,@3,@4,@5,@6,@7,@8,@9,@10,@11,@12,@13,@14,@15,@16,@17," +
                  "@18,@19,@20,@21,@22,@23,@24,@25,@26,@27,@28,@29,@30,GETDATE(),0,0,@31,0)";

            paramList.Add(txtComId.Value);
            paramList.Add(Type);
            paramList.Add(txtJobValue.Value);
            paramList.Add(txtJobName.Text);
            paramList.Add(chkIsHot.Checked ? 1 : 0);
            if (cmbDepartment.SelectedItem != null)
                paramList.Add(cmbDepartment.SelectedItem.Value);
            else
                paramList.Add("");
            paramList.Add(Convert.ToInt32(txtWorkers.Text));
            paramList.Add(Convert.ToInt32(txtSalary.Text));
            paramList.Add(Convert.ToInt32(cmbEndYear.Text));
            paramList.Add(Convert.ToInt32(cmbEndMonth.Text));
            paramList.Add(Convert.ToInt32(cmbEndDay.Text));
            paramList.Add(cmbEndYear.Text + "-" + cmbEndMonth.Text + "-" + cmbEndDay.Text);
            paramList.Add(getSubString(txtAreaValue.Value, 0));
            paramList.Add(getSubString(txtAreaValue.Value, 1));
            paramList.Add(txtRequire.Text);
            paramList.Add(cmbDegree.Text);
            paramList.Add(Convert.ToInt32(cmbSex.SelectedItem.Value));
            paramList.Add(Convert.ToInt32(cmbWorkYears.SelectedItem.Value));
            paramList.Add(txtCurProvince.Text);
            paramList.Add(txtCurCity.Text);
            paramList.Add(txtMaxAge.Text.Trim() == "" ? 0 : Convert.ToInt32(txtMaxAge.Text));
            paramList.Add(txtMinAge.Text.Trim() == "" ? 0 : Convert.ToInt32(txtMinAge.Text));
            paramList.Add(txtHukouAddress.Text);
            paramList.Add(txtContactPerson.Text);
            paramList.Add(txtPhone.Text);
            paramList.Add(chkIsShowPhone.Checked ? 1 : 0);
            paramList.Add(txtFax.Text);
            paramList.Add(txtEmail.Text);
            paramList.Add(chkIsShowEmail.Checked ? 1 : 0);
            paramList.Add(txtAddress.Text);
            paramList.Add(txtZipCode.Text);
            paramList.Add(rdoEnabled.Checked ? 1 : 0);

            DB.ExecuteSQL(sql, paramList);
            this.Response.Write("<script>alert('职位发布申请成功');location.href='CompanyPublish.aspx'</script>");

            SendJobInfoSms(txtJobName.Text);
        }
        catch (Exception ex)
        {
            throw ex;
        }

    }


    private String getSubString(String field, int i)
    {
        String ret = "";
        if (field.Trim() != "" && field.IndexOf('-') > 0)
        {
            String[] array = field.Split('-');
            ret = array[i];
            if (array[i].Trim() == "" && i > 0)
                ret = array[i - 1];
        }
        return ret;
    }

    private void InitDepartment()
    {
        String sql = "SELECT deptId,deptName FROM company_dept WHERE comid=@0 ";
        DataTable department = DB.GetDataSet(sql, txtComId.Value).Tables[0];
        if (department.Rows.Count > 0)
        {
            for (int i = 0; i < department.Rows.Count; ++i)
                cmbDepartment.Items.Add(new ListItem(department.Rows[i]["deptName"].ToString(), department.Rows[i]["deptid"].ToString()));
        }
    }

    private void IniMonthDay()
    {
        int curYear = DateTime.Now.Year;
        for (int i = 0; i < 20; ++i)
        {
            cmbEndYear.Items.Add(Convert.ToString(curYear + i));
        }

        for (int i = 1; i < 13; ++i)
        {
            cmbEndMonth.Items.Add(i.ToString());
        }

        for (int i = 1; i < 32; ++i)
        {
            cmbEndDay.Items.Add(i.ToString());
        }
    }

    private int Type
    {
        get
        {
            int ret = 0;
            if (rdoFullTime.Checked)
                ret = 0;
            if (rdoPartTime.Checked)
                ret = 1;
            if (rdoOther.Checked)
                ret = 2;
            return ret;
        }
        set
        {
            switch (value)
            {
                case 0:
                    rdoFullTime.Checked = true;
                    break;
                case 1:
                    rdoPartTime.Checked = true;
                    break;
                case 2:
                    rdoOther.Checked = true;
                    break;
            }
        }
    }

    public void SendJobInfoSms(String jobname)
    {
        DealPersonFromWeb(jobname);
        DealPersonFromSms(jobname);
    }

    protected void DealPersonFromWeb(String jobname)
    {
        String sql = "select top 1000 a.PerId, b.UserName, b.MobilePhone "+
                    "from personal_will a left join personal_base b on b.PerId = a.PerId "+
                    "where a.JobName1 like @0 or "+
                    "      a.JobName2 like @0 or " +
                    "       a.JobName3 like @0 or " +
                    "       a.JobName4 like @0 or " +
                    "       a.JobName5 like @0";

        DataSet ds = DB.GetDataSet(sql, "%" + jobname+"%");
        for (int i = 0; i < ds.Tables[0].Rows.Count; i++)
        {
            DataRow row = ds.Tables[0].Rows[i];
            sendSms(row["UserName"].ToString(), Session["CompanyName"].ToString() + "招聘" + jobname, "System");
        }
    }

    protected void DealPersonFromSms(String jobname)
    {
        String sql = "select top 1000 MobilePhone from sms_user where intension_position like @0 ";

        DataSet ds = DB.GetDataSet(sql, "%" + jobname + "%");
        for (int i = 0; i < ds.Tables[0].Rows.Count; i++)
        {
            DataRow row = ds.Tables[0].Rows[i];
            sendSms(row["MobilePhone"].ToString(), Session["CompanyName"].ToString() + "招聘" + jobname, "System");
        }
    }

    protected void sendSms(String mobile, String content, string userName)
    {
        ArrayList listParam = new ArrayList();
        String sql = "INSERT INTO send_sms(Mobilephone, MessageContent, UserName) " +
                          "VALUES(@0,@1,@2)";

        listParam.Add(mobile);
        listParam.Add(content);
        listParam.Add(userName);

        DB.ExecuteSQL(sql, listParam);
    }
}
