﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Company_InviteMail : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Request.QueryString["param"] != null)
            {
                txtPerId.Value = Convert.ToString(Request.QueryString["param"]);
                lblRealName.Text=txtRealName.Value = Convert.ToString(Request.QueryString["realname"]);
                loadData();
            }
        }
    }

    private void loadData()
    {
        const String enter = "\r\n";
        String content = "尊敬的先生/女士：" + enter + enter;
        content += "    您好！" + enter;
        content += "我们是{0}，我们在人才网上搜索到您的简历，" +
                   "您的条件基本符合我公司的招聘岗位要求，如果方便的话请您到公司来参加面试." +enter;
        content += "时间：" + Common.ToYMD(DateTime.Now) + " 9:30" + enter;
        content += "联系人：{1}" + enter;
        content += "电话：{2}" +enter;
        content += "邮件：{3}" + enter;
        content += "通讯地址：{4}" + enter + enter;
        content += "--{5}" + enter;
        content += "{6}" + enter;
        String comid = Convert.ToString(Session["comid"]);
        if (comid.Trim() == "")
        {
            Response.Write("<script>alert('请先登录，再执行操作');window.close();</script>");
            return;
        }
        String sql = String.Empty;
        sql = "SELECT jobid,jobname FROM jobs WHERE comid=@0 ORDER BY jobid";
        sql += ";SELECT companyname,contact_person,contact_phone,contact_fax,email,address " +
                                   "FROM company_base WHERE comid=@0";
        DataSet baseInfor = DB.GetDataSet(sql, comid);
        DataTable jobs = baseInfor.Tables[0];
        DataTable company = baseInfor.Tables[1];

        if (jobs.Rows.Count > 0)
        {
            cmbJobName.Items.Clear();
            for (int i = 0; i < jobs.Rows.Count; ++i)
            { 
                cmbJobName.Items.Add(new ListItem(Convert.ToString(jobs.Rows[i]["jobname"]),Convert.ToString(jobs.Rows[i]["jobId"])));
            }
        }
        else
        {
            Response.Write("<script>alert('请先发布职位，再执行操作');window.close();</script>");
            return;
        }

        if (company.Rows.Count > 0)
        {
            DataRow row = company.Rows[0];
            content = String.Format(content,row["companyname"],
                                            row["contact_person"],
                                            row["contact_phone"],
                                            row["email"],
                                            row["address"],
                                            row["companyname"],
                                            Common.ToYMD(DateTime.Now));
            txtContent.Text = content;
        }

    }

    protected void btnSend_Click(object sender, EventArgs e)
    {
        String comid = Convert.ToString(Session["comid"]);
        if (comid.Trim() == "")
        {
            Response.Write("<script>alert('请先登录，再执行操作');window.close();</script>");
            return;
        }

        String sql = "INSERT INTO personal_inbox(perid,jobid,comid,adddate,isread,title,content) "+
                     "VALUES( @0,@1,@2,GETDATE(),0,@3,@4)";
        ArrayList paramList = new ArrayList();
        paramList.Add( txtPerId.Value);
        paramList.Add( cmbJobName.SelectedItem.Value);
        paramList.Add( comid);
        paramList.Add( txtTitle.Text);
        paramList.Add( txtContent.Text);

        DB.ExecuteSQL(sql);
        Response.Write("<script>alert('发送面试邀请成功');window.close();</script>");
    }
}
