﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Company_PersonDB : System.Web.UI.Page
{
    const Int32 rows = 20;
    protected void Page_Load(object sender, EventArgs e)
    {
        if (Session["comid"] == null)
        {
            Response.Redirect("~/include/Register_Company.aspx?mode=0");
            return;
        }

        String comid = Session["comid"].ToString();
        getRecordCount(comid);
        if (!IsPostBack)
        {
            txtPageIndex.Value = "1";
            loadData(comid, Convert.ToInt32(txtPageIndex.Value));
        }
    }

    private void loadData(String comid, int pageNo)
    {
        if (pageNo == 0)
            pageNo = 1;

        String headSql = String.Format(" SELECT TOP {0} a.id,a.perid,a.adddate,b.realname,"+
                                       "CASE b.sex WHEN 0 THEN '女' WHEN 1 THEN '男' ELSE '保密' END sex,"+
                                       "b.Education,c.jobName1 jobwill" , rows);
        String whereSql = " FROM company_db a LEFT JOIN personal_info b ON a.perid = b.perid " +
                                        " LEFT JOIN personal_will c ON c.perid=a.perid " +
                                        " WHERE a.comid = @0 ";
        String inSql = String.Format(" AND a.ID NOT IN (SELECT TOP {0} a.ID {1})", (pageNo - 1) * rows, whereSql);
        String sql = headSql + whereSql + inSql;
        DataTable inbox = DB.GetDataSet(sql, comid).Tables[0];
        grdPersonDb.DataSource = inbox;
        grdPersonDb.DataBind();
        lblCurrent.Text = String.Format("第{0}页", pageNo);
    }


    private void getRecordCount(String comid)
    {
        String whereSql = " FROM company_db a LEFT JOIN personal_info b ON a.perid = b.perid " +
                                        " LEFT JOIN personal_will c ON c.perid=a.perid " +
                                        " WHERE a.comid = @0 ";
        String sql = "SELECT COUNT(a.id) cnt " + whereSql;
        DataTable inbox = DB.GetDataSet(sql, comid).Tables[0];
        Int32 recCnt = Convert.ToInt32(inbox.Rows[0]["cnt"].ToString());
        txtPagesCnt.Value = Common.getPageCnt(recCnt, rows).ToString();
        lblRecCount.Text = recCnt.ToString();
        if (txtPagesCnt.Value == "0")
            lblCurrent.Text = "无记录";
        else
            lblCurrent.Text = String.Format("第{0}页", txtPageIndex.Value);
    }

    protected void btnFirst_Click(object sender, EventArgs e)
    {
        txtPageIndex.Value = "1";
        loadData(Session["comid"].ToString(), Convert.ToInt32(txtPageIndex.Value));

    }

    protected void btnPer_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtPageIndex.Value);
        if (index - 1 < 1)
            txtPageIndex.Value = "1";
        else
            txtPageIndex.Value = Convert.ToString(--index);
        loadData(Session["comid"].ToString(), Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnNext_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtPageIndex.Value);
        if (index + 1 > Convert.ToInt32(txtPagesCnt.Value))
            txtPageIndex.Value = txtPagesCnt.Value;
        else
            txtPageIndex.Value = Convert.ToString(++index);
        loadData(Session["comid"].ToString(), Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnLast_Click(object sender, EventArgs e)
    {
        txtPageIndex.Value = txtPagesCnt.Value;
        loadData(Session["comid"].ToString(), Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnGoto_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtGo.Text);
        txtPageIndex.Value = txtGo.Text;
        if (index < 1)
            txtPageIndex.Value = "1";
        if (index > Convert.ToInt32(txtPagesCnt.Value))
            txtPageIndex.Value = txtPagesCnt.Value;

        txtGo.Text = txtPageIndex.Value;
        loadData(Session["comid"].ToString(), Convert.ToInt32(txtPageIndex.Value));

    }

    protected void btnDelete_Click(object sender, EventArgs e)
    {
        CheckBox chkSelect;
        int index = 0;
        String deleteId = "";
        ArrayList paramList = new ArrayList();

        try
        {
            for (int i = 0; i < grdPersonDb.Rows.Count; i++)
            {
                chkSelect = (CheckBox)grdPersonDb.Rows[i].FindControl("chkSelect");
                if (chkSelect.Checked)
                {
                    deleteId +=   string.Format( "@{0},",index);
                    paramList.Add(((Label)grdPersonDb.Rows[i].FindControl("lblId")).Text); 
                    index++;
                }
            }
            if (index > 0)
            {
                deleteId = deleteId.Substring(0, deleteId.Length - 1);
                String sql = String.Format("DELETE FROM company_db WHERE id in ({0})", deleteId);
                DB.ExecuteSQL(sql, paramList);

                String comid = Session["comid"].ToString();
                getRecordCount(comid);
                if (Convert.ToInt32(txtPageIndex.Value) > Convert.ToInt32(txtPagesCnt.Value))
                    txtPageIndex.Value = txtPagesCnt.Value;
                loadData(comid, Convert.ToInt32(txtPageIndex.Value));



            }
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
        }
    }
}
