﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

public partial class Company_Register2 : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            txtUserName.Value = Request["txtUserName"].ToString();
            txtUserPwd.Value = Request["txtUserPwd"].ToString();
            txtEmail2.Text = txtEmail.Value = txtEmail.Value = Request["txtEmail"].ToString();

            IniMonthDay();
        }
    }
    protected void btnOk_Click(object sender, EventArgs e)
    {
        String sql = String.Empty;
        ArrayList paramList = new ArrayList();

        String comid = generateId();

        SqlConnection conn = null;
        SqlTransaction trans = null;
        bool transBegin = false;
        try
        {
            conn = DB.GetConnection();

            SqlCommand cmd = new SqlCommand();
            cmd.Connection = conn;
            cmd.CommandType = CommandType.Text;
            trans = conn.BeginTransaction();
            cmd.Transaction = trans;
            transBegin = true;

            sql = "SELECT * FROM company_base where comid = @0 OR username = @1";
            SqlParameter[] parameters = new SqlParameter[2];
            parameters[0] = new SqlParameter();
            parameters[0].ParameterName = "@0";
            parameters[0].Value = comid;

            parameters[1] = new SqlParameter();
            parameters[1].ParameterName = "@1";
            parameters[1].Value = txtUserName.Value;

            if (DB.GetDataSet(conn, sql, trans, parameters).Tables[0].Rows.Count > 0)
            {
                if (transBegin) trans.Rollback();
                transBegin = false;
                this.Response.Write("<script>alert('已存在相同的用户名称，请更换用户名');window.history.back(-1)</script>");
                return;
            }
            else
            {
                sql = "INSERT INTO company_base(comid,username,password,companyname,license," +
                      "industry,type,found_year,found_month,found_day,reg_capital,reg_currency," +
                      "workers,province,city,memo,contact_phone,contact_person,contact_phone_isshow," +
                      "contact_fax,email,email_isshow,website,zipcode,address,Last_ip,reg_date," +
                      "last_date,last_update_date,view_clicks,IsRecommend,IsVerified ) " +
                      "VALUES(@0,@1,@2,@3,@4,@5,@6,@7,@8,@9,@10,@11,@12,@13,@14,@15,@16," +
                      "@17,@18,@19,@20,@21,@22,@23,@24,@25,GETDATE(),GETDATE(),GETDATE(),0,0,0)";

                paramList.Add(comid);
                paramList.Add(txtUserName.Value);
                paramList.Add(Common.Md5(txtUserPwd.Value));
                paramList.Add(txtCompanyName.Text);
                paramList.Add(txtLicense.Text);
                paramList.Add(cmbIndustry.SelectedItem.Text);
                paramList.Add(cmbType.SelectedItem.Text);
                paramList.Add(txtFoundYear.Text);
                paramList.Add(cmbFoundMonth.SelectedItem.Text);
                paramList.Add(cmbFoundDay.SelectedItem.Text);
                paramList.Add(Convert.ToInt32(txtRegCapital.Text));
                paramList.Add(Convert.ToInt32(cmbRegCurrency.SelectedItem.Value));
                paramList.Add(Convert.ToInt32(cmbWorkers.SelectedItem.Value));
                paramList.Add(txtProvince.Text);
                paramList.Add(txtCity.Text);
                paramList.Add(txtMemo.Text);
                paramList.Add(txtPhone.Text);
                paramList.Add(txtContactPerson.Text);
                paramList.Add(chkPhoneIsShow.Checked ? 1 : 0);
                paramList.Add(txtFax.Text);
                paramList.Add(txtEmail2.Text);
                paramList.Add(chkEmailIsShow.Checked ? 1 : 0);
                paramList.Add(txtWebsite.Text);
                paramList.Add(txtZipCode.Text);
                paramList.Add(txtAddress.Text);
                paramList.Add(Request.ServerVariables.Get("REMOTE_ADDR").ToString());

                parameters = new SqlParameter[paramList.Count];

                for (int i = 0; i < paramList.Count; ++i)
                {
                    parameters[i] = new SqlParameter();
                    parameters[i].ParameterName = "@" + i.ToString();
                    parameters[i].Value = paramList[i];
                }

                cmd.CommandText = sql;
                DB.ExecuteSQL(cmd, parameters);

                trans.Commit();
                transBegin = false;
                Session["comid"] = comid;
                Response.Redirect("Register3.aspx");
            }

        }
        catch (Exception ex)
        {
            if (transBegin)
                trans.Rollback();
            Response.Write(ex.Message);
            Response.End();
        }
        finally
        {
            if (conn != null && conn.State == ConnectionState.Open)
                conn.Close();
        }
    }

    private string generateId()
    {
        long i = 1;
        foreach (byte b in Guid.NewGuid().ToByteArray())
        {
            i *= ((int)b + 1);
        }
        return string.Format("{0:x}", i - DateTime.Now.Ticks);
    }

    private void IniMonthDay()
    {
        for (int i = 1; i < 13; ++i)
        {
            cmbFoundMonth.Items.Add(i.ToString());
        }

        for (int i = 1; i < 32; ++i)
        {
            cmbFoundDay.Items.Add(i.ToString());
        }
    }
}
