﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Company_SearchList : System.Web.UI.Page
{
    const Int32 rows = 20;
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Session["search"] != null)
            {
                saveCondition(Session["search"]);
                //getRecordCount();
                txtPageIndex.Value = "1";
                loadData(Convert.ToInt32(txtPageIndex.Value));
            }
        }
    }

    private void saveCondition(object sessionObj)
    {
        comCondition sc = (comCondition)sessionObj;
        txtJobClass.Value = sc.JobClass;
        txtJobClassValue.Value = sc.JobClassValue;
        txtJobArea.Value = sc.JobArea;
        txtJobAreaValue.Value = sc.JobAreaValue;
        txtEducation.Value  = sc.Education;
        txtSex.Value = sc.Sex.ToString();
        txtPublishDate.Value = sc.LastUpdateDate; 
    }

    private void loadData(int pageNo)
    {
        try
        {
            if (pageNo == 0)
                pageNo = 1;
            ArrayList paramList = new ArrayList();
            int paramNUM = 0;

            String sql = String.Format("SELECT top {0} a.perid, b.realname, " +
                                       "CASE b.sex WHEN 0 THEN '女' WHEN 1 THEN '男' ELSE '保密' END sex, b.education, " +
                                       "c.JobClass1 jobclass, CONVERT(VARCHAR(10),a.LastUpdate_Date,121) publishDate " ,rows);
            
            String where = "WHERE  a.IsVerified=1 ";
            //职位类别
            if (txtJobClass.Value != "不限" && txtJobClass.Value.Trim() != "")
            {
                where += String.Format("AND (c.jobclass1 LIKE @{0} OR " +
                                        "c.jobclass2 LIKE @{0} OR " +
                                        "c.jobclass3 LIKE @{0} OR " +
                                        "c.jobclass4 LIKE @{0} OR " +
                                        "c.jobclass5 LIKE @{0} ) ", paramNUM);
                paramList.Add( "%" + txtJobClassValue.Value + "%");
                paramNUM ++;
            }
            //工作地区
            if (txtJobArea.Value != "不限" && txtJobArea.Value.Trim() != "")
            {
                where += String.Format("AND (c.workArea1 LIKE @{0} OR " +
                                            "c.workArea2 LIKE @{0} OR " +
                                            "c.workArea3 LIKE @{0} OR " +
                                            "c.workArea4 LIKE @{0} OR " +
                                            "c.workArea5 LIKE @{0} ) ", paramNUM);
                paramList.Add("%" + txtJobAreaValue.Value + "%");
                paramNUM++;
            }
            //教育程度
            if (txtEducation.Value.Trim() != "无" && txtEducation.Value.Trim() != "")
            {
                where += String.Format("AND b.education =@{0} ", paramNUM);
                paramList.Add( txtEducation.Value );
                paramNUM++;
            }
            //性别
            if (txtSex.Value.Trim() != "2" && txtSex.Value.Trim() != "0" && txtSex.Value.Trim() != "")
            {
                where += String.Format("AND b.Sex =@{0} ", paramNUM);
                paramList.Add( txtSex.Value );
                paramNUM++;
            }
            //工作类型
            if (txtPublishDate.Value.Trim() != "0" && txtPublishDate.Value.Trim() != "")
            {
                where += String.Format("AND DATEDIFF(dd,a.LastUpdate_Date,GETDATE()) < @{0} ", paramNUM);
                paramList.Add(txtPublishDate.Value);
                paramNUM++;
            }

            String whereSql = String.Format("FROM personal_base a LEFT JOIN " +
                                       "personal_info b ON a.perid = b.perid LEFT JOIN " +
                                       "personal_will c ON a.perid = c.perid {0} ", where);
            
            String ordSql = "ORDER BY a.lastUpdate_Date DESC ";

            String inSql = String.Format(" AND a.perid NOT IN (SELECT TOP {0} a.perid {1} {2})", (pageNo - 1) * rows, whereSql, ordSql);
            sql = sql + whereSql + inSql + ordSql;

            sql = String.Format("SELECT COUNT(a.perid) cnt  " +
                                   "FROM personal_base a LEFT JOIN " +
                                   "personal_info b ON a.perid = b.perid LEFT JOIN " +
                                   "personal_will c ON a.perid = c.perid {0} ", where)+
                   ";"+sql;
            DataSet ds = DB.GetDataSet(sql, paramList);

            DataTable inbox = ds.Tables[0];
            Int32 recCnt = Convert.ToInt32(inbox.Rows[0]["cnt"].ToString());
            txtPagesCnt.Value = Common.getPageCnt(recCnt, rows).ToString();
            lblRecCnt2.Text = lblRecCnt.Text = recCnt.ToString();
            if (txtPagesCnt.Value == "0")
            {
                lblCurrent2.Text = lblCurrent.Text = "无记录";
                lblPageIndex2.Text = lblPageIndex.Text = "1";
            }
            else
            {
                lblCurrent2.Text = lblCurrent.Text = String.Format("第{0}页", txtPageIndex.Value);
                lblPageIndex2.Text = lblPageIndex.Text = txtPagesCnt.Value;
            }
            lblPageCnt2.Text = lblPageCnt.Text = txtPagesCnt.Value;

            DataTable jobs = ds.Tables[1];
            grdPersons.DataSource = jobs;
            grdPersons.DataBind();
            lblCurrent2.Text = lblCurrent.Text = pageNo.ToString();
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }

    //private void getRecordCount()
    //{
    //    String sql = String.Format("SELECT COUNT(a.perid) cnt  " +
    //                               "FROM personal_base a LEFT JOIN " +
    //                               "personal_info b ON a.perid = b.perid LEFT JOIN " +
    //                               "personal_will c ON a.perid = c.perid {0} ", getWhere());
    //    DataTable inbox = DB.GetDataSet(sql).Tables[0];
    //    Int32 recCnt = Convert.ToInt32(inbox.Rows[0]["cnt"].ToString());
    //    txtPagesCnt.Value = Common.getPageCnt(recCnt, rows).ToString();
    //    lblRecCnt2.Text=lblRecCnt.Text = recCnt.ToString();
    //    if (txtPagesCnt.Value == "0")
    //    {
    //        lblCurrent2.Text = lblCurrent.Text = "无记录";
    //        lblPageIndex2.Text = lblPageIndex.Text = "1";
    //    }
    //    else
    //    {
    //        lblCurrent2.Text = lblCurrent.Text = String.Format("第{0}页", txtPageIndex.Value);
    //        lblPageIndex2.Text = lblPageIndex.Text = txtPagesCnt.Value;
    //    }
    //    lblPageCnt2.Text = lblPageCnt.Text = txtPagesCnt.Value;
    //}

    //private String getWhere()
    //{
    //    String where = "WHERE  a.IsVerified=1 ";
    //    //职位类别
    //    if (txtJobClass.Value != "不限" && txtJobClass.Value.Trim() != "")
    //    {
    //            where += String.Format("AND (c.jobclass1 LIKE '%{0}%' OR " +
    //                                    "c.jobclass2 LIKE '%{0}%' OR " +
    //                                    "c.jobclass3 LIKE '%{0}%' OR " +
    //                                    "c.jobclass4 LIKE '%{0}%' OR " +
    //                                    "c.jobclass5 LIKE '%{0}%' ) ", txtJobClassValue.Value);
    //    }
    //    //工作地区
    //    if (txtJobArea.Value != "不限" && txtJobArea.Value.Trim() != "")
    //    {
    //        where += String.Format("AND (c.workArea1 LIKE '%{0}%' OR " +
    //                                    "c.workArea2 LIKE '%{0}%' OR " +
    //                                    "c.workArea3 LIKE '%{0}%' OR " +
    //                                    "c.workArea4 LIKE '%{0}%' OR " +
    //                                    "c.workArea5 LIKE '%{0}%' ) ", txtJobAreaValue.Value);
    //    }
    //    //教育程度
    //    if (txtEducation.Value.Trim() != "无" && txtEducation.Value.Trim() != "")
    //        where += String.Format("AND b.education ='{0}' ", txtEducation.Value);
    //    //性别
    //    if (txtSex.Value.Trim() != "2" && txtSex.Value.Trim() != "0" && txtSex.Value.Trim() != "")
    //        where += String.Format("AND b.Sex ={0} ", txtSex.Value);
    //    //工作类型
    //    if (txtPublishDate.Value.Trim() != "0" && txtPublishDate.Value.Trim() != "")
    //        where += String.Format("AND DATEDIFF(dd,a.LastUpdate_Date,GETDATE()) <{0} ", txtPublishDate.Value);
        
    //    return where;
    //}

    protected void btnFirst_Click(object sender, EventArgs e)
    {
        txtPageIndex.Value = "1";
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnPer_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtPageIndex.Value);
        if (index - 1 < 1)
            txtPageIndex.Value = "1";
        else
            txtPageIndex.Value = Convert.ToString(--index);
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnNext_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtPageIndex.Value);
        if (index + 1 > Convert.ToInt32(txtPagesCnt.Value))
            txtPageIndex.Value = txtPagesCnt.Value;
        else
            txtPageIndex.Value = Convert.ToString(++index);
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnLast_Click(object sender, EventArgs e)
    {
        txtPageIndex.Value = txtPagesCnt.Value;
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnGoto_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtGo.Text);
        txtPageIndex.Value = txtGo.Text;
        if (index < 1)
            txtPageIndex.Value = "1";
        if (index > Convert.ToInt32(txtPagesCnt.Value))
            txtPageIndex.Value = txtPagesCnt.Value;

        txtGo.Text = txtPageIndex.Value;
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }
    protected void btnGoto2_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtGo2.Text);
        txtPageIndex.Value = txtGo2.Text;
        if (index < 1)
            txtPageIndex.Value = "1";
        if (index > Convert.ToInt32(txtPagesCnt.Value))
            txtPageIndex.Value = txtPagesCnt.Value;

        txtGo2.Text = txtPageIndex.Value;
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }
    protected void grdPersons_RowEditing(object sender, GridViewEditEventArgs e)
    {
        try
        {
            int rowIndex = e.NewEditIndex;
            String perId = ((Label)grdPersons.Rows[rowIndex].FindControl("lblPerId")).Text;
            Response.Write("<Script>window.open('../Person/Resume/ResumeMode1.aspx?param=" + perId + "')</script>");

        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
        }
    }

    public String handleWill(Object field)
    {
        String ret = "";
        ret = Convert.ToString(field);
        if (ret.Trim() == "")
            ret = "---";
        else
            ret = ret.Split('|')[0];
        return ret;

    }
}
