﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

public partial class wh_CompanyDepartment : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Session["comid"] != null)
            {
                InitForm();
            }else{
                Response.Redirect("index.aspx");
            }
        }
    }

    private void InitForm()
    {
        txtComId.Value = Session["comid"].ToString();
        LoadData(txtComId.Value);
    }

    private void LoadData(String comid)
    {
        //*防止SQL注入
        //if (!DB.CheckParams(new object[] { comid }))
        //{
        //    Response.Redirect("ErrorSQLZR.aspx");
        //    return;
        //}


        String sql = "SELECT deptid,deptname,dept_contact,email FROM company_dept WHERE comid = @0 ORDER BY deptid";

        DataTable department = DB.GetDataSet(sql,comid).Tables[0];

        grdDepartment.DataSource = department;
        grdDepartment.DataBind();
    }

    protected void btnOk_Click(object sender, EventArgs e)
    {
        try
        {
            //*防止SQL注入
            //if (!DB.CheckParams(new object[] { txtDeptId.Value, txtComId.Value }))
            //{
            //    Response.Redirect("ErrorSQLZR.aspx");
            //    return;
            //}


            ArrayList paramList = new ArrayList();
            String sql = string.Empty;
            if (txtDeptId.Value.Trim() != "")
            {
                sql = "UPDATE company_dept SET deptname=@2,dept_contact=@3,email=@4 WHERE deptid=@1";
                
            }
            else
            {
                sql = "INSERT INTO company_dept(comid,deptname,dept_contact,email) " +
                             "VALUES(@0,@2,@3,@4)";
                
            }
            paramList.Add(txtComId.Value);
            paramList.Add(txtDeptId.Value);
            paramList.Add(txtDeptName.Text);
            paramList.Add(txtDeptContact.Text);
            paramList.Add(txtEmail.Text);

            sql += ";UPDATE company_base SET last_update_date = GETDATE() WHERE comid = @0";

            DB.ExecuteSQL(sql, paramList);
            clearData();
            LoadData(txtComId.Value);

            txtDeptId.Value = "";
            Session["comid"] = txtComId.Value;



        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }

    private void clearData()
    {
        txtDeptName.Text = "";
        txtDeptContact.Text = "";
        txtEmail.Text = "";
    }


    protected void grdDepartment_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        String deptid = ((Label)grdDepartment.Rows[e.RowIndex].FindControl("lblDeptId")).Text;
        DeleteItem(deptid);
    }


    private void DeleteItem(String deptid)
    {
        try
        {
            //*防止SQL注入
            //if (!DB.CheckParams(new object[] { deptid }))
            //{
            //    Response.Redirect("ErrorSQLZR.aspx");
            //    return;
            //}

            String sql = "DELETE FROM company_dept WHERE deptid = @0";
            DB.ExecuteSQL(sql, deptid);
            clearData();
            LoadData(txtComId.Value);
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }

    protected void grdDepartment_RowEditing(object sender, GridViewEditEventArgs e)
    {
        String deptid = ((Label)grdDepartment.Rows[e.NewEditIndex].FindControl("lblDeptId")).Text;
        UpdateItem(deptid);
    }

    private void UpdateItem(String deptid)
    {
        try
        {
            //*防止SQL注入
            //if (!DB.CheckParams(new object[] { deptid }))
            //{
            //    Response.Redirect("ErrorSQLZR.aspx");
            //    return;
            //}

            String sql = "SELECT * FROM company_dept WHERE deptid = @0";
            DataTable work = DB.GetDataSet(sql, deptid).Tables[0];
            if (work.Rows.Count > 0)
            {
                DataRow row = work.Rows[0];
                txtDeptName.Text = row["deptName"].ToString();
                txtDeptContact.Text = Convert.ToString(row["dept_Contact"]);
                txtEmail.Text = Convert.ToString(row["email"]);
                txtDeptId.Value = deptid;
            }
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }
}
