﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Include_Login : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        String userName = Request.Form["txtUserName"].ToString();
        String userPwd = Request.Form["txtUserPwd"].ToString();
        String userType = Request.Form["cmbLoginType"].ToString();

        if (!DB.CheckParams(new object[] { userName, userPwd }))
        {
            return;
        }

        if (userType == "person")
            PersonLogin(userName, userPwd);
        if (userType == "company")
            companyLogin(userName, userPwd);
        if (userType == "admin")
            adminLogin(userName, userPwd);
    }

    private void adminLogin(String name, String password)
    {
        try
        {
            String userName = name;
            String userPwd = Common.Md5(password);

            String sql = "SELECT adminid,password from admin_base where username=@0";
            object[] parameters = new object[1];
            parameters[0] = userName;

            DataTable user = DB.GetDataSet(sql, parameters).Tables[0];
            if (user.Rows.Count > 0)
            {
                if (userPwd == user.Rows[0]["password"].ToString())
                {
                    Session["adminid"] = user.Rows[0]["adminid"].ToString();
                    Session["username"] = userName;
                    Response.Redirect("~/admin/AdminCenter.aspx");
                    return;
                }
            }

            Response.Redirect("~/admin/default.aspx?mode=1");
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }

    private void companyLogin(String name, String password)
    {
        try
        {
            String userName = name;
            String userPwd = Common.Md5(password);

            String sql = "SELECT comid,password,CompanyName from company_base where username=@0";
            object[] parameters = new object[1];
            parameters[0] = userName;

            DataTable user = DB.GetDataSet(sql, parameters).Tables[0];
            if (user.Rows.Count > 0)
            {
                if (userPwd == user.Rows[0]["password"].ToString())
                {


                    Session["comid"] = user.Rows[0]["comid"].ToString();
                    Session["username"] = userName;
                    Session["CompanyName"] = user.Rows[0]["CompanyName"].ToString();
                    Session["perid"] = null;
                    if (!isBackRefUrl())
                        Response.Redirect("~/CompanyCenter.aspx");
                    return;
                }
            }

            Response.Redirect("~/Include/Register_Company.aspx?mode=1");
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }

    private void PersonLogin(String name, String password)
    {
        try
        {
            String userName = name;
            String userPwd = Common.Md5(password);

            String sql = "SELECT perid,password from personal_base where username=@0";
            object[] parameters = new object[1];
            parameters[0] = userName;

            DataTable user = DB.GetDataSet(sql, parameters).Tables[0];
            if (user.Rows.Count > 0)
            {
                if (userPwd == user.Rows[0]["password"].ToString())
                {
                    Session["perid"] = user.Rows[0]["perid"].ToString();
                    Session["username"] = userName;
                    Session["comid"] = null;
                    if (!isBackRefUrl())
                        Response.Redirect("~/PersonCenter.aspx");
                    return;
                }
            }

            Response.Redirect("~/Include/Register_Person.aspx?mode=1");
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }

    }

    private bool isBackRefUrl()
    {
        bool ret = false;
        if (Request.QueryString["refurl"] != null && Convert.ToString(Request.QueryString["refurl"]).Trim() != "")
        {
            String refurl = Request.QueryString["refurl"];
            if (!refurl.Contains("Default.aspx") && !refurl.Contains("Register_Company.aspx") && !refurl.Contains("Register_Person.aspx"))
            {
                Response.Redirect(refurl);
                ret = true;
            }
        }

        return ret;
    }
}
