﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Person_Register : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Request.QueryString["refurl"] != null && Convert.ToString(Request.QueryString["refurl"]).Trim() != "")
                txtRefUrl.Value = Request.QueryString["refurl"].ToString();
            else
                txtRefUrl.Value = Convert.ToString(Request.UrlReferrer);
            if (Request.QueryString["mode"]!=null && Request.QueryString["mode"].ToString() == "1")
                lblTip.Text = "用户名或密码错误，请重新输入";


            // 热门职位
            String sql = "SELECT TOP 30 JobId, JobName, RIGHT(CONVERT(VARCHAR(10),LastUpdate_Date,121),5) LastUpdate_Date, CompanyName, Number, IsRecommend " +
                   "FROM jobs,company_base WHERE jobs.comid=company_base.comid AND jobs.IsVerified=1 AND company_base.IsVerified=1 AND IsHot = 1 AND isActive=1 " +
                   "ORDER BY LastUpdate_Date DESC";

            // 最新企业
            sql += ";SELECT TOP 24 a.comid,a.username,a.companyname,a.contact_person,a.contact_phone," +
                        "CASE a.IsVerified WHEN 0 THEN '未审核' WHEN 1 THEN '已审核' END isverified," +
                        "CONVERT(VARCHAR(10),a.reg_date,120) reg_date FROM company_base a ORDER BY a.reg_date DESC";

            DataSet dataset = DB.GetDataSet(sql);
            lstJobs.DataSource = dataset.Tables[0].DefaultView;
            lstJobs.DataBind();

            lstCompany.DataSource = dataset.Tables[1].DefaultView;
            lstCompany.DataBind();
        }
    }
    protected void btnLogin_Click(object sender, EventArgs e)
    {
        Server.Transfer("~/include/login.aspx?refurl=" + txtRefUrl.Value);
    }
    protected void btnSearch_Click(object sender, EventArgs e)
    {
        ArrayList list = new ArrayList();
        for (int i = 0; i < Request.Form.Count; ++i)
        {
            list.Add(Request.Form.GetKey(i).ToString() + ":" + Request.Form[i].ToString());
        }

        String issueDate = Request.Form["issuedate"].ToString();
        String jobType = Request.Form["funtype_big"].ToString();
        String jobTypeValue = Request.Form["funtype"].ToString();
        jobTypeValue = jobTypeValue == "（全部）不限" ? "" : jobTypeValue;

        if (jobType == "不限")
        {
            jobType = "0-0";
            jobTypeValue = "";
        }
        else
        {
            if (jobTypeValue.Contains("（全部）") && jobTypeValue.Contains("类"))
            {
                jobTypeValue = jobTypeValue.Substring(4, jobTypeValue.Length - 5);
                jobType = jobTypeValue + "-不限";
            }
            else
            {
                jobTypeValue = jobType + "-" + jobTypeValue;
            }
        }
        String workArea = Request.Form["btnSltArea1"].ToString();
        String key = Request.Form["key"].ToString();
        key = key == "请输入关键字" ? "" : key;

        Condition sc = new Condition();
        sc.JobClass = jobType;
        sc.JobClassValue = jobTypeValue;
        sc.PublishDate = Convert.ToInt32(issueDate);
        sc.Keyword = key;
        Session["search"] = sc;
        Response.Write("<Script>window.open('../person/SearchList.aspx')</script>");
    }

    protected string Left(object s, int length)
    {
        try
        {
            string ret;

            if (s.ToString().Trim() == "")
                return "---";
            if (s.ToString().Length > length)
            {
                ret = s.ToString();
                ret = ret.Substring(0, length) + "...";
            }
            else
            {
                return s.ToString();
            }
            return ret;
        }
        catch (Exception ex)
        {
            throw ex;
        }
    }
}
