﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Admin_news_view : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (Request.QueryString["newsid"] == null)
        {
            Response.Write("没有相关的信息！");
        }
        else
        {
            loadData(Request.QueryString["newsid"].ToString());
        }
    }

    private void loadData(String newsid)
    {
        try
        {
            if (!DB.CheckParams(new object[] { newsid }))
            {
                return;
            }

            String sql = "SELECT a.*,b.typename FROM news_info a LEFT JOIN news_type b ON a.typeid=b.typeid WHERE newsid=@0";
            DataTable news = DB.GetDataSet(sql, newsid).Tables[0];

            if (news.Rows.Count > 0)
            {
                DataRow row = news.Rows[0];
                lblTitle.Text = Convert.ToString(row["title"]);
                lblContent.Text = Convert.ToString(row["Content"]).Replace("\r\n", "<BR>");
                lblTypeName.Text = Convert.ToString(row["typename"]);
                lblAuthor.Text = Convert.ToString(row["author"]);
                lblNewsSource.Text = Convert.ToString(row["newsSource"]);
                lblAddDate.Text = Convert.ToString(row["adddate"]);
            }

        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }
}
