using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Include_news : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!this.IsPostBack)
        {
            string typeId = this.Request.QueryString["typeId"];
            if (typeId != null && typeId.CompareTo("") != 0)
            {
                LoadData(typeId);
            }
        }
    }

    public void LoadData(string typeId)
    {
        try
        {
            if (!DB.CheckParams(new object[] { typeId }))
            {
                return;
            }

            //
            String sql = "SELECT TOP 200 NewsID, Title, Author, AddDate FROM news_info " +
                   "WHERE IsActive = 1 AND IsVerified = 1 AND TypeID = @0 ORDER BY newsid DESC";

            DataSet dataset = DB.GetDataSet(sql, typeId);

            lstNews.DataSource = dataset.Tables[0].DefaultView;
            lstNews.DataBind();
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }

    protected string Left(object s, int length)
    {
        try
        {
            string ret;

            if (s.ToString().Trim() == "")
                return "---";
            if (s.ToString().Length > length)
            {
                ret = s.ToString();
                ret = ret.Substring(0, length) + "...";
            }
            else
            {
                return s.ToString();
            }
            return ret;
        }
        catch (Exception ex)
        {
            throw ex;
        }
    }
}
