﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

public partial class wh_P_Searchlist : System.Web.UI.Page
{
    const Int32 rows = 20;
    String jobType ,jobTypeValue ,key ,workarea ,IsSueDate ;

    protected void Page_Load(object sender, EventArgs e)
    {
        

        if (!IsPostBack)
        {
            //String jobType = Request.Form["funtype_big"].ToString();
            //String jobTypeValue = Request.Form["funtype"].ToString();
            //String key = Request.Form["key"].ToString();
            //string workarea = Request.Form["btnSltArea1"].ToString();
            //String IsSueDate = Request.Form["issuedate"].ToString();
            //
            ////*防止SQL注入
            //if (!DB.CheckParams(new object[] { jobType, jobTypeValue, key, workarea, IsSueDate }))
            //{
            //    Response.Redirect("ErrorSQLZR.aspx");
            //    return;
            //}



            saveCondition();
            //getRecordCount();
            txtPageIndex.Value = "1";
            loadData(Convert.ToInt32(txtPageIndex.Value));
            
        }
    }

    private void loadData(int pageNo)
    {
        try
        {
            if (pageNo == 0)
                pageNo = 1;
            object[] parameters = new object[10];
            Int16 ParamsNum = 0;

            String sql = String.Format("SELECT TOP ({0}) b.comid,b.jobid,b.jobName,a.companyname,b.work_city," +
                         "CASE b.salary WHEN 0 THEN '面议' ELSE CONVERT(VARCHAR(10),CONVERT(DECIMAL(10,2),b.Salary)) END salary," +
                         "CONVERT(VARCHAR(10),b.lastUpdate_Date,120) adddate ", rows);
            String fromSql = " FROM jobs b LEFT JOIN company_base a ON a.comid = b.comid ";
            String ordSql = " ORDER BY b.lastUpdate_Date DESC,b.comid";


            String where = "WHERE b.isactive=1 AND a.IsVerified=1  ";
            //职位类别
            if (jobTypeValue != "0-0" && jobTypeValue.Trim() != "")
            {
                if (jobType.IndexOf("-不限") >= 0)
                {
                    where += String.Format("AND b.jobclass LIKE @{0} ", ParamsNum);
                    parameters[ParamsNum] = '%' + jobTypeValue + '%';
                    ParamsNum++;
                }
                else
                {
                    where += String.Format("AND b.jobclass = @{0} ", ParamsNum);
                    parameters[ParamsNum] = jobTypeValue ;
                    ParamsNum++;
                }
            }
            ////学历要求
            //if (txtDegree.Value.Trim() != "无" && txtDegree.Value.Trim() != "")
            //{
            //    where += String.Format("AND b.education =@{0} ", ParamsNum);
            //    parameters[ParamsNum] = txtDegree.Value;
            //    ParamsNum++;
            //}
            ////工作年限
            //if (txtWorkYears.Value.Trim() != "0" && txtWorkYears.Value.Trim() != "")
            //{
            //    where += String.Format("AND b.work_years >= @{0} ", ParamsNum);
            //    parameters[ParamsNum] = txtWorkYears.Value;
            //    ParamsNum++;
            //}
            //在哪工作
            if (workarea.Trim() != "0" && workarea.Trim() != "")
            {
                where += String.Format("AND b.work_city = @{0} ", ParamsNum);
                parameters[ParamsNum] = workarea;
                ParamsNum++;
            }
            ////工作类型
            //if (txtJobType.Value.Trim() != "")
            //{
            //    where += String.Format("AND b.jobtype = @{0} ", ParamsNum);
            //    parameters[ParamsNum] = txtJobType.Value;
            //    ParamsNum++;
            //}
            ////薪水
            //if (txtSalary.Value.Trim() != "")
            //{
            //    where += String.Format("AND b.salary >= @{0} ", ParamsNum);
            //    parameters[ParamsNum] = txtSalary.Value;
            //    ParamsNum++;
            //}
            ////公司性质
            //if (txtCompanyType.Value.Trim() != "0" && txtCompanyType.Value.Trim() != "")
            //{
            //    where += String.Format("AND a.type = @{0} ", ParamsNum);
            //    parameters[ParamsNum] = txtCompanyType.Value;
            //    ParamsNum++;
            //}
            //发布日期
            if (IsSueDate.Trim() != "0" && IsSueDate.Trim() != "")
            {
                where += String.Format("AND DATEDIFF(dd, b.lastUpdate_date, GETDATE()) <= @{0} ", ParamsNum);
                parameters[ParamsNum] = IsSueDate;
                ParamsNum++;
            }
            //关键字
            if (key.Trim() != "")
            {
                where += String.Format("AND (b.jobName LIKE @{0} OR a.companyname LIKE @{0}) ", ParamsNum);
                parameters[ParamsNum] = "%" + key + "%";
                ParamsNum++;
            }

            String InSql = String.Format( " and b.jobid not in ( select top {0} b.jobid {1}) " ,rows * ( pageNo - 1) , fromSql + where + ordSql );

            sql = sql + fromSql + where + InSql + ordSql;
            String RowsSql = "select count(*) cnt " + fromSql + where;

            DataSet ds = DB.GetDataSet(RowsSql + ";" + sql, parameters);
            DataTable dt_rows = ds.Tables[0];

            Int32 recCnt = Convert.ToInt32(dt_rows.Rows[0]["cnt"].ToString());
            txtPagesCnt.Value = Common.getPageCnt(recCnt, rows).ToString();
            lblRecCount.Text = recCnt.ToString();
            if (txtPagesCnt.Value == "0")
            {
                lblCurrent1.Text = lblCurrent.Text = "无记录";
            }
            else
            {
                lblCurrent1.Text = lblCurrent.Text = String.Format("第{0}页", txtPageIndex.Value);
            }
            lblPageCount.Text = txtPagesCnt.Value;



            DataTable jobs = ds.Tables[1];
            grdJobList.DataSource = jobs;
            grdJobList.DataBind();
            lblCurrent1.Text = lblCurrent.Text = pageNo.ToString();
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }

    //private void getRecordCount()
    //{
    //    object[] parameters = new object[1];
    //    String sql = String.Format("SELECT COUNT(b.jobid) cnt  " +
    //                 "FROM jobs b LEFT JOIN company_base a ON a.comid = b.comid {0} ", getWhere(parameters));
    //    DataTable inbox = DB.GetDataSet(sql, parameters).Tables[0];
    //    Int32 recCnt = Convert.ToInt32(inbox.Rows[0]["cnt"].ToString());
    //    txtPagesCnt.Value = Common.getPageCnt(recCnt, rows).ToString();
    //    lblRecCount.Text = recCnt.ToString();
    //    if (txtPagesCnt.Value == "0")
    //    {
    //        lblCurrent1.Text = lblCurrent.Text = "无记录";
    //    }
    //    else
    //    {
    //        lblCurrent1.Text = lblCurrent.Text = String.Format("第{0}页", txtPageIndex.Value);
    //    }
    //    lblPageCount.Text = txtPagesCnt.Value;
    //}

    private void saveCondition()
    {
        //<!--  用来临时保存值，改用变量来保存 ，这是原页面中的定义
        //<asp:HiddenField ID="txtJobClass" runat="server" />
        //<asp:HiddenField ID="txtJobClassValue" runat="server" />
        //<asp:HiddenField ID="txtJobType" runat="server" />
        //<asp:HiddenField ID="txtWorkYears" runat="server" />
        //<asp:HiddenField ID="txtWorkarea" runat="server" />
        
        //<asp:HiddenField ID="txtDegree" runat="server" />
        //<asp:HiddenField ID="txtCompanyType" runat="server" />
        //<asp:HiddenField ID="txtSalary" runat="server" />
        //<asp:HiddenField ID="txtPublishDate" runat="server" />
        //<asp:HiddenField ID="txtKeyword" runat="server" />
        //<asp:HiddenField ID="txtPerId" runat="server" />
        //
        //
        //-->
        jobType = Request.Form["funtype_big"].ToString();
        jobTypeValue = Request.Form["funtype"].ToString();
        key = Request.Form["key"].ToString();
        workarea = Request.Form["btnSltArea1"].ToString();
        IsSueDate = Request.Form["issuedate"].ToString();

        //*防止SQL注入
        //if (!DB.CheckParams( new object[]{jobType,jobTypeValue,key,workarea,IsSueDate}))
        //{
        //    Response.Redirect("ErrorSQLZR.aspx");
        //    return ;
        //}


        jobTypeValue = jobTypeValue == "（全部）不限" ? "" : jobTypeValue;

        if (jobType == "不限")
        {
            jobType = "0-0";
            jobTypeValue = "";
        }
        else
        {
            if (jobTypeValue.Contains("（全部）") && jobTypeValue.Contains("类"))
            {
                jobTypeValue = jobTypeValue.Substring(4, jobTypeValue.Length - 5);
                jobType = jobTypeValue + "-不限";
            }
            else
            {
                jobTypeValue = jobType + "-" + jobTypeValue;
            }
        }

        
        key = key == "请输入关键字" ? "" : key;

        //txtJobClass.Value = jobType;
        //txtJobClassValue.Value = jobTypeValue;
        //txtWorkarea.Value = workarea;
        //txtPublishDate.Value = IsSueDate;
        //txtKeyword.Value = key;

    }

    //private String getWhere(object[] parameters)
    //{
    //    //*防止SQL注入
    //    //if (!DB.CheckParams( new object[]{jobTypeValue, jobType, txtDegree.Value, txtWorkYears.Value, workarea, txtJobType.Value, txtSalary.Value, txtCompanyType.Value, IsSueDate, key}))
    //    //{
    //    //    Response.Redirect("ErrorSQLZR.aspx");
    //    //    return "";
    //    //}

    //    String where = "WHERE b.isactive=1 AND a.IsVerified=1  ";
    //    //职位类别
    //    if (jobTypeValue != "0-0" && jobTypeValue.Trim() != "")
    //    {
    //        if (jobType.IndexOf("-不限") >= 0)
    //            where += String.Format("AND b.jobclass LIKE '%{0}%'", jobTypeValue);
    //        else
    //            where += String.Format("AND b.jobclass ='{0}' ", jobTypeValue);
    //    }
    //    //学历要求
    //    if (txtDegree.Value.Trim() != "无" && txtDegree.Value.Trim() != "")
    //        where += String.Format("AND b.education ='{0}' ", txtDegree.Value);
    //    //工作年限
    //    if (txtWorkYears.Value.Trim() != "0" && txtWorkYears.Value.Trim() != "")
    //        where += String.Format("AND b.work_years ={0} ", txtWorkYears.Value);
    //    //在哪工作
    //    if (workarea.Trim() != "0" && workarea.Trim() != "")
    //        where += String.Format("AND b.work_city ='{0}' ", workarea);
    //    //工作类型
    //    if (txtJobType.Value.Trim() != "")
    //        where += String.Format("AND b.jobtype ={0} ", txtJobType.Value);
    //    //薪水
    //    if (txtSalary.Value.Trim() != "")
    //        where += String.Format("AND b.salary ={0} ", txtSalary.Value);
    //    //公司性质
    //    if (txtCompanyType.Value.Trim() != "0" && txtCompanyType.Value.Trim() != "")
    //        where += String.Format("AND a.type ='{0}' ", txtCompanyType.Value);
    //    //发布日期
    //    if (IsSueDate.Trim() != "0" && IsSueDate.Trim() != "")
    //        where += String.Format("AND DATEDIFF(dd, b.lastUpdate_date, GETDATE()) <= {0} ", IsSueDate);
    //    //关键字
    //    if (key.Trim() != "")
    //    {
    //        where += "AND (b.jobName LIKE @0 OR a.companyname LIKE @0) ";
    //        parameters[0] = "%" + key + "%";
    //    }
    //    return where;
    //}


    protected void btnFirst_Click(object sender, EventArgs e)
    {
        txtPageIndex.Value = "1";
        loadData(Convert.ToInt32(txtPageIndex.Value));

    }

    protected void btnPer_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtPageIndex.Value);

        if (index - 1 < 1)
            txtPageIndex.Value = "1";
        else
            txtPageIndex.Value = Convert.ToString(--index);

        loadData(Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnNext_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtPageIndex.Value);
        if (index + 1 > Convert.ToInt32(txtPagesCnt.Value))
            txtPageIndex.Value = txtPagesCnt.Value;
        else
            txtPageIndex.Value = Convert.ToString(++index);

        loadData(Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnLast_Click(object sender, EventArgs e)
    {
        txtPageIndex.Value = txtPagesCnt.Value;
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }

    protected void btnGoto_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtGo.Text);
        txtPageIndex.Value = index.ToString();
        
        if (index < 1 || index == null )
            txtPageIndex.Value = "1";
        if (index > Convert.ToInt32(txtPagesCnt.Value))
            txtPageIndex.Value = txtPagesCnt.Value;

        txtGo.Text = txtPageIndex.Value;
        loadData( Convert.ToInt32(txtPageIndex.Value) );

    }
    protected void grdJobList_RowEditing(object sender, GridViewEditEventArgs e)
    {
        try
        {
            int rowIndex = e.NewEditIndex;
            String jobId = ((Label)grdJobList.Rows[rowIndex].FindControl("lblJobId")).Text;
            Response.Write("<Script>window.open('JobInfo.aspx?jobid=" + jobId + "')</script>");

        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
        }

    }

    protected void btnAddFavorite1_Click(object sender, EventArgs e)
    {

        if (Session["perid"] == null) Response.Redirect("index.aspx");

        CheckBox chkSelect;
        String perid = Session["perid"].ToString();
        String sql = String.Empty;
        ArrayList paramList = new ArrayList();

        SqlConnection conn = null;
        SqlTransaction trans = null;
        bool transBegin = false;
        int checkCnt = 0;

        //*防止SQL注入
        //if (!DB.CheckParams(new object[] { perid }))
        //{
        //    Response.Redirect("ErrorSQLZR.aspx");
        //    return;
        //}



        try
        {
            conn = DB.GetConnection();

            SqlCommand cmd = new SqlCommand();
            cmd.Connection = conn;
            cmd.CommandType = CommandType.Text;
            trans = conn.BeginTransaction();
            cmd.Transaction = trans;
            transBegin = true;

            sql = "SELECT jobid FROM personal_favorites WHERE perid= @0";

            DataTable favorites = DB.GetDataSet(conn, sql, trans, DB.Params2SqlParameter(perid)).Tables[0];
            favorites.PrimaryKey = new DataColumn[] { favorites.Columns["jobid"] };
            for (int i = 0; i < grdJobList.Rows.Count; i++)
            {
                chkSelect = (CheckBox)grdJobList.Rows[i].FindControl("chkSelect");
                if (chkSelect.Checked)
                {
                    checkCnt++;
                    String jobid = ((Label)grdJobList.Rows[i].FindControl("lblJobId")).Text;
                    String comid = ((Label)grdJobList.Rows[i].FindControl("lblComId")).Text;

                    //*防止SQL注入
                    //if (!DB.CheckParams(new object[] { comid, jobid }))
                    //{
                    //    Response.Redirect("ErrorSQLZR.aspx");
                    //    return;
                    //}

                    if (favorites.Rows.Find(jobid) == null)
                    {
                        sql = "INSERT INTO personal_favorites(perid,comid,jobid,adddate) " +
                                 "VALUES( @0,@1,@2,GETDATE())";
                        cmd.Parameters.Clear();
                        SqlParameter[] parameters = new SqlParameter[3];
                        parameters[0] = new SqlParameter();
                        parameters[0].ParameterName = "@0" ;
                        parameters[0].Value = perid;
                        cmd.Parameters.Add(parameters[0]);

                        parameters[1] = new SqlParameter();
                        parameters[1].ParameterName = "@1";
                        parameters[1].Value = comid;
                        cmd.Parameters.Add(parameters[1]);

                        parameters[2] = new SqlParameter();
                        parameters[2].ParameterName = "@2";
                        parameters[2].Value = jobid;
                        cmd.Parameters.Add(parameters[2]);

                        cmd.CommandText = sql;
                        cmd.ExecuteNonQuery();
                    }
                }
            }
            trans.Commit();
            transBegin = false;
            Session["perid"] = perid;
            if (checkCnt > 0)
                Common.Alert("选中职位已添加到收藏夹!", this);
        }
        catch (Exception ex)
        {
            if (transBegin)
                trans.Rollback();
            Response.Write(ex.Message);
            Response.End();
        }
        finally
        {
            if (conn != null && conn.State == ConnectionState.Open)
                conn.Close();
        }
    }
    protected void btnGoto2_Click(object sender, EventArgs e)
    {
        int index = Convert.ToInt32(txtGo2.Text);
        txtPageIndex.Value = index.ToString() ;
        if (index < 1 || index == null )
            txtPageIndex.Value = "1";
        if (index > Convert.ToInt32(txtPagesCnt.Value))
            txtPageIndex.Value = txtPagesCnt.Value;

        txtGo2.Text = txtPageIndex.Value;
        loadData(Convert.ToInt32(txtPageIndex.Value));
    }
}
