using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Person_CompanyInfo : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            loadBaseInfo(Request.QueryString["comid"].ToString());
        }
    }

    private void loadBaseInfo(String comid)
    {
        txtComId.Value = comid;

        String sql = "SELECT * FROM company_base WHERE comid = @0";
        DataTable company = DB.GetDataSet(sql, comid).Tables[0];

        if (company.Rows.Count > 0)
        {
            DataRow row = company.Rows[0];

            lblCompany.Text = Convert.ToString(row["companyname"]);
            lblLicense.Text = Convert.ToString(row["license"]);
            lblIndustry.Text = row["industry"].ToString();
            lblType.Text = row["Type"].ToString();

            lblFoundDate.Text = Convert.ToString(row["found_year"]) + "-" + Convert.ToString(row["found_month"]) + "-" + Convert.ToString(row["found_day"]);

            lblRegCapital.Text = Convert.ToString(row["reg_capital"]);
            String currency = Convert.ToString(row["reg_currency"]);
            String currencyName = "";
            if (currency.CompareTo("0") == 0)
                currencyName += "";
            else if (currency.CompareTo("1") == 0)
                currencyName += "Ԫ";
            else if (currency.CompareTo("2") == 0)
                currencyName += "ŷԪ";
            else if (currency.CompareTo("3") == 0)
                currencyName += "۱";
            else if (currency.CompareTo("4") == 0)
                currencyName += "̨";
            else if (currency.CompareTo("5") == 0)
                currencyName += "Ӣ";
            lblRegCurrency.Text = currencyName;
            lblWorkers.Text = Convert.ToString(row["workers"]);
            lblProvinceCity.Text = Convert.ToString(row["province"]) + Convert.ToString(row["city"]);
            lblMemo.Text = Convert.ToString(row["memo"]);
            lblPhone.Text = Convert.ToString(row["contact_phone"]);
            lblContactPerson.Text = Convert.ToString(row["contact_person"]);

            lblFax.Text = Convert.ToString(row["contact_fax"]);
            lblEmail.Text = Convert.ToString(row["email"]);
            lblWebsite.Text = Convert.ToString(row["website"]);
            lblZipCode.Text = Convert.ToString(row["zipcode"]);
            lblAddress.Text = Convert.ToString(row["address"]);

            if (Convert.ToString(row["Logo_Url"]) != null && Convert.ToString(row["Logo_Url"]) != "")
                //imgLogo.ImageUrl = "../Company/" + Convert.ToString(row["Logo_Url"]);
                imgLogo.ImageUrl = getPicUrl(Convert.ToString(row["Logo_Url"]), comid);
            else
                imgLogo.ImageUrl = "../Images/Company.gif";
        }
    }

    protected string getPicUrl(string url, string id)
    {
        string path = Server.MapPath("~/temp/image/");
        return Common.downloadFile(url, path, id, "~/temp/image/");
    }
}
