﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Person_MailView : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Request.QueryString["param"]!=null)
                loadData(Request.QueryString["param"].ToString());    
        }
    }

    private void loadData(String id)
    {
        String sql = "SELECT b.companyName,c.jobname,a.adddate,a.title,a.content "+
                     "FROM personal_inbox a LEFT JOIN company_base b ON a.comid =b.comid " +
                     "LEFT JOIN jobs c ON a.jobid=c.jobid WHERE id=@0";
        DataTable inbox = DB.GetDataSet(sql, id).Tables[0];
        if (inbox.Rows.Count > 0)
        {
            DataRow row = inbox.Rows[0];
            lblCompany.Text = Convert.ToString(row["companyName"]);
            lblJobName.Text = Convert.ToString(row["jobname"]);
            lblTime.Text = Convert.ToString(row["adddate"]);
            lblTitle.Text = Convert.ToString(row["title"]);
            lblContent.Text = Convert.ToString(row["content"]).Replace("\r\n", "</br>"); ;
        }

        sql = "UPDATE personal_inbox SET isread=1 WHERE id=@0";
        DB.ExecuteSQL(sql, id);
    }
}
