﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Person_PersonEducation : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Session["perid"] != null)
            {
                InitForm();
            }
        }
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            ArrayList paramList = new ArrayList();
            String sql = string.Empty;
            if (txtNcId.Value.Trim() != "")
            {
                sql = "UPDATE personal_education SET schoolname=@1,beginDate_year=@2,begindate_month=@3," +
                             "enddate_year=@4,enddate_month=@5,magorin_type=@6,magorin_class=@7,degree=@8,memo=@9,type=@10 " +
                             "WHERE ncid=@0";
                paramList.Add(txtNcId.Value);
            }
            else
            {
                sql = "INSERT INTO personal_education(perid,schoolname,beginDate_year,begindate_month," +
                             "enddate_year,enddate_month,magorin_type,magorin_class,degree,memo,type) " +
                             "VALUES(@0,@1,@2,@3,@4,@5,@6,@7,@8,@9,@10)";
                paramList.Add(txtPerId.Value);
            }
            
            
            paramList.Add(txtSchoolName.Text);
            paramList.Add(Convert.ToInt32(txtBeginYear.Text));
            paramList.Add(Convert.ToInt32(cmbBeginMonth.Text));
            paramList.Add(Convert.ToInt32(txtEndYear.Text));
            paramList.Add(Convert.ToInt32(cmbEndMonth.Text));
            paramList.Add(txtMagorinType.Text);
            paramList.Add(txtMagorinClass.Text);
            paramList.Add(cmbDegree.Text);
            paramList.Add(txtMemo.Text);
            paramList.Add(Convert.ToInt32(cmbType.SelectedValue));

            DB.ExecuteSQL(sql,paramList);
            DB.setLastUpdateTime(txtPerId.Value);

            ClearData();
            LoadData(txtPerId.Value);

            txtNcId.Value = "";
            Session["perid"] = txtPerId.Value; 
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }

    private void InitForm()
    {
        txtPerId.Value = Session["perid"].ToString();
        InitMonth();
        LoadData(Session["perid"].ToString());
    }

    private void LoadData(String perid)
    {
        String sql = "SELECT ncid,schoolname,magorin_type," +
                     "CAST(begindate_year AS VARCHAR)+ '.' + RIGHT('00' + CAST(begindate_month AS VARCHAR), 2) " +
                     " + '---' + " +
                     "CAST(enddate_year AS VARCHAR)+ '.' + RIGHT('00' + CAST(enddate_month AS VARCHAR), 2) beTime " +
                     "FROM personal_education WHERE perid=@0 ";
        sql = sql +  " AND type=0;" +sql +" AND type=1;";

        DataSet user = DB.GetDataSet(sql, perid);
        DataTable education = user.Tables[0];
        DataTable train = user.Tables[1];

        grdEducation.DataSource = user;
        grdEducation.DataBind();

        grdTrain.DataSource = train;
        grdTrain.DataBind();
    }

    private void InitMonth()
    {
        for (int i = 1; i < 13; ++i)
        {
            cmbBeginMonth.Items.Add(i.ToString());
            cmbEndMonth.Items.Add(i.ToString());
        }
    }

    private void ClearData()
    {
        txtSchoolName.Text = "";
        txtBeginYear.Text = "";
        txtEndYear.Text = "";
        txtMagorinClass.Text = "";
        txtMagorinType.Text = "";
        txtMemo.Text = "";
        cmbBeginMonth.SelectedIndex = 0;
        cmbEndMonth.SelectedIndex = 0;
        cmbType.SelectedIndex = 0;
        cmbDegree.SelectedIndex = 0;
    }
    protected void grdEducation_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        String ncid = ((Label)grdEducation.Rows[e.RowIndex].FindControl("lblNcId")).Text;
        DeleteItem(ncid);
    }
    protected void grdTrain_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        String ncid = ((Label)grdTrain.Rows[e.RowIndex].FindControl("lblNcId")).Text;
        DeleteItem(ncid);
    }

    private void DeleteItem(String ncid)
    {
        try
        {
            String sql = "DELETE FROM personal_education WHERE ncid=@0";
            DB.ExecuteSQL(sql,ncid);
            ClearData();
            LoadData(txtPerId.Value);
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }
    protected void grdEducation_RowEditing(object sender, GridViewEditEventArgs e)
    {
        String ncid = ((Label)grdEducation.Rows[e.NewEditIndex].FindControl("lblNcId")).Text;
        UpdateItem(ncid);
    }
    protected void grdTrain_RowEditing(object sender, GridViewEditEventArgs e)
    {
        String ncid = ((Label)grdTrain.Rows[e.NewEditIndex].FindControl("lblNcId")).Text;
        UpdateItem(ncid);
    }

    private void UpdateItem(String ncid)
    {
        try
        {
            String sql = "SELECT * FROM personal_education WHERE ncid = @0";
            DataTable education = DB.GetDataSet(sql, ncid).Tables[0];
            if (education.Rows.Count > 0)
            {
                DataRow row = education.Rows[0];
                txtSchoolName.Text = row["schoolname"].ToString();
                txtBeginYear.Text = row["begindate_year"].ToString();
                txtEndYear.Text = row["enddate_year"].ToString();
                cmbBeginMonth.SelectedValue = row["begindate_month"].ToString();
                cmbEndMonth.SelectedValue = row["enddate_month"].ToString();
                txtMagorinType.Text = row["magorin_type"].ToString();
                txtMagorinClass.Text = row["magorin_class"].ToString();
                cmbDegree.SelectedIndex = cmbDegree.Items.IndexOf( new ListItem( row["degree"].ToString()));
                txtMemo.Text = row["memo"].ToString();
                cmbType.SelectedValue = row["type"].ToString();
                txtNcId.Value = ncid;
            }
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }
}
