﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Person_PersonLogo : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Session["perid"] != null)
            {
                txtPerId.Value = Session["perid"].ToString();
                loadImage();
            }
            else
                Response.Redirect("~/include/Register_Person.aspx?mode=0");
        }
    }

    protected void btnUpload_Click(object sender, EventArgs e)
    {
        uploadFile();
    }

    protected void Button1_Click(object sender, EventArgs e)
    {
        try
        {
            String sql = "UPDATE personal_info SET photo_url='' WHERE perid=@0";
            DB.ExecuteSQL(sql,txtPerId.Value);
            Image1.ImageUrl = "~/Images/Company.gif";
            Label1.Text = "图片标识已删除";
        }
        catch (Exception ex)
        {
            Label1.Text = ex.Message;
        }
    }

    private bool loadImage()
    {
        bool ret = false;
        String sql = "SELECT photo_url FROM personal_info WHERE perid=@0";
        DataTable logo = DB.GetDataSet(sql, txtPerId.Value).Tables[0];

        if (logo.Rows.Count > 0)
        {
            String url = Convert.ToString(logo.Rows[0]["photo_url"]);
            if (url.Trim() != "")
            {
                string path = Server.MapPath("~/temp/image/");
                string picUrl = Common.downloadFile(url, path, txtPerId.Value, "~/temp/image/");
                if (picUrl != "")
                {
                    Image1.ImageUrl = picUrl;
                    ret = true;
                }
            }
        }
        return ret;
    }

    private void uploadFile()
    {
        Boolean fileOK = false;
        String path = Server.MapPath("~/person/photo/");
        String fileExtension = "";

        if (FileUpload1.HasFile)
        {
            long MaxLength = Convert.ToInt32(ConfigurationManager.AppSettings["FileMax"]) * 1024;
            if (FileUpload1.FileContent.Length > MaxLength)
            {
                Label1.Text = "文件大小超出限制";
                return;
            }
            fileExtension = System.IO.Path.GetExtension(FileUpload1.FileName).ToLower();
            String[] allowedExtensions = { ".gif", ".jpeg", ".jpg" };
            for (int i = 0; i < allowedExtensions.Length; i++)
            {
                if (fileExtension == allowedExtensions[i])
                    fileOK = true;
            }
        }

        if (fileOK)
        {
            try
            {
                FileUpload1.PostedFile.SaveAs(path + txtPerId.Value + fileExtension);
                String url = "photo/" + txtPerId.Value + fileExtension;

                //string fileServerUrl = ConfigurationManager.AppSettings["FileServer"].ToString();
                //if (fileServerUrl.Equals("")) fileServerUrl = "http://192.168.112.25/Upload/";

                //string postUrl = fileServerUrl + "uploadpic.aspx?type=person&filename=" + txtPerId.Value + fileExtension;
                //byte[] fileByte = new byte[FileUpload1.PostedFile.InputStream.Length];
                //FileUpload1.PostedFile.InputStream.Read(fileByte, 0, fileByte.Length);
                //System.Net.WebClient webClient = new System.Net.WebClient();
                //byte[] responseArray = webClient.UploadData(postUrl, "POST", fileByte);

                ////将返回的字节数据转成字符串（也就是uploadpic.aspx里面的页面输出内容）
                //string result = System.Text.Encoding.Default.GetString(responseArray, 0, responseArray.Length);

                ////返回结果的处理
                //switch (result)
                //{
                //    case "-1":
                //        Label1.Text = "上传头像时发生异常，未提交成功。";
                //        return;
                //    case "0":
                //        Label1.Text = "您还未选择图片。";
                //        return;
                //}

                //url = fileServerUrl + "person/photo/" + txtPerId.Value + fileExtension;

                url = Common.uploadFile(FileUpload1.PostedFile, "person", txtPerId.Value + fileExtension);
                if (url.Equals("")) { Label1.Text = "上传图片失败。"; return; }

                String sql = "UPDATE personal_info SET photo_url=@0 WHERE perid=@1";
                ArrayList paramList = new ArrayList();
                paramList.Add( url);
                paramList.Add( txtPerId.Value);
                DB.ExecuteSQL(sql,paramList);

                Image1.ImageUrl = "photo/" + txtPerId.Value + fileExtension;
                Label1.Text = "文件上传成功";
            }
            catch (Exception ex)
            {
                Label1.Text = String.Format("文件上传失败-{0}", ex.Message);
            }
        }
        else
        {
            Label1.Text = "不能上传这种类型的文件";
        }

    }
}
