﻿ using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Person_PersonSkill : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Session["perid"] != null)
            {
                InitForm();
            }
        }
    }

    private void InitForm()
    {
        txtPerId.Value = Session["perid"].ToString();
        LoadData(Session["perid"].ToString());
    }

    protected void grdSkill_RowEditing(object sender, GridViewEditEventArgs e)
    {
        String ncid = ((Label)grdSkill.Rows[e.NewEditIndex].FindControl("lblNcId")).Text;
        UpdateItem(ncid); 
    }

    private void UpdateItem(String ncid)
    {
        try
        {
            String sql = "SELECT * FROM personal_skill WHERE ncid=@0";
            DataTable work = DB.GetDataSet(sql, ncid).Tables[0];
            if (work.Rows.Count > 0)
            {
                DataRow row = work.Rows[0];
                cmbSkillType.SelectedValue = row["skilltype"].ToString();
                txtSkillName.Text = row["skillName"].ToString();
                txtUseYears.Text = row["usedyears"].ToString();
                cmbDegree.SelectedIndex = cmbDegree.Items.IndexOf(new ListItem(row["degree"].ToString()));
                txtMemo.Text = row["memo"].ToString();
                txtNcId.Value = ncid;
            }
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }

    protected void grdSkill_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        String ncid = ((Label)grdSkill.Rows[e.RowIndex].FindControl("lblNcId")).Text;
        DeleteItem(ncid);
    }

    private void DeleteItem(String ncid)
    {
        try
        {
            String sql = "DELETE FROM personal_skill WHERE ncid=@0";
            DB.ExecuteSQL(sql,ncid);
            ClearData();
            LoadData(txtPerId.Value);
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }

    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            ArrayList paramList = new ArrayList();
            String sql = string.Empty;
            if (txtNcId.Value.Trim() != "")
            {
                sql = "UPDATE personal_skill SET skilltype=@0,skillname=@1,usedyears=@2," +
                             "degree=@3,memo=@4 " +
                             "WHERE ncid=@0";
                paramList.Add(txtNcId.Value);
            }
            else
            {
                sql = "INSERT INTO personal_skill(perid,skilltype,skillname,usedyears," +
                             "degree,memo) " +
                             "VALUES(@0,@1,@2,@3,@4,@5)";
                paramList.Add(txtPerId.Value);
            }

            paramList.Add(Convert.ToInt32(cmbSkillType.Text));
            paramList.Add(txtSkillName.Text);
            int usedYears = 0;
            if (txtUseYears.Text.Trim() != "")
                usedYears = Convert.ToInt32(txtUseYears.Text);
            paramList.Add(usedYears);
            paramList.Add(cmbDegree.Text);
            paramList.Add(txtMemo.Text);

            DB.ExecuteSQL(sql, paramList);
            DB.setLastUpdateTime(txtPerId.Value);

            ClearData();
            LoadData(txtPerId.Value);

            txtNcId.Value = "";
            Session["perid"] = txtPerId.Value;
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }

    private void LoadData(String perid)
    {
        String sql = "SELECT ncid, " +
                     "CASE skilltype WHEN 0 THEN '外语技能' WHEN 1 THEN 'IT技能' WHEN 2 THEN '证书' " +
                     "WHEN 3 THEN '其他' END AS skilltype, skillname, degree " +
                     "FROM personal_skill WHERE perid = @0 ORDER BY skilltype";

        DataSet user = DB.GetDataSet(sql,perid);
        DataTable education = user.Tables[0];

        grdSkill.DataSource = user;
        grdSkill.DataBind();
    }

    private void ClearData()
    {
        cmbSkillType.SelectedIndex= 0;
        txtSkillName.Text = "";
        txtUseYears.Text = "";
        cmbDegree.SelectedIndex = 0;
        txtMemo.Text = "";
    }
}
