﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Person_PersonWill : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            loadData();
        }
    }

    private void loadData()
    {
        try
        { 
            if (Session["perid"] == null)
            {
                Response.Redirect("~/default.aspx");
                return;
            }
            String perid = Session["perid"].ToString();
            String sql = "SELECT * FROM personal_will WHERE perid=@0";
            DataTable will = DB.GetDataSet(sql, perid).Tables[0];
            if (will.Rows.Count > 0)
            { 
                DataRow row = will.Rows[0];
                Type = Convert.ToInt16(row["jobtype"].ToString());
                setList(lstJobClass, row["jobclass1"].ToString());
                setList(lstJobClass, row["jobclass2"].ToString());
                setList(lstJobClass, row["jobclass3"].ToString());
                setList(lstJobClass, row["jobclass4"].ToString());
                setList(lstJobClass, row["jobclass5"].ToString());
                setList(lstWorkArea, row["workarea1"].ToString());
                setList(lstWorkArea, row["workarea2"].ToString());
                setList(lstWorkArea, row["workarea3"].ToString());
                setList(lstWorkArea, row["workarea4"].ToString());
                setList(lstWorkArea, row["workarea5"].ToString());
                txtJobName1.Text = row["jobname1"].ToString();
                txtJobName2.Text = row["jobname2"].ToString();
                txtJobName3.Text = row["jobname3"].ToString();
                txtJobName4.Text = row["jobname4"].ToString();
                txtJobName5.Text = row["jobname5"].ToString();
                txtSalary.Text = row["salary"].ToString() == "0" ? "" : row["salary"].ToString();
                txtMemo.Text = row["memo"].ToString();
            }

        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }

    private void setList(ListBox lstObject,String value)
    {
        if (value.Trim() != "")
        {
            String[] array = value.Split('|');
            lstObject.Items.Add(new ListItem(array[0],array[1]));
        }
    }

    protected void btnSave_Click(object sender, EventArgs e)
    {
        fillList();
        try
        {
            if (Session["perid"] == null)
            {
                Response.Redirect("~/default.aspx");
                return;
            }
            ArrayList paramList = new ArrayList();
            String perid = Session["perid"].ToString();
            String sql = "SELECT perid FROM personal_will WHERE perid=@0";

            if (DB.GetDataSet(sql, perid).Tables[0].Rows.Count > 0)
            {
                sql = "UPDATE personal_will SET jobtype=@1,workarea1=@2,workarea2=@3,workarea3=@4,workarea4=@5,workarea5=@6," +
                      "jobclass1=@7,jobclass2=@8,jobclass3=@9,jobclass4=@10,jobclass5=@11,jobname1=@12,jobname2=@13,jobname3=@14,jobname4=@15,jobname5=@16," +
                      "salary=@17,memo=@18,Update_Date=@19 where perid=@0";
            }
            else 
            {
                sql = "INSERT INTO personal_will(perid,jobtype,workarea1,workarea2,workarea3,workarea4,workarea5," +
                      "jobclass1,jobclass2,jobclass3,jobclass4,jobclass5,jobname1,jobname2,jobname3,jobname4,jobname5," +
                      "salary,memo,Update_Date) " +
                      "VALUES(@0,@1,@2,@3,@4,@5,@6,@7,@8,@9,@10,@11,@12,@13,@14,@15,@16,@17,@18,@19)";
                
            }

            String[] jobClass = getList(lstJobClass);
            String[] workArea = getList(lstWorkArea);
            paramList.Add(perid);
            paramList.Add(Type);
            paramList.Add(workArea[0]);
            paramList.Add(workArea[1]);
            paramList.Add(workArea[2]);
            paramList.Add(workArea[3]);
            paramList.Add(workArea[4]);
            paramList.Add(jobClass[0]);
            paramList.Add(jobClass[1]);
            paramList.Add(jobClass[2]);
            paramList.Add(jobClass[3]);
            paramList.Add(jobClass[4]);
            paramList.Add(txtJobName1.Text);
            paramList.Add(txtJobName2.Text);
            paramList.Add(txtJobName3.Text);
            paramList.Add(txtJobName4.Text);
            paramList.Add(txtJobName5.Text);
            paramList.Add(getSalary());
            paramList.Add(txtMemo.Text);
            paramList.Add(new DateTime().ToString("yyyy-MM-dd"));

            DB.ExecuteSQL(sql, paramList);
            Common.Alert("保存数据成功!",this);
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
            Response.End();
        }
    }

    private int getSalary()
    {
        int salary = 0;
        if (txtSalary.Text.Trim() != "")
        {
            salary = Convert.ToInt32(txtSalary.Text);
        }
        return salary;
    }

    private int Type
    { 
        get
        {
            int ret = 0;
            if (rdoFullTime.Checked)
                ret = 0;
            if (rdoPartTime.Checked)
                ret = 1;
            if (rdoOther.Checked)
                ret = 2;
            return ret;
        }
        set
        {
            switch (value)
            { 
                case 0:
                    rdoFullTime.Checked = true;
                    break;
                case 1:
                    rdoPartTime.Checked = true;
                    break;
                case 2:
                    rdoOther.Checked = true;
                    break;
            }
        }
    }


    private String[] getList(ListBox lstObject)
    {
        String[] jobClass = new string[5];
        for (int i = 0; i < 5; ++i)
        {
            jobClass[i] = "";    
        }
        for (int i = 0; i < lstObject.Items.Count; ++i)
        {
            jobClass[i] = lstObject.Items[i].Text + "|" + lstObject.Items[i].Value;
        }
        return jobClass;
    }


    private void fillList()
    {
        String []job = txtJob.Value.Split(';');
        String []area = txtArea.Value.Split(';');
        String [] jobvalue = txtJobValue.Value.Split(';');
        String [] areavalue = txtAreaValue.Value.Split(';');
        lstJobClass.Items.Clear();
        lstWorkArea.Items.Clear();
        for (int i = 0; i < job.Length; ++i)
        {
            if (job[i].Trim() != "")
            {
                lstJobClass.Items.Add(new ListItem(job[i],jobvalue[i]));
            }
        }

        for (int i = 0; i < area.Length; ++i)
        {
            if (area[i].Trim() != "")
            {
                lstWorkArea.Items.Add(new ListItem(area[i],areavalue[i]));
            }
        }
    }
}
