﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Person_Register : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            String path = Request.PhysicalApplicationPath;
            path = System.IO.Path.GetDirectoryName(path) + "\\" + ConfigurationManager.AppSettings["Agreement"].ToString();
            txtAgreement.Text = Common.ReadFile(path);


        }
    }
    protected void btnRegister_Click(object sender, EventArgs e)
    {
        String sql = "SELECT * FROM personal_checkcode where MobilePhone = @0";
        object[] parameters = new object[1];
        parameters[0] = txtUserName.Text.Trim();
        DataSet ds = DB.GetDataSet(sql, parameters);
        if (ds != null && ds.Tables[0].Rows.Count > 0)
        {
            String code = ds.Tables[0].Rows[0]["CheckCode"].ToString();

        }
        else
        {
            Response.Write("<script>alert('您输入的验证码错误！');</script>");
            return;
        }

        Server.Transfer("Register2.aspx");
    }
    protected void btnCheckId_Click(object sender, EventArgs e)
    {
        if (txtUserName.Text.Trim().Length != 11)
        {
            Response.Write("<script>alert('必须使用手机号码注册，长度为11位');</script>");
            return;
        }
        String sql = "SELECT * FROM personal_base where username = @0";
        object[] parameters = new object[1];
        parameters[0] = txtUserName.Text;
        if (DB.GetDataSet(sql, parameters).Tables[0].Rows.Count > 0)
        {
            Response.Write("<script>alert('已存在相同的用户，请更换手机号');</script>");
        }
        else
        {
            Response.Write("<script>alert('可使用当前手机号注册');</script>");
        }
    }
    protected void btnCode_Click(object sender, EventArgs e)
    {
        if (txtUserName.Text.Trim().Length != 11)
        {
            Response.Write("<script>alert('请先输入正确的手机号码！');</script>");
            return;
        }

        String checkCode = RndNum(4);

        String sql = "delete from personal_checkcode where MobilePhone=@0";
        DB.ExecuteSQL(sql, txtUserName.Text.Trim());

        sql = "INSERT INTO personal_checkcode(MobilePhone, CheckCode, SendTime) " +
                      "VALUES(@0,@1,GETDATE())";

        ArrayList paramList = new ArrayList();
        paramList.Add(txtUserName.Text.Trim());
        paramList.Add(checkCode);

        DB.ExecuteSQL(sql, paramList);

        sendSms(txtUserName.Text.Trim(), "欢迎注册梅州就业通服务平台，手机验证码为:" + checkCode, "System");
        Response.Write("<script>alert('验证码已经发送成功，请注意查收！');</script>");
    }

    protected void sendSms(String mobile, String content, String userName)
    {
        ArrayList listParam = new ArrayList();
        String sql = "INSERT INTO send_sms(Mobilephone, MessageContent, UserName) " +
                          "VALUES(@0,@1,@2)";

        listParam.Add(mobile);
        listParam.Add(content);
        listParam.Add(userName);

        DB.ExecuteSQL(sql, listParam);
    }

    private string RndNum(int VcodeNum)
    {
        string Vchar = "0,1,2,3,4,5,6,7,8,9,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p" +
        ",q,r,s,t,u,v,w,x,y,z";
        string[] VcArray = Vchar.Split(new Char[] { ',' });
        string VNum = "";
        int temp = -1;

        Random rand = new Random();

        for (int i = 1; i < VcodeNum + 1; i++)
        {
            if (temp != -1)
            {
                rand = new Random(i * temp * unchecked((int)DateTime.Now.Ticks));
            }

            int t = rand.Next(35);
            if (temp != -1 && temp == t)
            {
                return RndNum(VcodeNum);
            }
            temp = t;
            VNum += VcArray[t];
        }
        return VNum;
    }
}
